/*
 * Decompiled with CFR 0.152.
 */
package cocon;

import cocon.CoFolder;
import cocon.util.Position;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;
import miningmart.hci.gui.main.Application;
import miningmart.m4.Chain;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;

public class CoMMFolder
extends CoFolder {
    private Chain chain;

    public CoMMFolder() {
        this.initCoFolder();
    }

    public CoMMFolder(CoFolder folder) {
        super(folder);
    }

    public CoMMFolder(String name) {
        super(name);
        this.initCoFolder();
    }

    public CoMMFolder(Chain chain) {
        super(chain.getName().substring(chain.getName().lastIndexOf(".") + 1));
        this.chain = chain;
        this.initCoFolder();
    }

    public void setName(String name) {
        if (this.getName() == null || this.getName().equals("")) {
            super.setName(name);
            return;
        }
        if (this.getName().equals(name)) {
            return;
        }
        if (Application.mmWorkspace.isReadOnly()) {
            return;
        }
        super.setName(name);
        if (this.getName().equals("")) {
            return;
        }
        if (this.chain != null) {
            try {
                String oldValue = this.chain.getName();
                String newValue = String.valueOf(this.chain.getName().substring(0, this.chain.getName().lastIndexOf("."))) + "." + name;
                this.chain.setName(newValue);
                this.firePropertyChange("ChainName", oldValue, newValue);
                this.chain.store();
            }
            catch (NameExistsException nee) {
                JOptionPane.showMessageDialog(Application.frame, "Please choose another name for the chain", "Name already exists!", 0);
                return;
            }
            catch (StorageException se) {
                se.printStackTrace();
            }
        }
    }

    public String getChainName() {
        return this.chain.getName();
    }

    public Chain getChain() {
        return this.chain;
    }

    public void setChainPosition() {
        Point p = this.chain.getPoint(this.getParentChain());
        if (p != null) {
            Position pos = this.getPosition();
            pos.setLocation(p, (CoFolder)this.getParent());
        }
    }

    public Point getChainPosition() {
        return this.chain.getPoint(this.getParentChain());
    }

    public Chain getParentChain() {
        Chain chain = null;
        TreeNode parent = this.getParent();
        if (parent instanceof CoMMFolder) {
            chain = ((CoMMFolder)parent).getChain();
        }
        return chain;
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName().equals("ChainName")) {
            String oldName = this.chain.getName();
            String newName = oldName.replaceAll((String)e.getOldValue(), (String)e.getNewValue());
            try {
                this.chain.setName(newName);
                this.chain.store();
                this.firePropertyChange("ChainName", oldName, newName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

