#!/bin/sh

##############################################################
#                       ATTENTION !!!                        #
# Do not run this script if your M4 tables contain valuable  #
# data. The script deletes all M4 tables!                    #
#                                                            #
# Furthermore, the script installs functions and stored      #
# procedures into the business data schema:	             #
#                                                            #
#                         PL/SQL:                            #
# - procedure dbWindow                                       #
# - procedure EMA                                            #
# - procedure SMA                                            #
# - procedure WMA                                            #
# - procedure SimpleSTSP                                     #
#                                                            #
# - function column_datatype                                 #
# - function m4_date_to_timestamp                            #
# - function mm_add                                          #                                       
# - function mm_divide                                       #
# - function time_interv_to_cat                              #
# - function num_interv_to_cat                               #
# - function Get_Type                                        #
# - function Get_Type2                                       #
# - function M4RandomNr                                      #
# - function M4RandomSelect                                  #
#                                                            #
# Java Classes: package name "miningmart"                    #
#                                                            #
# Please  make sure, that no PL/SQL functions/procedures     #
# or JAVA classes are overwritten in the business data       #
# schema !!                                                  #
##############################################################

# Please set user,password and SID before running the script:
# M4 schema:
M4USER=
M4PASS=
M4SID=

# Business data schema:
BDUSER=
BDPASS=
BDSID=

# How to run SQLPlus? In some cases you might have to set
# this variable to the absolute path.
SQL_PLUS=

# How to run the loadjava command? In some cases you might
# have to set this variable to the absolute path.
LOAD_JAVA=

# Log messages are written to this file:
LOGFILE="installer.log"

# -------------

echo "M4 schema: Installing M4 tables!" | tee "${LOGFILE}"
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @CreateM4Tables.sql | tee -a "${LOGFILE}"

echo "M4 schema: Installing M4 operator information!" | tee -a "${LOGFILE}"
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @Operators.sql | tee -a "${LOGFILE}"

echo "M4 schema: Installing a sequence!" | tee -a "${LOGFILE}"
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @MM_Sequence.sql | tee -a "${LOGFILE}"

echo "M4 schema: Installing Functions Part1!" | tee -a "${LOGFILE}"
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @MM_Functions_1.sql | tee -a "${LOGFILE}"

echo "Business Data Schema: Installing Functions Part1" | tee -a "${LOGFILE}"
${SQL_PLUS} ${BDUSER}/${BDPASS}@${BDSID} @MM_Functions_1.sql | tee -a "${LOGFILE}"

echo "Business Data Schema: Installing Java Stored Procedures!" | tee -a "${LOGFILE}"
${LOAD_JAVA} -user ${BDUSER}/${BDPASS}@${BDSID} JavaStoredProc/*.java | tee -a "${LOGFILE}"

echo "Business Data Schema: Installing embedding PL/SQL functions/procedures for Java procedures!" | tee -a "${LOGFILE}"
${SQL_PLUS} ${BDUSER}/${BDPASS}@${BDSID} @MM_Functions_2.sql | tee -a "${LOGFILE}"

echo "Done. All log messages were written to ${LOGFILE}."
