-----------------------------------------------------------
--                    A windowing operator               --
-----------------------------------------------------------

CREATE OR REPLACE PROCEDURE
     dbWindow( DbObject      VARCHAR2,
               NameColumnSet VARCHAR2,
               TimeAttrib    VARCHAR2,
               ValueAttrib   VARCHAR2,
               Target        VARCHAR2,
               OutTimeStart  VARCHAR2,
               OutTimeEnd    VARCHAR2,
               OutWindowCols VARCHAR2,
               distance      NUMBER)
AS LANGUAGE java NAME
'miningmart.storedProcedures.ToWindow.dbWindow(
java.lang.Object, java.lang.String, java.lang.String,
java.lang.String, java.lang.String, java.lang.String,
java.lang.String, java.lang.String, int)';
/

-----------------------------------------------------------
-- Interface procedures for the operators EMA, SMA, WMA. --
-----------------------------------------------------------

CREATE OR REPLACE PROCEDURE
     EMA( DbObject        VARCHAR2,
          InputColumnSet  VARCHAR2,
          TimeAttribIn    VARCHAR2,
          ValueAttribIn   VARCHAR2,
          TargetColumnSet VARCHAR2,
          TimeAttribOut   VARCHAR2,
          ValueAttribOut  VARCHAR2,
          headWeight      NUMBER,
          tailWeight      NUMBER,
          distance        NUMBER)
AS LANGUAGE java NAME
'miningmart.storedProcedures.EMF.dbEMA(
java.lang.Object, java.lang.String, java.lang.String, java.lang.String,
java.lang.String, java.lang.String, java.lang.String,
double, double, int)';
/

CREATE OR REPLACE PROCEDURE
     SMA( DbObject           VARCHAR2,
          InputColumnSet     VARCHAR2,
          TimeAttribIn       VARCHAR2,
          ValueAttribIn      VARCHAR2,
          TargetColumnSet    VARCHAR2,
          TimeStartAttribOut VARCHAR2,
          TimeEndAttribOut   VARCHAR2,
          ValueAttribOut     VARCHAR2,
          winsize            NUMBER,
          distance           NUMBER)
AS LANGUAGE java NAME
'miningmart.storedProcedures.SMF.dbSMF(
java.lang.Object, java.lang.String, java.lang.String,
java.lang.String, java.lang.String,
java.lang.String, java.lang.String,
java.lang.String, int, int)';
/

CREATE OR REPLACE PROCEDURE
     WMA( DbObject           VARCHAR2,
          InputColumnSet     VARCHAR2,
          TimeAttribIn       VARCHAR2,
          ValueAttribIn      VARCHAR2,
          TargetColumnSet    VARCHAR2,
          TimeStartAttribOut VARCHAR2,
          TimeEndAttribOut   VARCHAR2,
          ValueAttribOut     VARCHAR2,
          weights            VARCHAR2,
          distance           NUMBER)
AS LANGUAGE java NAME
'miningmart.storedProcedures.WMF.dbWMA(
java.lang.Object, java.lang.String, java.lang.String, java.lang.String,
java.lang.String, java.lang.String, java.lang.String,
java.lang.String, java.lang.String, int)';
/


CREATE OR REPLACE PROCEDURE
       SimpleSTSP( DbObject        VARCHAR2,
                   InputColumnSet  VARCHAR2,
                   TimeAttribIn    VARCHAR2,
                   ValueAttribIn   VARCHAR2,
                   TargetColumnSet VARCHAR2,
                   TimeStartOut    VARCHAR2,
                   TimeEndOut      VARCHAR2,
		   AvgColumnOut    VARCHAR2,
		   IncColumnOut    VARCHAR2,
                   tolerance       NUMBER)
AS LANGUAGE java NAME
'miningmart.storedProcedures.SimpleSTSP.dbSTSP(
java.lang.Object, java.lang.String, java.lang.String, java.lang.String,
java.lang.String, java.lang.String, java.lang.String, java.lang.String,
java.lang.String, double)';
/


---------------------------------------------------------
-- A helper function called by JAVA stored procedures: --
---------------------------------------------------------

CREATE OR REPLACE FUNCTION
GET_TYPE(TAB IN VARCHAR2, ATT IN VARCHAR2)
RETURN VARCHAR2
IS THE_TYPE VARCHAR2(20);
BEGIN
	SELECT DATA_TYPE INTO THE_TYPE FROM COLS
	WHERE ((TABLE_NAME=TAB) AND (COLUMN_NAME=ATT));
RETURN(THE_TYPE);
END;
/

CREATE OR REPLACE FUNCTION
GET_TYPE2(OWN IN VARCHAR2, TAB IN VARCHAR2, ATT IN VARCHAR2)
RETURN VARCHAR2
IS THE_TYPE VARCHAR2(20);
BEGIN
	SELECT DATA_TYPE INTO THE_TYPE FROM ALL_TAB_COLUMNS
	WHERE ((OWNER=OWN) AND (TABLE_NAME=TAB) AND (COLUMN_NAME=ATT));
RETURN(THE_TYPE);
END;
/

---------------------------------------------------------
-- Instead of package DBMS_RANDOM:


CREATE OR REPLACE FUNCTION M4RandomNr (Seed NUMBER, RowNum NUMBER, maxNr NUMBER) RETURN NUMBER
--- Parameter: seed - the seed to use if rownum = 1
---            rownum - the actual rownum within the select
---            maxNr    1 <=  M4RandomNr(...) <= maxNr
--- As it is based on java.util.Random it should be stable,
--- i.e. for a fixed seed it should assign always the same RandomNr to the same Rownum,
--- IF it is called with all rownums from 1 to the actual one
 AS LANGUAGE java
    NAME 'miningmart.storedProcedures.M4Random.RandomNr(java.lang.Long, java.lang.Integer, java.lang.Integer) return java.lang.Integer';
/

create or replace function M4RandomSelect (Seed NUMBER, RowNum NUMBER, SelProb NUMBER) RETURN NUMBER
--- Parameter: seed - the seed to use if rownum = 1
---            rownum - the actual rownum within the select
---            selection probability - an integer between 0 and 1000000
---                                    the probability that 1 is returned
--- As it is based on java.util.Random it should be stable,
--- i.e. for a fixed seed it should assign always the same value to the same Rownum
--- IF it is called with all rownums from 1 to the actual one
 AS LANGUAGE java
    NAME 'miningmart.storedProcedures.M4Random.RandomSelect(java.lang.Long, java.lang.Integer, java.lang.Integer) return java.lang.Integer';
/

-----------------------------------------------------------------------------

COMMIT;
exit
