/*
 * Decompiled with CFR 0.152.
 */
package miningmart.storedProcedures;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Vector;
import miningmart.storedProcedures.Attribute;
import miningmart.storedProcedures.BusinessDbConnectionSource;
import miningmart.storedProcedures.DataType;
import miningmart.storedProcedures.DbConnector;
import miningmart.storedProcedures.OutputColumnset;
import miningmart.storedProcedures.Quicksort;
import miningmart.storedProcedures.TimeOperatorException;
import miningmart.storedProcedures.Windowing;

public class WMF {
    public static final int AVERAGE = 0;
    public static final int MODAL = 1;
    public static final int MEDIAN = 2;
    private final DbConnector connector;
    private final Windowing window;
    private final OutputColumnset out;
    private final double[] weights;
    private final int method;
    private static final int INDEXONATTRIB = 2;

    protected Windowing getWindow() {
        return this.window;
    }

    protected OutputColumnset getOutputColumnset() {
        return this.out;
    }

    public WMF(BusinessDbConnectionSource dbc, String source, String time, String column, String target, String timeStartOut, String timeEndOut, String columnOut, double[] weights, int distance, int method) throws SQLException, TimeOperatorException {
        this.weights = weights;
        this.method = method;
        this.connector = new DbConnector(dbc);
        String timeDT = DataType.getColumnDataType(source, time, this.connector);
        String columnDT = DataType.getColumnDataType(source, column, this.connector);
        Attribute timeAttr = new Attribute(time, timeDT, timeDT);
        Attribute columnAttr = new Attribute(column, columnDT, dbc.getNameOfNumericDatatype());
        if (!timeAttr.isConvertable()) {
            DataType.wrongDataType(target, timeAttr);
        }
        if (!columnAttr.isConvertable()) {
            DataType.wrongDataType(target, columnAttr);
        }
        Attribute timeStartAttr = new Attribute(timeStartOut, timeDT, timeDT);
        Attribute timeEndAttr = new Attribute(timeEndOut, timeDT, timeDT);
        Attribute columnOutAttr = new Attribute(columnOut, columnDT, dbc.getNameOfNumericDatatype());
        Attribute[] allAttributes = new Attribute[]{timeStartAttr, timeEndAttr, columnOutAttr};
        this.out = new OutputColumnset(target, allAttributes, this.connector.getConnection());
        this.window = new Windowing(weights.length, distance, this.connector);
        if (!this.window.open("SELECT " + columnAttr.getConvertedInput() + ", " + timeAttr.getConvertedInput() + " FROM " + source)) {
            DbConnector.infoOutput("Error while opening " + source);
            throw new TimeOperatorException("Could not read from table '" + source + "'!");
        }
    }

    private double processAverage(String[] window, double[] weights) {
        double sum = 0.0;
        int i = 0;
        while (i < window.length) {
            sum += Double.parseDouble(window[i]) * weights[i];
            ++i;
        }
        return sum;
    }

    private double processModal(String[] window, double[] weights) {
        double sum = 0.0;
        double[] dblWnd = new double[window.length];
        int i = 0;
        while (i < window.length) {
            dblWnd[i] = Double.parseDouble(window[i]);
            ++i;
        }
        Arrays.sort(dblWnd);
        double[] cnt = new double[dblWnd.length];
        Arrays.fill(cnt, 0.0);
        int i2 = 0;
        while (i2 < dblWnd.length - 2) {
            int cntIndex = i2;
            while (dblWnd[i2] == dblWnd[i2 + 1]) {
                int n = cntIndex;
                cnt[n] = cnt[n] + 1.0;
                ++i2;
            }
            ++i2;
        }
        Quicksort.sort(cnt, dblWnd, 0, dblWnd.length - 1);
        i2 = 0;
        while (i2 < dblWnd.length) {
            sum += dblWnd[i2] * weights[i2];
            ++i2;
        }
        return sum;
    }

    private double processMedian(String[] window, double[] weights) {
        double sum = 0.0;
        double[] dblWnd = new double[window.length];
        int i = 0;
        while (i < window.length) {
            dblWnd[i] = Double.parseDouble(window[i]);
            ++i;
        }
        Arrays.sort(dblWnd);
        double median = dblWnd[dblWnd.length / 2];
        double[] space = new double[dblWnd.length];
        int i2 = 0;
        while (i2 < dblWnd.length) {
            space[i2] = Math.abs(median - dblWnd[i2]);
            ++i2;
        }
        Quicksort.sort(space, dblWnd, 0, dblWnd.length - 1);
        i2 = 0;
        while (i2 < dblWnd.length) {
            sum += dblWnd[i2] * weights[i2];
            ++i2;
        }
        return sum;
    }

    private void shiftArray(double[] array) {
        int i = array.length - 1;
        while (i > 0) {
            array[i - 1] = array[i];
            --i;
        }
    }

    public void calc() throws TimeOperatorException {
        String[] ret = null;
        do {
            ret = this.getWindow().getNextWnd();
            String startTime = this.getWindow().getTimeFirstEntry();
            String endTime = this.getWindow().getTimeLastEntry();
            if (ret == null) continue;
            Double value = null;
            switch (this.method) {
                case 0: {
                    value = new Double(this.processAverage(ret, this.weights));
                    break;
                }
                case 1: {
                    value = new Double(this.processModal(ret, this.weights));
                    break;
                }
                case 2: {
                    value = new Double(this.processMedian(ret, this.weights));
                }
            }
            this.getOutputColumnset().insert(new Object[]{startTime, endTime, value});
        } while (ret != null);
        this.getWindow().close();
        this.connector.close();
    }

    public static void dbWMA(Object dbc, String source, String time, String column, String target, String timeStartOut, String timeEndOut, String columnOut, String weights, int distance) throws SQLException, TimeOperatorException {
        BusinessDbConnectionSource dbcCasted = dbc instanceof BusinessDbConnectionSource ? (BusinessDbConnectionSource)dbc : null;
        double[] numWeights = WMF.parseWeightList(weights);
        if (numWeights == null || numWeights.length == 0) {
            return;
        }
        WMF wmf = new WMF(dbcCasted, source, time, column, target, timeStartOut, timeEndOut, columnOut, numWeights, distance, 0);
        wmf.calc();
        wmf = null;
    }

    private static double[] parseWeightList(String s) {
        if (s == null) {
            return null;
        }
        Vector<Double> values = new Vector<Double>();
        int stop = 0;
        int from = 0;
        while (from < s.length()) {
            if ((from = WMF.nextNonWhitespace(s, from)) == s.length()) break;
            stop = WMF.nextWhitespace(s, from);
            String sub = s.substring(from, stop);
            double d = Double.parseDouble(sub);
            values.add(new Double(d));
            from = stop;
        }
        double[] weights = new double[values.size()];
        int arg = 0;
        while (arg < weights.length) {
            weights[arg] = (Double)values.elementAt(arg);
            ++arg;
        }
        return weights;
    }

    private static int nextNonWhitespace(String s, int index) {
        while (index < s.length() && Character.isWhitespace(s.charAt(index))) {
            ++index;
        }
        return index;
    }

    private static int nextWhitespace(String s, int index) {
        while (index < s.length() && !Character.isWhitespace(s.charAt(index))) {
            ++index;
        }
        return index;
    }
}

