/*
 * Decompiled with CFR 0.152.
 */
package miningmart.storedProcedures;

import java.sql.SQLException;
import miningmart.storedProcedures.Attribute;
import miningmart.storedProcedures.BusinessDbConnectionSource;
import miningmart.storedProcedures.DataType;
import miningmart.storedProcedures.DbConnector;
import miningmart.storedProcedures.OutputColumnset;
import miningmart.storedProcedures.TimeOperatorException;
import miningmart.storedProcedures.TimeValue;
import miningmart.storedProcedures.TimeValueArray;
import miningmart.storedProcedures.Windowing;

public class SimpleSTSP {
    private final DbConnector connector;
    private final Windowing window;
    private final OutputColumnset out;
    private final double tolerance;
    private static final int INDEXONATTRIB = 2;

    protected Windowing getWindow() {
        return this.window;
    }

    protected OutputColumnset getOutputColumnset() {
        return this.out;
    }

    protected double getTolerance() {
        return this.tolerance;
    }

    public SimpleSTSP(BusinessDbConnectionSource dbc, String source, String time, String column, String target, String timeStart, String timeEnd, String averageCol, String incCol, double tolerance) throws SQLException, TimeOperatorException {
        this.connector = new DbConnector(dbc);
        this.tolerance = Math.abs(tolerance);
        String timeDT = DataType.getColumnDataType(source, time, this.connector);
        String columnDT = DataType.getColumnDataType(source, column, this.connector);
        String numName = dbc.getNameOfNumericDatatype();
        Attribute timeAttr = new Attribute(time, timeDT, numName);
        Attribute columnAttr = new Attribute(column, columnDT, numName);
        if (!timeAttr.isConvertable()) {
            DataType.wrongDataType(target, timeAttr);
        }
        if (!columnAttr.isConvertable()) {
            DataType.wrongDataType(target, columnAttr);
        }
        Attribute timeStartAttr = new Attribute(timeStart, timeDT, numName);
        Attribute timeEndAttr = new Attribute(timeEnd, timeDT, numName);
        Attribute averageColAttr = new Attribute(averageCol, columnDT, numName);
        Attribute incColAttr = new Attribute(incCol, columnDT, numName);
        Attribute[] allAttributes = new Attribute[]{timeStartAttr, timeEndAttr, averageColAttr, incColAttr};
        this.out = new OutputColumnset(target, allAttributes, this.connector.getConnection());
        this.window = new Windowing(1, 1, this.connector);
        if (!this.window.open("SELECT " + columnAttr.getConvertedInput() + ", " + timeAttr.getConvertedInput() + " FROM " + source)) {
            DbConnector.infoOutput("Error while opening " + source);
            throw new TimeOperatorException("Could not read from table '" + source + "'!");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void calc() throws TimeOperatorException {
        tv = this.nextTimeValue();
        if (tv != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            tv = this.startNewInterval(tv);
lbl5:
            // 2 sources

            ** while (tv != null)
        }
lbl6:
        // 1 sources

        this.getWindow().close();
        this.connector.close();
    }

    private void insert(TimeValueArray values) throws TimeOperatorException {
        Object[] i = new Object[]{new Long(values.getStartTime()), new Long(values.getLatestTime()), new Double(values.getAverageValue()), new Double(values.getIncreaseByTime())};
        this.getOutputColumnset().insert(i);
    }

    private TimeValue startNewInterval(TimeValue tv) throws TimeOperatorException {
        if (tv == null) {
            return null;
        }
        TimeValueArray values = new TimeValueArray(tv);
        while ((tv = this.nextTimeValue()) != null && this.intoTimeValueArray(values, tv)) {
        }
        this.insert(values);
        return tv;
    }

    private boolean intoTimeValueArray(TimeValueArray values, TimeValue tv) {
        double refValue = values.extrapolateValueFor(tv.getTimeAsLong());
        if (Math.abs(refValue - tv.getValue()) > this.getTolerance()) {
            return false;
        }
        values.add(tv);
        return true;
    }

    private TimeValue nextTimeValue() throws NumberFormatException {
        String[] ret = this.window.getNextWnd();
        if (ret == null || ret.length < 1) {
            return null;
        }
        return new TimeValue(this.window.getTimeFirstEntry(), ret[0]);
    }

    public static void dbSTSP(Object dbc, String source, String time, String column, String target, String timeStart, String timeEnd, String averageCol, String incCol, double tolerance) throws SQLException, TimeOperatorException {
        BusinessDbConnectionSource dbcCasted = dbc instanceof BusinessDbConnectionSource ? (BusinessDbConnectionSource)dbc : null;
        SimpleSTSP stsp = new SimpleSTSP(dbcCasted, source, time, column, target, timeStart, timeEnd, averageCol, incCol, tolerance);
        stsp.calc();
        stsp = null;
    }
}

