/*
 * Decompiled with CFR 0.152.
 */
package miningmart.storedProcedures;

import java.sql.SQLException;
import miningmart.storedProcedures.Attribute;
import miningmart.storedProcedures.BusinessDbConnectionSource;
import miningmart.storedProcedures.DataType;
import miningmart.storedProcedures.DbConnector;
import miningmart.storedProcedures.OutputColumnset;
import miningmart.storedProcedures.TimeOperatorException;
import miningmart.storedProcedures.Windowing;

public class EMF {
    private final DbConnector connector;
    private final Windowing window;
    private final OutputColumnset out;
    private final double headWeight;
    private final double tailWeight;
    private static final int INDEXONATTRIB = 1;

    protected Windowing getWindow() {
        return this.window;
    }

    protected OutputColumnset getOutputColumnset() {
        return this.out;
    }

    protected double getHeadWeight() {
        return this.headWeight;
    }

    protected double getTailWeight() {
        return this.tailWeight;
    }

    public EMF(BusinessDbConnectionSource dbc, String source, String time, String column, String target, String timeOut, String valueOut, double headWeight, double tailWeight, int distance) throws SQLException, TimeOperatorException {
        this.connector = new DbConnector(dbc);
        this.headWeight = headWeight;
        this.tailWeight = tailWeight;
        String timeDT = DataType.getColumnDataType(source, time, this.connector);
        String columnDT = DataType.getColumnDataType(source, column, this.connector);
        Attribute timeAttr = new Attribute(time, timeDT, timeDT);
        Attribute columnAttr = new Attribute(column, columnDT, dbc.getNameOfNumericDatatype());
        if (!timeAttr.isConvertable()) {
            DataType.wrongDataType(target, timeAttr);
        }
        if (!columnAttr.isConvertable()) {
            DataType.wrongDataType(target, columnAttr);
        }
        Attribute timeOutAttr = new Attribute(timeOut, timeDT, timeDT);
        Attribute valueOutAttr = new Attribute(valueOut, columnDT, dbc.getNameOfNumericDatatype());
        Attribute[] allAttributes = new Attribute[]{timeOutAttr, valueOutAttr};
        this.out = new OutputColumnset(target, allAttributes, this.connector.getConnection());
        this.window = new Windowing(1, distance, this.connector);
        if (!this.window.open("SELECT " + columnAttr.getConvertedInput() + ", " + timeAttr.getConvertedInput() + " FROM " + source)) {
            DbConnector.infoOutput("Error while opening " + source);
            throw new TimeOperatorException("Could not read from table '" + source + "'!");
        }
    }

    private double calcAverage(double lastVal, double thisHead) {
        return lastVal == 0.0 ? thisHead : lastVal * this.getTailWeight() + thisHead * this.getHeadWeight();
    }

    public void calc() throws TimeOperatorException {
        double lastVal = 0.0;
        double thisVal = 0.0;
        String[] ret = null;
        do {
            if ((ret = this.getWindow().getNextWnd()) == null) continue;
            lastVal = thisVal = this.calcAverage(lastVal, Double.parseDouble(ret[0]));
            Object[] i = new Object[]{new Long(this.getWindow().getTimeLastEntry()), new Double(thisVal)};
            this.getOutputColumnset().insert(i);
        } while (ret != null);
        this.getWindow().close();
        this.connector.close();
    }

    public static void dbEMA(Object dbc, String inputTable, String timeAttrIn, String valueAttrIn, String outputTable, String timeAttrOut, String valueAttrOut, double headWeight, double tailWeight, int distance) throws SQLException, TimeOperatorException {
        BusinessDbConnectionSource dbcCasted = dbc instanceof BusinessDbConnectionSource ? (BusinessDbConnectionSource)dbc : null;
        EMF emf = new EMF(dbcCasted, inputTable, timeAttrIn, valueAttrIn, outputTable, timeAttrOut, valueAttrOut, headWeight, tailWeight, distance);
        emf.calc();
        emf = null;
    }
}

