/*
 * Decompiled with CFR 0.152.
 */
package miningmart.storedProcedures;

class Attribute {
    private final String name;
    private final String dataType;
    private final String internalType;

    public Attribute(String name, String dataType, String internalType) {
        this.name = name;
        this.dataType = dataType;
        this.internalType = internalType;
    }

    public String getName() {
        return this.name;
    }

    public String getDataTypeName() {
        return this.dataType;
    }

    public boolean isConvertable() {
        return this.getConvertedInput() != null && this.getConvertedOutput("") != null;
    }

    public String getConvertedInput() {
        if (this.getDataTypeName().equalsIgnoreCase(this.internalType)) {
            if (this.isDate(this.getDataTypeName())) {
                return "to_char(" + this.getName() + ", 'DD.MM.YYYY HH24:MI:SS')";
            }
            return this.getName();
        }
        if (this.isDate(this.getDataTypeName()) && this.isNumeric(this.internalType)) {
            return "m4_date_to_timestamp(" + this.getName() + ")";
        }
        if (this.isNumeric(this.getDataTypeName()) && this.isDate(this.internalType)) {
            return "to_char(m4_timestamp_to_date(" + this.getName() + "), 'DD.MM.YYYY HH24:MI:SS')";
        }
        return null;
    }

    public String getConvertedOutput(String value) {
        if (value == null) {
            return "NULL";
        }
        if (this.getDataTypeName().equalsIgnoreCase(this.internalType)) {
            if (this.isDate(this.getDataTypeName())) {
                return "to_date('" + value + "', 'DD.MM.YYYY HH24:MI:SS')";
            }
            return value;
        }
        if (this.isNumeric(this.internalType) && this.isDate(this.getDataTypeName())) {
            return "m4_timestamp_to_date(" + value + ")";
        }
        if (this.isDate(this.internalType) && this.isNumeric(this.getDataTypeName())) {
            return "m4_date_to_timestamp(to_date('" + value + "', 'DD.MM.YYYY HH24:MI:SS'))";
        }
        return null;
    }

    public String getConvertedOutput(double value) {
        return this.getConvertedOutput(Double.toString(value));
    }

    public String getConvertedOutput(int value) {
        return this.getConvertedOutput(Integer.toString(value));
    }

    public String getConvertedOutput(long value) {
        return this.getConvertedOutput(Long.toString(value));
    }

    public String getConvertedOutput(Object obj) {
        if (obj == null) {
            return "NULL";
        }
        if (obj instanceof String) {
            return this.getConvertedOutput((String)obj);
        }
        if (obj instanceof Double) {
            Double d = (Double)obj;
            return this.getConvertedOutput(d);
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return this.getConvertedOutput(i);
        }
        if (obj instanceof Long) {
            Long l = (Long)obj;
            return this.getConvertedOutput(l);
        }
        return null;
    }

    private boolean isNumeric(String datatype) {
        return datatype.startsWith("NUM");
    }

    private boolean isDate(String datatype) {
        return datatype.equals("DATE");
    }
}

