/*
 * Decompiled with CFR 0.152.
 */
package miningmart.m4;

import edu.udo.miningmart.m4.hciImpl.M4InterfaceImpl;
import edu.udo.miningmart.m4.utils.Print;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import miningmart.compilerInterface.CompilerAccess;
import miningmart.compilerInterface.CompilerAccessClient;
import miningmart.m4.Case;
import miningmart.m4.CreateException;
import miningmart.m4.NameExistsException;
import miningmart.m4.Operator;

public abstract class M4Interface {
    private static transient M4Interface instance = new M4InterfaceImpl();
    protected static Case currentCase;
    protected static transient CompilerAccess currentCompilerAccess;
    public static transient Print print;

    static {
        print = Print.getGlobalPrintObject();
    }

    public static M4Interface getInstance() {
        return instance;
    }

    protected static void setInstance(M4Interface m4Instance) {
        instance = m4Instance;
    }

    public abstract Case createCase(String var1) throws CreateException, NameExistsException;

    public abstract Operator createOperator(String var1) throws CreateException, NameExistsException;

    public abstract Collection getAllCaseNames();

    public abstract Operator findOperator(String var1);

    public abstract Collection getAllOperatorNames();

    public abstract Case findCaseForReadOnlyAccess(String var1, boolean var2) throws CaseLockedException;

    public abstract Case findCaseForUpdate(String var1, boolean var2) throws CaseLockedException;

    public abstract boolean isCaseLockedForReading(String var1);

    public abstract boolean isCaseLockedForWriting(String var1);

    public abstract void releaseCase(String var1);

    public static Case getCurrentCase() {
        return currentCase;
    }

    public static void setCurrentCase(Case currentCase) {
        M4Interface.currentCase = currentCase;
        print.doPrint(4, "Current case set to:  " + currentCase.getName());
    }

    public static void setCurrentCompilerAccess(CompilerAccess currentCompilerAccess) {
        M4Interface.currentCompilerAccess = currentCompilerAccess;
        print.doPrint(0, "Current CompilerAccess set!");
    }

    public static CompilerAccess getCurrentCompilerAccess() {
        if (currentCompilerAccess == null) {
            try {
                currentCompilerAccess = new CompilerAccessClient(print).getCompilerAccess();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return currentCompilerAccess;
    }

    public abstract List executeSQLQC1(String var1, int var2) throws SQLException;

    public abstract Map executeSQLQ(String var1, int var2) throws SQLException;

    public abstract void executeSQLU(String var1) throws SQLException;

    public static void clearCache() {
    }

    public class CaseLockedException
    extends Exception {
        public CaseLockedException() {
        }

        public CaseLockedException(String message) {
            super(message);
        }
    }
}

