/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.util;

import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.hciImpl.CaseImpl;
import java.util.Vector;
import javax.swing.JOptionPane;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.m4.Case;
import miningmart.m4.StorageException;

public class CaseTrasher {
    private int retVal;
    private Case m4case = null;
    private boolean caseWasOpen;

    public void init() {
        this.retVal = 0;
        if (Application.mmWorkspace != null && Application.m4Case != null) {
            this.m4case = Application.m4Case;
            this.caseWasOpen = true;
        } else {
            this.caseWasOpen = false;
            Vector m4Cases = null;
            DataChooser dataChooser = new DataChooser(Application.frame, "Select a Case to delete", 4, true);
            dataChooser.setSingleSelection(true);
            m4Cases = dataChooser.showChooseDialog();
            if (m4Cases == null || m4Cases.size() == 0) {
                this.retVal = 2;
                return;
            }
            try {
                this.m4case = Application.m4Interface.findCaseForUpdate(m4Cases.get(0).toString(), true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Application.frame, "Cannot delete Case", "Case in use!", 0);
                this.retVal = 2;
            }
        }
    }

    public int deleteCase() {
        if (this.m4case == null || this.retVal != 0) {
            return -1;
        }
        Case caseToDelete = this.m4case;
        this.m4case = null;
        this.retVal = JOptionPane.showOptionDialog(Application.frame, "You are about to delete the\nCase '" + caseToDelete.getName() + "' !\n" + "Are you sure you want to proceed?", "Really delete case?", 0, 3, null, null, null);
        if (this.retVal != 0) {
            if (!this.caseWasOpen) {
                Application.m4Interface.releaseCase(caseToDelete.getName());
            }
            return -1;
        }
        System.out.println("Deleting Case!");
        System.out.println("Name: " + caseToDelete.getName());
        if (this.caseWasOpen) {
            Application.dispatcher.fileClose();
        } else {
            Application.m4Interface.releaseCase(caseToDelete.getName());
        }
        try {
            ((CaseImpl)caseToDelete).deleteSoon();
            ((CaseImpl)caseToDelete).store();
        }
        catch (M4Exception e) {
            System.out.println("Could not delete case:\n");
            System.out.println(e.getMessage());
        }
        catch (StorageException e) {
            System.out.println("Could not update database after deleting case:\n");
            System.out.println(e.getMessage());
        }
        System.out.println(" ..done");
        return 0;
    }
}

