/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.unSegment;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStep;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.segmentation.SegmByPartOperator;
import miningmart.hci.operators.segmentation.SegmKMeanOperator;
import miningmart.hci.operators.segmentation.SegmStratOperator;
import miningmart.hci.operators.unSegment.UnSegmentOperator;
import miningmart.m4.Concept;

public class UnSegmentOperatorView
extends MMStepView {
    JTextField inputConceptName = new JTextField("", 20);
    JTextField attributeName = new JTextField("", 20);
    RestrictedTextField outputConceptName = new RestrictedTextField("", 20);
    JButton changeConceptButton = new JButton("Change");
    JButton changeAttributeButton = new JButton("Change");
    private UnSegmentOperator op;
    private DataChooser chooser;

    public UnSegmentOperatorView(UnSegmentOperator op) {
        this.op = op;
        this.initControls();
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.inputConceptName.setEditable(false);
        this.inputConceptName.setBackground(Color.white);
        this.label = new JLabel("InputConcept");
        this.label.setLabelFor(this.inputConceptName);
        this.insets = new Insets(0, 0, 10, 5);
        this.constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptName, this.constraints);
        this.constraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.constraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.changeConceptButton.addActionListener(this);
        this.attributeName.setEditable(false);
        this.attributeName.setBackground(Color.white);
        this.label = new JLabel("Target Attribute");
        this.label.setLabelFor(this.inputConceptName);
        this.constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.attributeName, this.constraints);
        this.constraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeAttributeButton, this.constraints);
        this.changeAttributeButton.addActionListener(this);
        this.insets = new Insets(0, 0, 15, 0);
        this.label = new JLabel("Output Concept");
        this.label.setLabelFor(this.outputConceptName);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputConceptName, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeAttributeButton.setEnabled(enable);
        this.outputConceptName.setEditable(enable);
        if (!enable) {
            this.outputConceptName.setBackground(Color.white);
        }
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        if (this.op.theInputConcept != null) {
            this.inputConceptName.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptName.setText("");
        }
        this.attributeName.setText(this.op.unsegmentAttributeName);
        this.outputConceptName.setText(this.op.outputConceptName);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.cancelButton) {
            this.op.setParameter();
            this.updateView();
            return;
        }
        if (e.getSource() == this.closeButton) {
            this.op.setParameter();
            Application.menuWindowClose.doClick();
            return;
        }
        if (e.getSource() == this.changeConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            if (newConcept != null) {
                this.op.theInputConcept = newConcept;
            }
        } else if (e.getSource() == this.changeAttributeButton) {
            MMStep s;
            Vector<String> names = new Vector<String>();
            int i = 0;
            while (i < this.op.allSegmentationSteps.size()) {
                s = (MMStep)this.op.allSegmentationSteps.get(i);
                if (s instanceof SegmStratOperator) {
                    names.addElement(String.valueOf(((SegmStratOperator)s).theOutputConcept.getName()) + " - " + ((SegmStratOperator)s).theAttribute.getName());
                } else if (s instanceof SegmByPartOperator) {
                    names.addElement(String.valueOf(((SegmByPartOperator)s).theOutputConcept.getName()) + " - Random");
                } else if (s instanceof SegmKMeanOperator) {
                    names.addElement(String.valueOf(((SegmKMeanOperator)s).theOutputConcept.getName()) + " - KMean");
                }
                ++i;
            }
            this.chooser = new DataChooser(Application.frame, "select new Attribute", 9, names, true);
            this.chooser.setDepenceFromStep(this.op);
            int stepIndex = this.chooser.showChooseSingleDialog(true);
            if (stepIndex != this.op.stepIndex) {
                s = (MMStep)this.op.allSegmentationSteps.get(stepIndex);
                if (s instanceof SegmStratOperator) {
                    this.op.unsegmentAttributeName = ((SegmStratOperator)s).theAttribute.getName();
                } else if (s instanceof SegmByPartOperator) {
                    this.op.unsegmentAttributeName = "(Random)";
                } else if (s instanceof SegmKMeanOperator) {
                    this.op.unsegmentAttributeName = "(KMean)";
                }
                this.op.stepIndex = stepIndex;
            }
        }
        if (this.outputConceptName.hasValidInput()) {
            this.op.outputConceptName = this.outputConceptName.getText();
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }
}

