/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.genericOperator;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.operators.genericOperator.GenericOperator;
import miningmart.hci.operators.genericOperator.ParameterView;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.Constraint;
import miningmart.m4.FeatureAttribute;
import miningmart.m4.M4Object;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.MultipleResultException;
import miningmart.m4.OperatorParameter;
import miningmart.m4.Parameter;
import miningmart.m4.Relationship;
import miningmart.m4.Value;

public class OperatorParam {
    private OperatorParameter opParam;
    public GenericOperator genOperator;
    private Vector m4Objects = new Vector();
    private Vector m4ObjectNames = new Vector();
    private ParameterView view;
    private int loopNr = -1;
    private boolean loopParam = true;
    private Vector constraints;
    public static final int UNDEF = -1;
    public static final int CON = 0;
    public static final int BA = 1;
    public static final int V = 2;
    public static final int REL = 3;
    public static final int FEA = 4;

    public OperatorParam(OperatorParameter operatorParameter, GenericOperator op, int loopnr) {
        this.opParam = operatorParameter;
        this.genOperator = op;
        this.loopNr = loopnr;
        this.constraints = op.getAllParameterConstraint(this.getName());
    }

    public String getName() {
        return this.opParam.getName();
    }

    public String getIOType() {
        return this.opParam.getIoType();
    }

    public int getParameterType() {
        String t = this.opParam.getParameterType();
        if (t.equals("CON")) {
            return 0;
        }
        if (t.equals("BA")) {
            return 1;
        }
        if (t.equals("V")) {
            return 2;
        }
        if (t.equals("REL")) {
            return 3;
        }
        if (t.equals("FEA")) {
            return 4;
        }
        return -1;
    }

    public boolean isArrayParameter() {
        return this.opParam.getMaxNrOfArgs() != 1;
    }

    public void save() {
        if (this.opParam.getIoType().equals("IN")) {
            this.saveIN();
        } else {
            this.saveOUT();
        }
    }

    private void saveIN() {
        String name = this.getName();
        int stLoopNr = this.isLoopParam() && this.genOperator.m4Step.getStepLoopNr() > 1 ? (this.loopNr == 0 ? 1 : this.loopNr) : 0;
        if (this.isArrayParameter()) {
            if (this.getParameterType() == 2) {
                int i = 0;
                while (i < this.getAllM4ObjectNames().size()) {
                    this.genOperator.saveValueParameter(String.valueOf(name) + this.genOperator.paramNr, this.genOperator.paramNr++, "IN", this.getObjectName(i), this.getValueDataType(), stLoopNr);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.getAllM4Objects().size()) {
                    this.genOperator.saveParameter(String.valueOf(name) + this.genOperator.paramNr, this.genOperator.paramNr++, "IN", this.getM4Object(i), stLoopNr);
                    ++i;
                }
            }
        } else {
            if (this.isLoopParam() && this.genOperator.m4Step.getStepLoopNr() > 0) {
                name = String.valueOf(name) + this.genOperator.paramNr;
            }
            if (this.getParameterType() == 2) {
                this.updateString();
                this.genOperator.saveValueParameter(name, this.genOperator.paramNr++, "IN", this.getObjectName(), this.getValueDataType(), stLoopNr);
            } else {
                this.genOperator.saveParameter(name, this.genOperator.paramNr++, "IN", this.getM4Object(), stLoopNr);
            }
        }
    }

    private void saveOUT() {
        this.updateString();
        if (this.getParameterType() == 0) {
            String conceptParamName = null;
            Iterator it = ((AbstractList)this.constraints).iterator();
            while (it.hasNext() && conceptParamName == null) {
                Constraint c = (Constraint)it.next();
                if (!c.getConstraintType().equals("SAME_FEAT") || !c.getObject1().equals(this.getName())) continue;
                conceptParamName = c.getObject2();
            }
            if (conceptParamName == null) {
                this.genOperator.saveParameter(this.getName(), this.genOperator.paramNr++, "OUT", this.genOperator.changeConcept((Concept)this.getM4Object(), this.getObjectName(), new Vector(), new Vector()));
            } else {
                Vector<FeatureAttribute> newBAs = new Vector<FeatureAttribute>();
                it = this.genOperator.m4Step.getAllParameters().iterator();
                while (it.hasNext()) {
                    Parameter opParam = (Parameter)it.next();
                    if (!opParam.getParameterName().startsWith(conceptParamName)) continue;
                    Concept outC = (Concept)opParam.getParameterObject();
                    Iterator it1 = outC.getAllBaseAttributes().iterator();
                    while (it1.hasNext()) {
                        BaseAttribute ba = (BaseAttribute)it1.next();
                        if (ba.getAttributeType().equals("MINING")) {
                            Parameter baP = null;
                            Parameter cP = null;
                            try {
                                baP = ba.getOutputParameter();
                            }
                            catch (MultipleResultException multipleResultException) {
                                // empty catch block
                            }
                            if (baP != null) {
                                if (!this.genOperator.getEveryStepPredecessors().contains(baP.getStep())) continue;
                                newBAs.add(ba);
                                continue;
                            }
                            try {
                                cP = outC.getOutputParameter();
                            }
                            catch (MultipleResultException multipleResultException) {
                                // empty catch block
                            }
                            if (cP != null && !this.genOperator.getEveryStepPredecessors().contains(cP.getStep())) continue;
                            newBAs.add(ba);
                            continue;
                        }
                        newBAs.add(ba);
                    }
                    Iterator it12 = ((Concept)opParam.getParameterObject()).getAllMultiColumnFeatures().iterator();
                    while (it12.hasNext()) {
                        MultiColumnFeature fea = (MultiColumnFeature)it12.next();
                        Parameter p = null;
                        try {
                            p = fea.getOutputParameter();
                        }
                        catch (MultipleResultException multipleResultException) {
                            // empty catch block
                        }
                        if (p != null && !this.genOperator.getEveryStepPredecessors().contains(p.getStep())) continue;
                        newBAs.add(fea);
                    }
                }
                Concept newConcept = this.genOperator.changeConcept((Concept)this.getM4Object(), this.getObjectName(), newBAs, new Vector());
                this.genOperator.saveParameter(this.getName(), this.genOperator.paramNr++, "OUT", newConcept);
                this.setM4Object(newConcept);
            }
            return;
        }
        if (this.getParameterType() == 1 || this.getParameterType() == 4) {
            String name = this.getName();
            int stLoopNr = this.isLoopParam() && this.genOperator.m4Step.getStepLoopNr() > 1 ? (this.loopNr == 0 ? 1 : this.loopNr) : 0;
            BaseAttribute newBa = null;
            if (this.isArrayParameter()) {
                int i = 0;
                while (i < this.getAllM4ObjectNames().size()) {
                    newBa = this.getParameterType() == 1 || this.getM4Object(i) instanceof BaseAttribute ? this.getOutBaseAttribute(this.getObjectName(i)) : null;
                    this.genOperator.saveParameter(String.valueOf(name) + this.genOperator.paramNr, this.genOperator.paramNr++, "OUT", newBa, stLoopNr);
                    ++i;
                }
            } else {
                if (this.isLoopParam() && this.genOperator.m4Step.getStepLoopNr() > 0) {
                    name = String.valueOf(name) + this.genOperator.paramNr;
                }
                newBa = this.getM4Object() instanceof BaseAttribute || this.getParameterType() == 1 ? this.getOutBaseAttribute(this.getObjectName()) : null;
                this.genOperator.saveParameter(name, this.genOperator.paramNr++, "OUT", newBa, stLoopNr);
            }
            return;
        }
    }

    private BaseAttribute getOutBaseAttribute(String baName) {
        String getBaFromParamName = null;
        String dataType = null;
        String getDataTypeFromBaName = null;
        Constraint c1 = null;
        Constraint c2 = null;
        Constraint c3 = null;
        Iterator it = ((AbstractList)this.constraints).iterator();
        while (it.hasNext()) {
            Constraint c = (Constraint)it.next();
            if (c.getConstraintType().equals("IN")) {
                if (c.getObject1().equals(this.getName())) {
                    if (c.getObject2().equals("TheInputConcept")) {
                        c1 = c;
                        if (getBaFromParamName != null) continue;
                        getBaFromParamName = c1.getObject2();
                        continue;
                    }
                    if (!c.getObject2().equals("TheOutputConcept")) continue;
                    c2 = c;
                    continue;
                }
                if (!c.getObject1().equals("TheOutputConcept") || !c.getObject2().equals("TheInputConcept")) continue;
                c3 = c;
                getBaFromParamName = c3.getObject2();
                continue;
            }
            if (c.getConstraintType().equals("TYPE") && c.getObject1().equals(this.getName())) {
                dataType = c.getObject2();
                continue;
            }
            if (c.getConstraintType().equals("SAME_TYPE") && c.getObject1().equals(this.getName())) {
                getDataTypeFromBaName = c.getObject2();
                continue;
            }
            if (!c.getConstraintType().equals("SAME_TYPE") || !c.getObject2().equals(this.getName())) continue;
            getDataTypeFromBaName = c.getObject1();
        }
        String conceptToParamName = c2 != null ? c2.getObject2() : c1.getObject2();
        Concept conceptTo = null;
        Concept conceptFrom = null;
        BaseAttribute sameTypeBa = null;
        Iterator it2 = this.genOperator.m4Step.getAllParameters().iterator();
        while (it2.hasNext()) {
            Parameter p = (Parameter)it2.next();
            String pName = p.getParameterName();
            if (conceptToParamName != null && pName.startsWith(conceptToParamName)) {
                conceptTo = (Concept)p.getParameterObject();
                continue;
            }
            if (dataType == null && getDataTypeFromBaName != null && pName.startsWith(getDataTypeFromBaName)) {
                sameTypeBa = (BaseAttribute)p.getParameterObject();
                continue;
            }
            if (getBaFromParamName == null || !pName.startsWith(getBaFromParamName)) continue;
            conceptFrom = (Concept)p.getParameterObject();
        }
        if (dataType == null) {
            if (sameTypeBa == null && conceptFrom != null) {
                sameTypeBa = conceptFrom.getBaseAttribute(baName);
            }
            if (sameTypeBa != null) {
                dataType = sameTypeBa.getDatatype();
            }
        }
        return this.genOperator.changeBaseAttribute(conceptTo.getBaseAttribute(baName), conceptTo, baName, dataType, "MINING");
    }

    public void updateString() {
        if (this.view != null && !this.isArrayParameter()) {
            if (!this.m4ObjectNames.isEmpty()) {
                this.m4ObjectNames.setElementAt(this.view.textField.getText(), 0);
            } else {
                this.m4ObjectNames.addElement(this.view.textField.getText());
            }
        }
    }

    public void addM4Object(M4Object object) {
        this.m4Objects.addElement(object);
        this.m4ObjectNames.addElement(this.getM4ObjectString(object));
    }

    public M4Object getM4Object(int i) {
        if (this.isArrayParameter() && i < this.m4Objects.size()) {
            return (M4Object)this.m4Objects.get(i);
        }
        return null;
    }

    public M4Object getM4Object() {
        if (this.m4Objects.size() > 0) {
            return (M4Object)this.m4Objects.get(0);
        }
        return null;
    }

    public void setM4Object(M4Object m4Object) {
        if (this.m4Objects.isEmpty()) {
            this.addM4Object(m4Object);
        } else {
            this.m4Objects.setElementAt(m4Object, 0);
            this.m4ObjectNames.setElementAt(this.getM4ObjectString(m4Object), 0);
        }
    }

    public void setM4ObjectName(String value) {
        if (this.m4ObjectNames.isEmpty()) {
            this.m4ObjectNames.addElement(value);
        } else {
            this.m4ObjectNames.setElementAt(value, 0);
        }
    }

    public Vector getAllM4Objects() {
        return this.m4Objects;
    }

    public Vector getAllM4ObjectNames() {
        return this.m4ObjectNames;
    }

    public String getObjectName() {
        if (this.m4ObjectNames.size() > 0) {
            return (String)this.m4ObjectNames.get(0);
        }
        return "";
    }

    public String getObjectName(int i) {
        if (this.m4ObjectNames.size() > i) {
            return (String)this.m4ObjectNames.get(i);
        }
        return null;
    }

    public String getM4ObjectString(M4Object o) {
        if (o instanceof Concept) {
            return ((Concept)o).getName();
        }
        if (o instanceof Relationship) {
            return ((Relationship)o).getName();
        }
        if (o instanceof FeatureAttribute) {
            return ((FeatureAttribute)o).getName();
        }
        if (o instanceof Value) {
            return ((Value)o).getValue();
        }
        return null;
    }

    public int getParamArraySize() {
        return this.m4Objects.size();
    }

    public ParameterView getParameterView() {
        if (this.view == null) {
            this.view = new ParameterView(this);
        }
        this.view.updateView();
        return this.view;
    }

    public void changeM4Object() {
        if (!this.isLoopParam() && this.loopNr > 1) {
            JOptionPane.showMessageDialog(Application.frame, "This parameter is the same for\n every loop. Please choose LoopNr 1\n to change this parameter", "", 0);
            return;
        }
        if (this.getParameterType() == 0) {
            DataChooser chooser = new DataChooser(Application.frame, "Select new concept", 1, Application.m4Case, true);
            chooser.setDepenceFromStep(this.genOperator);
            Concept newConcept = (Concept)chooser.showChooseSingleDialog();
            if (newConcept != null) {
                this.setM4Object(newConcept);
                this.save();
            }
            return;
        }
        if (this.getParameterType() == 3) {
            DataChooser chooser = new DataChooser(Application.frame, "Select new Relation", 2, Application.m4Case, true);
            chooser.setDepenceFromStep(this.genOperator);
            Relationship newRelation = (Relationship)chooser.showChooseSingleDialog();
            if (newRelation != null) {
                this.setM4Object(newRelation);
                this.save();
            }
            return;
        }
        if (this.getParameterType() == 2) {
            DataChooser chooser = new DataChooser(Application.frame, "Select Value", 13, this.opParam, true);
            String newValue = (String)chooser.showChooseSingleDialog();
            if (newValue != null) {
                this.setM4ObjectName(newValue);
            }
            return;
        }
        FeatureAttribute fea = (FeatureAttribute)this.genOperator.changeParameterObject(this);
        if (fea != null) {
            this.setM4Object(fea);
        }
    }

    public void addM4ObjectToList() {
        if (this.getIOType().equals("OUT")) {
            if (this.getParameterType() == 4 || this.getParameterType() == 1) {
                Object fea = this.genOperator.changeParameterObject(this);
                if (fea != null && fea instanceof FeatureAttribute) {
                    this.addM4Object((FeatureAttribute)fea);
                } else if (fea != null && fea instanceof String) {
                    this.m4ObjectNames.addElement(fea);
                }
                return;
            }
        } else {
            if (this.getParameterType() == 0) {
                DataChooser chooser = new DataChooser(Application.frame, "Select new concept", 1, Application.m4Case, true);
                chooser.setDepenceFromStep(this.genOperator);
                chooser.setDepenceFromStep(this.genOperator);
                Concept newConcept = (Concept)chooser.showChooseSingleDialog();
                if (newConcept != null) {
                    this.addM4Object(newConcept);
                    this.save();
                }
                return;
            }
            if (this.getParameterType() == 3) {
                DataChooser chooser = new DataChooser(Application.frame, "Select new Relation", 2, true);
                chooser.setDepenceFromStep(this.genOperator);
                Relationship newRelation = (Relationship)chooser.showChooseSingleDialog();
                if (newRelation != null) {
                    this.addM4Object(newRelation);
                    this.save();
                }
                return;
            }
            if (this.getParameterType() == 2) {
                Iterator it = ((AbstractList)this.genOperator.getAllParameterConstraint(this.getName())).iterator();
                boolean exists = false;
                while (it.hasNext() && !exists) {
                    Constraint c = (Constraint)it.next();
                    exists = c.getConstraintType().equals("ONE_OF");
                }
                String newValue = null;
                if (exists) {
                    DataChooser chooser = new DataChooser(Application.frame, "Select Value", 13, this.opParam, true);
                    newValue = (String)chooser.showChooseSingleDialog();
                } else {
                    newValue = JOptionPane.showInputDialog(Application.frame, "Enter a value", "", 2);
                }
                if (newValue != null) {
                    this.m4ObjectNames.addElement(newValue);
                }
                return;
            }
            FeatureAttribute fea = (FeatureAttribute)this.genOperator.changeParameterObject(this);
            if (fea != null) {
                this.addM4Object(fea);
            }
        }
    }

    public void removeM4ObjectFromList(Object[] selectedValues) {
        int i = 0;
        while (i < selectedValues.length) {
            if (this.getParameterType() == 2 || (this.getParameterType() == 1 || this.getParameterType() == 4) && this.getIOType().equals("OUT")) {
                this.m4ObjectNames.removeElement(selectedValues[i]);
            } else {
                this.m4Objects.removeElement(selectedValues[i]);
            }
            ++i;
        }
    }

    public boolean isLoopParam() {
        return this.loopParam;
    }

    public void setAsLoopParam(boolean loopParam) {
        this.loopParam = loopParam;
    }

    private String getValueDataType() {
        Iterator it = ((AbstractList)this.constraints).iterator();
        while (it.hasNext()) {
            Constraint c = (Constraint)it.next();
            if (!c.getConstraintType().equals("TYPE") || !c.getObject1().equals(this.getName())) continue;
            return c.getObject2();
        }
        return "NOMINAL";
    }

    public boolean isValid() {
        boolean isValid = false;
        return isValid;
    }

    public void reset() {
        this.m4Objects.clear();
        this.m4ObjectNames.clear();
    }
}

