/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.featureConstruction;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.ChangeInputConceptButton;
import miningmart.hci.gui.util.MmDataList;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.featureConstruction.MrfcOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.Relationship;

public class MrfcOperatorView
extends MMStepView {
    JTextField inputConceptName = new JTextField("", 15);
    MmDataList conceptList = new MmDataList();
    MmDataList relationList = new MmDataList();
    MmDataList featureList = new MmDataList();
    RestrictedTextField outputConceptName = new RestrictedTextField("", 15);
    Vector featuresNames = new Vector();
    ChangeInputConceptButton changeConceptButton = new ChangeInputConceptButton("Change");
    JButton addConceptButton = new JButton("Add");
    JButton deleteConceptButton = new JButton("Remove");
    JButton addRelationButton = new JButton("Add");
    JButton deleteRelationButton = new JButton("Remove");
    JButton addFeatureButton = new JButton("Add");
    JButton deleteFeatureButton = new JButton("Remove");
    private MrfcOperator op;
    private DataChooser chooser;

    public MrfcOperatorView(MrfcOperator op) {
        this.op = op;
        this.initControls();
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.inputConceptName.setEditable(false);
        this.inputConceptName.setBackground(Color.white);
        this.label = new JLabel("InputConcept", 2);
        this.label.setLabelFor(this.inputConceptName);
        this.insets = new Insets(0, 0, 5, 0);
        this.constraints = new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(3, 0, 3, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptName, this.constraints);
        this.constraints = new GridBagConstraints(6, 0, 3, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.changeConceptButton.addActionListener(this);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.scrollPane = new JScrollPane(this.conceptList);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.label = new JLabel("Concepts", 2);
        this.label.setLabelFor(this.scrollPane);
        this.insets = new Insets(0, 10, 5, 0);
        this.constraints = new GridBagConstraints(0, 1, 3, 1, 0.1, 0.0, 17, 2, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(0, 2, 3, 1, 0.0, 0.1, 18, 1, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.addConceptButton.addActionListener(this);
        this.panel.add((Component)this.addConceptButton, this.constraints);
        this.insets = new Insets(0, 5, 5, 0);
        this.constraints = new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.panel.add((Component)this.deleteConceptButton, this.constraints);
        this.deleteConceptButton.addActionListener(this);
        this.scrollPane = new JScrollPane(this.relationList);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.label = new JLabel("Relations", 2);
        this.label.setLabelFor(this.scrollPane);
        this.insets = new Insets(0, 10, 5, 0);
        this.constraints = new GridBagConstraints(3, 1, 3, 1, 0.1, 0.0, 17, 2, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(3, 2, 3, 1, 0.0, 0.1, 18, 1, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.addRelationButton.addActionListener(this);
        this.panel.add((Component)this.addRelationButton, this.constraints);
        this.insets = new Insets(0, 5, 5, 0);
        this.constraints = new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.panel.add((Component)this.deleteRelationButton, this.constraints);
        this.deleteRelationButton.addActionListener(this);
        this.scrollPane = new JScrollPane(this.featureList);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.label = new JLabel("Features", 2);
        this.label.setLabelFor(this.scrollPane);
        this.insets = new Insets(0, 10, 5, 0);
        this.constraints = new GridBagConstraints(6, 1, 3, 1, 0.1, 0.0, 17, 2, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(6, 2, 3, 1, 0.0, 0.1, 18, 1, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(6, 3, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.addFeatureButton.addActionListener(this);
        this.panel.add((Component)this.addFeatureButton, this.constraints);
        this.insets = new Insets(0, 5, 5, 0);
        this.constraints = new GridBagConstraints(7, 3, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.constraints = new GridBagConstraints(8, 3, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.panel.add((Component)this.deleteFeatureButton, this.constraints);
        this.deleteFeatureButton.addActionListener(this);
        this.outputConceptName.setEditable(true);
        this.label = new JLabel("Output Concept", 2);
        this.label.setLabelFor(this.outputConceptName);
        this.insets = new Insets(10, 0, 5, 0);
        this.constraints = new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(3, 4, 3, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputConceptName, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeConceptButton.setEnabled(enable);
        this.outputConceptName.setEditable(enable);
        if (!enable) {
            this.outputConceptName.setBackground(Color.white);
        }
        this.addConceptButton.setEnabled(enable);
        this.deleteConceptButton.setEnabled(enable);
        this.addRelationButton.setEnabled(enable);
        this.deleteRelationButton.setEnabled(enable);
        this.addFeatureButton.setEnabled(enable);
        this.deleteFeatureButton.setEnabled(enable);
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        if (this.op.theInputConcept != null) {
            this.inputConceptName.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptName.setText("");
        }
        this.outputConceptName.setText(this.op.outputConceptName);
        this.conceptList.setListData(this.op.theConcepts);
        this.relationList.setListData(this.op.theRelations);
        this.featureList.setListData(this.op.theChainedFeatures);
        Iterator it = ((AbstractList)this.op.theChainedFeatures).iterator();
        String newName = "";
        while (it.hasNext()) {
            BaseAttribute ba = (BaseAttribute)it.next();
            if (ba == null) continue;
            newName = ba.getName().toUpperCase();
            this.featuresNames.addElement(newName);
        }
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.changeConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            if (newConcept != null) {
                this.op.theInputConcept = newConcept;
            }
        } else if (e.getSource() == this.addConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select a concept", 1, Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            if (newConcept != null) {
                this.op.theConcepts.addElement(newConcept);
            }
        } else if (e.getSource() == this.deleteConceptButton) {
            Object[] selected = this.conceptList.getSelectedValues();
            if (selected.length > 0) {
                int i = 0;
                while (i < selected.length) {
                    this.op.theConcepts.removeElement(selected[i]);
                    ++i;
                }
            }
        } else if (e.getSource() == this.addRelationButton) {
            this.chooser = new DataChooser(Application.frame, "Select a Relation", 2, true);
            this.chooser.setDepenceFromStep(this.op);
            Relationship newRelationship = (Relationship)this.chooser.showChooseSingleDialog();
            if (newRelationship != null) {
                this.op.theRelations.addElement(newRelationship);
            }
        } else if (e.getSource() == this.deleteRelationButton) {
            Object[] selected = this.relationList.getSelectedValues();
            if (selected.length > 0) {
                int i = 0;
                while (i < selected.length) {
                    this.op.theRelations.removeElement(selected[i]);
                    ++i;
                }
            }
        } else if (e.getSource() == this.addFeatureButton) {
            this.chooser = new DataChooser(Application.frame, "Select Attributes", true);
            this.chooser.setWithContext(true);
            this.chooser.setDepenceFromStep(this.op);
            Vector<Concept> allConcepts = new Vector<Concept>();
            allConcepts.addAll(this.op.theConcepts);
            allConcepts.addElement(this.op.theInputConcept);
            if (allConcepts == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Concepts selected!", "", 0);
                return;
            }
            this.chooser.setDataType(3, allConcepts);
            Vector newAttribs = this.chooser.showChooseDialog();
            if (newAttribs != null && newAttribs.size() > 0) {
                Iterator it = ((AbstractList)newAttribs).iterator();
                while (it.hasNext()) {
                    BaseAttribute ba = (BaseAttribute)it.next();
                    if (this.featuresNames.contains(ba.getName().toUpperCase())) {
                        JOptionPane.showMessageDialog(Application.frame, "Could not insert feature " + ba.getName().toUpperCase() + "\nFeature with this Name already exists", "", 0);
                        continue;
                    }
                    this.op.theChainedFeatures.addElement(ba);
                    this.featuresNames.addElement(ba.getName().toUpperCase());
                }
            }
        } else if (e.getSource() == this.deleteFeatureButton) {
            Object[] selected = this.featureList.getSelectedValues();
            if (selected.length > 0) {
                int i = 0;
                while (i < selected.length) {
                    this.op.theChainedFeatures.removeElement(selected[i]);
                    ++i;
                }
                this.featuresNames.removeAllElements();
                Iterator it = ((AbstractList)this.op.theChainedFeatures).iterator();
                while (it.hasNext()) {
                    this.featuresNames.addElement(((BaseAttribute)it.next()).getName());
                }
            }
        } else {
            if (e.getSource() == this.cancelButton) {
                this.op.setParameter();
                this.updateView();
                return;
            }
            if (e.getSource() == this.closeButton) {
                this.op.setParameter();
                Application.menuWindowClose.doClick();
            }
        }
        if (this.outputConceptName.hasValidInput()) {
            this.op.outputConceptName = this.outputConceptName.getText();
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }
}

