/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.gui.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.m4.Case;
import miningmart.m4.CreateException;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;

public class CreateCaseDialog
extends JDialog {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel caseLabel = new JLabel();
    JTextField caseName = new JTextField("", 15);
    JLabel modeLabel = new JLabel();
    JCheckBox trainingCheckBox = new JCheckBox();
    JCheckBox finalCheckBox = new JCheckBox();
    JButton createButton = new JButton();
    JButton cancelButton = new JButton();
    Case caseToCreate = null;
    boolean rename = false;
    Case caseToRename = null;

    public CreateCaseDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.caseLabel.setText("Case Name");
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.modeLabel.setText("Mode:");
        this.trainingCheckBox.setText("Test");
        this.trainingCheckBox.setSelected(true);
        this.trainingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCaseDialog.this.checkBox_actionPerformed(e);
            }
        });
        this.finalCheckBox.setText("Final");
        this.finalCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCaseDialog.this.checkBox_actionPerformed(e);
            }
        });
        this.createButton.setText("OK");
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCaseDialog.this.createButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCaseDialog.this.cancelButton_actionPerformed(e);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(this.gridBagLayout1);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this.caseLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        panel.add((Component)this.caseName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        panel.add((Component)this.modeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.finalCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.createButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        panel.add((Component)this.cancelButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.trainingCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getRootPane());
    }

    public Case showCreateDialog() {
        this.rename = false;
        this.show();
        return this.caseToCreate;
    }

    public Case showCreateDialog(Case c) {
        this.rename = true;
        this.caseToRename = c;
        this.caseName.setText(this.caseToRename.getName());
        this.finalCheckBox.setSelected(this.caseToRename.getMode().equals("final"));
        this.trainingCheckBox.setSelected(!this.caseToRename.getMode().equals("final"));
        this.show();
        return this.caseToRename;
    }

    void createButton_actionPerformed(ActionEvent e) {
        try {
            if (!this.rename) {
                this.caseToCreate = Application.m4Interface.createCase(this.caseName.getText());
                if (this.finalCheckBox.isSelected()) {
                    this.caseToCreate.setMode("FINAL");
                } else {
                    this.caseToCreate.setMode("TEST");
                }
                this.caseToCreate.store();
            } else {
                this.caseToRename.setName(this.caseName.getText());
                if (this.finalCheckBox.isSelected()) {
                    this.caseToRename.setMode("FINAL");
                } else {
                    this.caseToRename.setMode("TEST");
                }
            }
        }
        catch (NameExistsException ex) {
            JOptionPane.showMessageDialog(this, "Case allready exists!", "Error", 0);
            return;
        }
        catch (CreateException ce) {
            ce.printStackTrace();
        }
        catch (StorageException se) {
            se.printStackTrace();
        }
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.caseToCreate = null;
        this.dispose();
    }

    void checkBox_actionPerformed(ActionEvent e) {
        if (e.getSource() == this.trainingCheckBox) {
            this.trainingCheckBox.setSelected(true);
            this.finalCheckBox.setSelected(false);
        } else {
            this.trainingCheckBox.setSelected(false);
            this.finalCheckBox.setSelected(true);
        }
    }
}

