/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compilerInterface;

import edu.udo.miningmart.m4.utils.Print;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import miningmart.compilerInterface.CompilerAccess;
import miningmart.compilerInterface.CompilerAccessClient;

public class CompilerClientStatus
extends Thread {
    private static final int NUMLINES = 30;
    private static CompilerClientStatus thread;
    private boolean stopFlag = false;
    private final long caseId;
    private final int numlines;
    private CompilerAccess ca;
    private Frame f;
    private TextArea ta;

    private CompilerClientStatus(long caseId, int numlines, Print printObject) throws Exception {
        this.caseId = caseId;
        this.numlines = numlines;
        this.ca = new CompilerAccessClient(printObject).getCompilerAccess();
        this.initWindow();
        this.start();
    }

    public void run() {
        try {
            while (!this.stopFlag) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String msg = this.ca.getStatusMessage(this.caseId, this.numlines);
                if (this.ta.getText().equals(msg)) continue;
                this.ta.setText(msg);
            }
        }
        catch (Exception f) {
            System.err.println(f.getClass() + ":\n" + f.getMessage());
            f.printStackTrace();
        }
        this.ta = null;
        this.f.dispose();
        this.f = null;
        thread = null;
        System.out.println("Exiting...");
    }

    private void close() {
        this.stopFlag = true;
    }

    private void initWindow() {
        this.f = new Frame();
        this.ta = new TextArea(this.numlines, 80);
        this.f.add(this.ta);
        this.f.setResizable(false);
        this.ta.setEditable(false);
        this.f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CompilerClientStatus.this.close();
            }
        });
        this.f.pack();
        this.f.show();
    }

    public static void main(String[] args) throws Exception {
        int numlines;
        if (args.length < 1) {
            System.err.println("Usage: java -DCOMPILER_SERVER=<SERVER> miningmart.compilerInterface.CompilerClientStatus <caseId> [ <numberOfLines> ]");
            System.exit(-1);
        }
        long caseId = Long.parseLong(args[0]);
        if (args.length > 1) {
            numlines = Integer.parseInt(args[1]);
            if (numlines > 80) {
                numlines = 30;
            }
        } else {
            numlines = 30;
        }
        thread = new CompilerClientStatus(caseId, numlines, Print.getGlobalPrintObject());
    }
}

