/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compilerInterface;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.db.ConfigReader;
import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.ParameterDeselectedError;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Case;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.M4InterfaceContext;
import edu.udo.miningmart.m4.core.Operator;
import edu.udo.miningmart.m4.core.Step;
import edu.udo.miningmart.m4.utils.Print;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import miningmart.compiler.operator.ExecutableOperator;
import miningmart.compilerInterface.CompilerAccess;
import miningmart.compilerInterface.CompilerThreadControl;
import miningmart.compilerInterface.M4CompilerInterfaceError;

public class CompilerAccessLogic
implements M4InterfaceContext,
CompilerAccess {
    private static final CompilerThreadControl ctc = new CompilerThreadControl();
    private static final int MAX_STEPS_PER_CONNECTION = 150;
    private int stepsDuringDbConnection = 0;
    private boolean stopThread = false;
    private final CompilerDatabaseService m4db;
    private Print defaultPrintObject;
    private Print casePrintObject;
    private Case caseObj;
    private Integer verbosity;
    private static final Class[] EXEC_OP_CONSTRUCTOR_TYPE = new Class[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public CompilerAccessLogic(DB db, Print printObject) {
        this.m4db = db instanceof CompilerDatabaseService ? (CompilerDatabaseService)db : new CompilerDatabaseService(db, this);
        String v = System.getProperty("PRINT_VERBOSITY");
        this.verbosity = v != null ? new Integer(v) : null;
        this.defaultPrintObject = printObject;
    }

    public CompilerAccessLogic(String myDbConfigFile) throws IOException, SQLException {
        this(myDbConfigFile, null);
    }

    public CompilerAccessLogic(String myDbConfigFile, int verbosity) throws IOException, SQLException {
        this(myDbConfigFile, new Integer(verbosity));
    }

    private CompilerAccessLogic(String myDbConfigFile, Integer verbosity) throws IOException, SQLException {
        this.verbosity = verbosity == null || verbosity < 0 ? null : verbosity;
        this.initDefaultPrintObject();
        ConfigReader cr = new ConfigReader(myDbConfigFile);
        String m4dbname = cr.getLine();
        String m4user = cr.getLine();
        String m4password = cr.getLine();
        String m4driver = cr.getLine();
        String m4dbLocation = cr.getLine();
        cr.getLine();
        String dataDbname = cr.getLine();
        String dataUser = cr.getLine();
        String dataPassword = cr.getLine();
        String dataDriver = cr.getLine();
        String dataDbLocation = cr.getLine();
        this.m4db = new CompilerDatabaseService(String.valueOf(m4driver) + m4dbLocation, m4dbname, m4user, m4password, String.valueOf(dataDriver) + dataDbLocation, dataDbname, dataUser, dataPassword, true, this);
    }

    public void compileStep(long stepId, boolean lazyMode) throws M4CompilerInterfaceError {
        long caseId = this.getCaseIdByStepId(stepId);
        this.setCase(caseId);
        try {
            Step pred;
            DB dB = this.getM4db();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Step");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Step step = (Step)dB.getM4Object(stepId, clazz);
            do {
                pred = this.findUncompiledPred(step);
                this.compileStepSub(pred, lazyMode);
            } while (!step.equals(pred));
        }
        catch (M4Exception e) {
            throw new M4CompilerInterfaceError(e.getMessage());
        }
    }

    private Step findUncompiledPred(Step step) throws M4Exception, M4CompilerInterfaceError {
        Case m4case = step.getTheCase();
        Iterator pred = m4case.getReverseIterator();
        while (pred.hasNext() && !step.equals(pred.next())) {
        }
        while (pred.hasNext()) {
            Step current = (Step)pred.next();
            if (!m4case.containsDependency(current, step) || current.isCompiled()) continue;
            step = current;
        }
        return step;
    }

    private void compileStepSub(Step step, boolean lazyMode) throws M4Exception, M4CompilerInterfaceError {
        this.deleteTrashBeforeCompilingStep(step);
        try {
            this.compileStepMultiStepControl(step, lazyMode, false);
        }
        catch (M4Exception e) {
            throw new M4CompilerInterfaceError(e.getMessage());
        }
        this.printStepExecInfo(step, lazyMode);
    }

    public void compileStep(String stepName, boolean lazyMode) throws M4CompilerInterfaceError {
        long stepId = this.findStepId(stepName);
        this.compileStep(stepId, lazyMode);
    }

    private void compileStepMultiStepControl(Step step, boolean lazyMode, boolean computeStatistics) throws M4CompilerInterfaceError, M4Exception {
        try {
            Collection inputConcepts = this.getDb().getInputConceptsFor(step);
            Iterator it = inputConcepts.iterator();
            int minColSetNumber = Integer.MAX_VALUE;
            while (it.hasNext()) {
                Concept c = (Concept)it.next();
                Collection colsets = c.getColumnSets();
                if (colsets == null || colsets.size() == 0) {
                    throw new M4CompilerError("A parameter of type Concept ('" + c.getName() + "') of step '" + step.getName() + "' has no Columnset!");
                }
                int csNum = colsets.size();
                if (csNum < minColSetNumber) {
                    minColSetNumber = csNum;
                }
                if (csNum <= 1) continue;
                c.initMultiStepSupport(colsets);
            }
            if (minColSetNumber <= 1) {
                this.compileStepBody(step, lazyMode);
            } else if (lazyMode) {
                this.compileStepBody(step, true);
            } else {
                do {
                    this.compileStepBody(step, lazyMode);
                } while (this.nextCSSetting(inputConcepts));
            }
        }
        catch (SQLException ex) {
            throw new M4CompilerInterfaceError("SQLException trying to compile step " + step.getId() + " in " + (lazyMode ? "lazy" : "eager") + " mode:\n" + ex.getMessage());
        }
        catch (M4CompilerError ex) {
            throw new M4CompilerInterfaceError("M4CompilerError trying to compile step " + step.getId() + " in " + (lazyMode ? "lazy" : "eager") + " mode:\n" + ex.getMessage());
        }
    }

    private boolean nextCSSetting(Collection inputConcepts) throws M4CompilerError {
        Iterator it = inputConcepts.iterator();
        while (it.hasNext()) {
            Concept c = (Concept)it.next();
            try {
                if (c.hasNextColumnSet()) {
                    c.getNextColumnSet();
                    continue;
                }
                it = inputConcepts.iterator();
                while (it.hasNext()) {
                    ((Concept)it.next()).resetColumnSets();
                }
                return false;
            }
            catch (M4Exception m4e) {
                throw new M4CompilerError("M4 interface error in CompilerAccessLogic: " + m4e.getMessage());
            }
        }
        return true;
    }

    private void compileStepBody(long stepId, boolean lazyMode, boolean computeStatistics) throws M4CompilerInterfaceError {
        try {
            CompilerDatabaseService compilerDatabaseService = this.getDb();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Step");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Step step = (Step)compilerDatabaseService.getM4Object(stepId, clazz);
            this.compileStepBody(step, lazyMode);
        }
        catch (M4CompilerError ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("An M4CompilerError occured executing step no." + stepId + " in " + (lazyMode ? "lazy" : "eager") + " Mode:\n" + ex.getMessage());
        }
        catch (SQLException ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("An SQLException occured executing step no." + stepId + " in " + (lazyMode ? "lazy" : "eager") + " Mode:\n" + ex.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerInterfaceError("M4 interface error in CompilerAccessLogic: " + m4e.getMessage());
        }
    }

    private void compileStepBody(Step step, boolean lazyMode) throws SQLException, ParameterDeselectedError, M4CompilerError {
        this.doPrint(9, "Waiting for resources to compile step " + step.getId() + ".");
        ctc.addThread((short)2);
        boolean success = false;
        try {
            if (this.stepsDuringDbConnection++ >= 150) {
                try {
                    this.getDb().getFreshM4Connection();
                    this.stepsDuringDbConnection = 0;
                }
                catch (SQLException sqle) {
                    this.doPrint(10, "CompilerAccessLogic: Could not refresh DB connection!\n" + sqle);
                }
            }
            ExecutableOperator exOp = this.getExecutableOperator(step.getTheOperator());
            this.doPrint(9, "Executing step '" + step.getName() + "' (ID: " + step.getId() + ").");
            exOp.load(step);
            exOp.execute(lazyMode);
            try {
                step.setCompiled();
                this.getDb().updateDatabase();
                success = true;
            }
            catch (M4Exception e) {
                throw new M4CompilerError("Error when trying to set the compiled flag for step " + step.getId() + ":\n" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            ctc.subThread((short)2);
            this.doPrint(9, "Compilation of step '" + step.getName() + (success ? "' done." : "' was not successful!"));
            throw throwable;
        }
        Object var6_9 = null;
        ctc.subThread((short)2);
        this.doPrint(9, "Compilation of step '" + step.getName() + (success ? "' done." : "' was not successful!"));
    }

    private ExecutableOperator getExecutableOperator(Operator operator) throws M4CompilerError {
        String opClass = operator.getName();
        try {
            Class<?> theOpClass;
            try {
                theOpClass = Class.forName("miningmart.compiler.operator." + opClass);
            }
            catch (ClassNotFoundException e1) {
                try {
                    theOpClass = Class.forName("miningmart.compiler.operator.dista." + opClass);
                }
                catch (ClassNotFoundException e2) {
                    theOpClass = Class.forName("miningmart.compiler.operator.uep." + opClass);
                }
            }
            Constructor<?> c = theOpClass.getConstructor(EXEC_OP_CONSTRUCTOR_TYPE);
            Object[] params = new Object[]{};
            return (ExecutableOperator)c.newInstance(params);
        }
        catch (Exception e) {
            throw new M4CompilerError("Step.getExecutableOperator(): Could not find and initialise class " + opClass + "!\n" + e.getMessage());
        }
    }

    public void compileAll(long caseId, boolean lazyMode) throws M4CompilerInterfaceError {
        try {
            this.setCase(caseId);
            Iterator steps = this.getCase().getStepIterator();
            HashSet garbageCollected = new HashSet();
            while (steps.hasNext()) {
                Step currentStep = (Step)steps.next();
                if (!garbageCollected.contains(currentStep)) {
                    this.deleteTrashBeforeCompilingStep(currentStep);
                    Collection col = this.getCase().getDependentStepsFor(currentStep);
                    garbageCollected.addAll(col);
                }
                this.printBeforeStepInfo(currentStep, lazyMode);
                this.compileStepMultiStepControl(currentStep, lazyMode, false);
                this.printStepExecInfo(currentStep, lazyMode);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerInterfaceError("M4 interface error in CompilerAccessLogic: " + m4e.getMessage());
        }
    }

    public void compileStepFrom(long stepId, boolean lazyMode) throws M4CompilerInterfaceError {
        try {
            long caseId = this.getCaseIdByStepId(stepId);
            this.setCase(caseId);
            boolean garbageCollected = false;
            DB dB = this.getM4db();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Step");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Step step = (Step)dB.getM4Object(stepId, clazz);
            Iterator steps = this.getCase().getDependentStepsFor(step).iterator();
            while (steps.hasNext()) {
                Step currentStep = (Step)steps.next();
                if (!garbageCollected) {
                    this.deleteTrashBeforeCompilingStep(currentStep);
                    garbageCollected = true;
                }
                this.printBeforeStepInfo(currentStep, lazyMode);
                this.compileStepMultiStepControl(currentStep, lazyMode, false);
                this.printStepExecInfo(currentStep, lazyMode);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerInterfaceError("M4 interface error in CompilerAccessLogic: " + m4e.getMessage());
        }
    }

    private void deleteTrashBeforeCompilingStep(Step step) throws M4CompilerInterfaceError {
        this.deleteTrashFromStep(step);
        this.doPrint(9, String.valueOf(this.systemTime()) + " : Preparing execution of step '" + step.getName() + "', checking for MultiSteps...");
    }

    private void deleteTrashFromStep(Step step) throws M4CompilerInterfaceError {
        this.doPrint(9, String.valueOf(this.systemTime()) + " Waiting for resource to run garbage collection for step '" + step.getName() + "'.");
        try {
            try {
                ctc.addThread((short)1);
                this.doPrint(9, String.valueOf(this.systemTime()) + " Running garbage collection for step '" + step.getName() + "'.");
                Case theCase = step.getTheCase();
                Collection dependentSteps = theCase.getDependentStepsFor(step);
                LinkedList reverse = new LinkedList();
                Iterator it = dependentSteps.iterator();
                while (it.hasNext()) {
                    reverse.addFirst(it.next());
                }
                it = reverse.iterator();
                while (it.hasNext()) {
                    Step aStep = (Step)it.next();
                    aStep.deleteM4Trash();
                    aStep.deleteDbTrash();
                }
                this.getM4db().updateDatabase();
            }
            catch (M4CompilerError e) {
                throw new M4CompilerInterfaceError(e.getMessage());
            }
            catch (M4Exception e) {
                throw new M4CompilerInterfaceError(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                ctc.subThread((short)1);
            }
            catch (M4CompilerError e) {
                this.doPrint(e);
            }
            throw throwable;
        }
        Object var6_10 = null;
        try {
            ctc.subThread((short)1);
        }
        catch (M4CompilerError e) {
            this.doPrint(e);
        }
    }

    private long findStepId(String stepName) throws M4CompilerInterfaceError {
        String msg = "";
        try {
            String query = "SELECT st_id FROM step_t WHERE st_name = '" + stepName + "'";
            Long stepId = this.getDb().executeM4SingleValueSqlReadL(query);
            if (stepId != null) {
                return stepId;
            }
        }
        catch (SQLException e) {
            msg = "\nAn SQLException occured:\n" + e.getMessage();
        }
        catch (DbConnectionClosed m) {
            msg = "\nCompiler Thread was killed!\n" + m.getMessage();
        }
        msg = "M4 Database: Step with name '" + stepName + "' not found!" + msg;
        throw new M4CompilerInterfaceError(msg);
    }

    private void printBeforeStepInfo(Step step, boolean lazyMode) {
        this.doPrint(9, "\n--- " + this.systemTime() + " ---");
        this.doPrint(9, "Trying to execute Step '" + step.getName() + "' (ID: " + step.getId() + ") in " + (lazyMode ? "lazy" : "eager") + " mode ...");
    }

    private void printStepExecInfo(Step step, boolean lazyMode) {
        this.doPrint(9, "\n--- " + this.systemTime() + " ---");
        this.doPrint(9, "Execution for Step " + step.getName() + " without errors");
        this.doPrint(9, "Mode was set to " + (lazyMode ? "lazy" : "eager"));
    }

    private void printStepExecInfo(String stepName, boolean lazyMode) {
        this.doPrint(9, "\n--- " + this.systemTime() + " ---");
        this.doPrint(9, "Execution for Step " + stepName + " without errors");
        this.doPrint(9, "Mode was set to " + (lazyMode ? "lazy" : "eager"));
    }

    private String systemTime() {
        Calendar calendar = Calendar.getInstance();
        String day = this.fillUpToTwoDigits(calendar.get(5));
        String month = this.fillUpToTwoDigits(calendar.get(2) + 1);
        int year = calendar.get(1);
        String hour = this.fillUpToTwoDigits(calendar.get(11));
        String minutes = this.fillUpToTwoDigits(calendar.get(12));
        String seconds = this.fillUpToTwoDigits(calendar.get(13));
        String s = String.valueOf(day) + "." + month + "." + year + " " + hour + ":" + minutes + ":" + seconds;
        return s;
    }

    private String fillUpToTwoDigits(int number) {
        String s = Integer.toString(number);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public void updateColumnStatistics(long columnID) throws M4CompilerInterfaceError {
        try {
            this.doPrint(9, "Waiting for resources to updateColumnStatistics of column " + columnID + ".");
            ctc.addThread((short)2);
            this.doPrint(9, "Starting calculations for updating Column statistics (column id: " + columnID + ").");
            try {
                try {
                    Column myColumn2;
                    BaseAttribute ba;
                    DB dB = this.getM4db();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("edu.udo.miningmart.m4.core.Column");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((ba = (myColumn2 = (Column)dB.getM4Object(columnID, clazz)).getTheBaseAttribute()) == null) {
                        throw new M4CompilerInterfaceError("updateColumnStatistics: Trying to calculate statistics for Column not attached to a BaseAttribute!\nColumn ID is: " + columnID);
                    }
                    myColumn2.updateStatistics(ba.getConceptualDataType());
                    this.doPrint(9, "Updated column statistics of column " + columnID + ".");
                }
                catch (M4Exception m4e) {
                    throw new M4CompilerInterfaceError("M4 interface error in CompilerAccessLogic: " + m4e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ctc.subThread((short)2);
                throw throwable;
            }
            Object var5_8 = null;
            ctc.subThread((short)2);
        }
        catch (M4CompilerError ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("M4CompilerError trying to update ColumnStatistics for Column " + columnID + ":\n");
        }
    }

    public void updateColumnsetStatistics(long columnsetID) throws M4CompilerInterfaceError {
        try {
            this.doPrint(9, "Waiting for resources to updateColumnsetStatistics of columnset " + columnsetID + ".");
            ctc.addThread((short)2);
            this.doPrint(9, "Starting calculations for updating Columnset statistics (columnset id: " + columnsetID + ").");
            try {
                try {
                    CompilerDatabaseService compilerDatabaseService = this.getDb();
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Columnset myCol = (Columnset)compilerDatabaseService.getM4Object(columnsetID, clazz);
                    myCol.updateStatistics();
                    this.doPrint(9, "Updated columnset statistics of columnset " + columnsetID + ".");
                }
                catch (M4Exception m4e) {
                    throw new M4CompilerInterfaceError("M4 interface error in CompilerAccessLogic: " + m4e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ctc.subThread((short)2);
                throw throwable;
            }
            Object var4_7 = null;
            ctc.subThread((short)2);
        }
        catch (M4CompilerError ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("M4CompilerError trying to update ColumnsetStatistics for ColumnSet " + columnsetID + ":\n");
        }
    }

    public void updateStatisticsForConcept(long conceptID) throws M4CompilerInterfaceError {
        try {
            this.doPrint(9, "Waiting for resources to updateStatisticsForConcept of concept " + conceptID + ".");
            ctc.addThread((short)2);
            this.doPrint(9, "Starting calculations for updating Concept statistics (Concept id: " + conceptID + ").");
            try {
                try {
                    Concept myConcept;
                    DB dB = this.getM4db();
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = class$3 = Class.forName("edu.udo.miningmart.m4.core.Concept");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((myConcept = (Concept)dB.getM4Object(conceptID, clazz)) == null) {
                        throw new M4CompilerInterfaceError("CompilerAccessLogic.updateStatisticsForConcept:Concept with ID " + conceptID + " not found!");
                    }
                    Collection cols = myConcept.getColumnSets();
                    Iterator it = cols.iterator();
                    while (it.hasNext()) {
                        Columnset cs = (Columnset)it.next();
                        cs.updateStatistics();
                    }
                    this.getM4db().updateDatabase();
                    this.doPrint(9, "Updated statistics for concept " + conceptID + ".");
                }
                catch (M4Exception m4e) {
                    throw new M4CompilerInterfaceError("M4 interface error in CompilerAccessLogic: " + m4e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                ctc.subThread((short)2);
                throw throwable;
            }
            Object var7_10 = null;
            ctc.subThread((short)2);
        }
        catch (M4CompilerError ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("M4CompilerError trying to update statistics for concept " + conceptID + ":\n");
        }
    }

    public void deleteTrashForStep(long stepId) throws M4CompilerInterfaceError {
        if (this.getCase() == null) {
            long caseId = this.getCaseIdByStepId(stepId);
            this.setCase(caseId);
        }
        try {
            DB dB = this.getM4db();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Step");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Step step = (Step)dB.getM4Object(stepId, clazz);
            this.deleteTrashFromStep(step);
        }
        catch (M4Exception e) {
            throw new M4CompilerInterfaceError(e.getMessage());
        }
    }

    public void deleteTrashForCase(long caseId) throws M4CompilerInterfaceError {
        if (this.getCase() == null) {
            this.setCase(caseId);
        }
        HashSet gcDone = new HashSet();
        try {
            Iterator it = this.getCase().getStepIterator();
            while (it.hasNext()) {
                Step step = (Step)it.next();
                if (gcDone.contains(step)) continue;
                this.deleteTrashFromStep(step);
                Collection col = this.getCase().getDependentStepsFor(step);
                gcDone.addAll(col);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerInterfaceError("M4 interface error in CompilerAccessLogic: " + m4e.getMessage());
        }
    }

    public String getStatusMessage(long caseId, int numberOfLines) throws M4CompilerInterfaceError {
        BufferedReader in;
        StringBuffer ret = new StringBuffer("");
        if (this.casePrintObject == null) {
            return "";
        }
        String fileName = this.casePrintObject.getFileNameForCase(caseId);
        try {
            File f = new File(fileName);
            if (!f.exists()) {
                f.createNewFile();
            }
            in = new BufferedReader(new FileReader(f));
        }
        catch (IOException e) {
            return "";
        }
        LinkedList<String> ll = new LinkedList<String>();
        try {
            String s;
            while ((s = in.readLine()) != null) {
                ll.addLast(s);
                if (ll.size() <= numberOfLines) continue;
                ll.removeFirst();
            }
            Iterator it = ll.iterator();
            while (it.hasNext()) {
                ret.append((String)it.next());
                ret.append("\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret.toString();
    }

    public String getStatusFromLine(long caseId, int lineNumber) throws M4CompilerInterfaceError {
        StringBuffer sb = new StringBuffer(100);
        BufferedReader lnr = null;
        int curentLineNr = 0;
        if (this.casePrintObject == null) {
            return "";
        }
        try {
            try {
                String line;
                String fileName = this.casePrintObject.getFileNameForCase(caseId);
                lnr = new BufferedReader(new FileReader(fileName));
                while ((line = lnr.readLine()) != null) {
                    if (curentLineNr++ >= lineNumber) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                    ++curentLineNr;
                }
            }
            catch (IOException e) {
                throw new M4CompilerInterfaceError(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (lnr != null) {
                try {
                    lnr.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        Object var9_11 = null;
        if (lnr != null) {
            try {
                lnr.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return String.valueOf(++curentLineNr) + "\n" + sb.toString();
    }

    public void changeCompilerOutputVerbosity(long caseId, int newVerbosity) throws M4CompilerInterfaceError {
        this.setCase(caseId);
        this.casePrintObject.setMinimumVerbosityLevel(newVerbosity);
    }

    public boolean isReadyForCompilation(long stepId) throws M4CompilerInterfaceError {
        try {
            Step step;
            CompilerDatabaseService compilerDatabaseService = this.getDb();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Step");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((step = (Step)compilerDatabaseService.getM4Object(stepId, clazz)) == null) {
                throw new M4CompilerInterfaceError("CompilerAccessLogic.isReadyForCompilation: Step with ID " + stepId + " not found!");
            }
            if (step.isCompiled()) {
                return true;
            }
            Case m4Case = step.getTheCase();
            Iterator it = m4Case.getReverseIterator();
            while (it.hasNext() && !step.equals(it.next())) {
            }
            while (it.hasNext()) {
                Step pid = (Step)it.next();
                if (pid == null || !m4Case.containsDependency(pid, step) || pid.isCompiled()) continue;
                return false;
            }
            return true;
        }
        catch (M4Exception e) {
            throw new M4CompilerInterfaceError(e.getMessage());
        }
    }

    public void compileRestOfCase(long caseId, boolean lazyMode) throws M4CompilerInterfaceError {
        try {
            this.setCase(caseId);
            Iterator steps = this.getCase().getStepIterator();
            HashSet garbageCollected = new HashSet();
            while (steps.hasNext()) {
                Step currentStep = (Step)steps.next();
                if (currentStep.isCompiled() || !this.isReadyForCompilation(currentStep.getId())) continue;
                if (!garbageCollected.contains(currentStep)) {
                    this.deleteTrashBeforeCompilingStep(currentStep);
                    Collection col = this.getCase().getDependentStepsFor(currentStep);
                    garbageCollected.addAll(col);
                }
                this.printBeforeStepInfo(currentStep, lazyMode);
                this.compileStepMultiStepControl(currentStep, lazyMode, false);
                this.printStepExecInfo(currentStep, lazyMode);
            }
        }
        catch (M4Exception e) {
            throw new M4CompilerInterfaceError("Caught an M4CompilerError trying to compile case " + caseId + "\n" + e.getMessage());
        }
    }

    public CompilerDatabaseService getDb() {
        return this.m4db;
    }

    public DB getM4db() {
        return this.m4db;
    }

    public Print getCurrentPrintObject() {
        if (this.casePrintObject != null) {
            return this.casePrintObject;
        }
        return this.defaultPrintObject;
    }

    private void initDefaultPrintObject() {
        if (this.verbosity != null) {
            this.defaultPrintObject = Print.getGlobalPrintObject();
            this.defaultPrintObject.setMinimumVerbosityLevel(this.verbosity);
        } else {
            this.defaultPrintObject = Print.getGlobalPrintObject();
        }
    }

    private void initCasePrintObject(long caseId) {
        if (this.casePrintObject == null) {
            if (this.verbosity != null) {
                this.casePrintObject = Print.getGlobalPrintObject();
                this.casePrintObject.setMinimumVerbosityLevel(this.verbosity);
            } else {
                this.casePrintObject = Print.getGlobalPrintObject();
            }
        }
    }

    void setStopRequest() {
        this.stopThread = true;
    }

    public boolean getStopRequest() {
        return this.stopThread;
    }

    private void setCase(long caseId) throws M4CompilerInterfaceError {
        this.initCasePrintObject(caseId);
        try {
            DB dB = this.getM4db();
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("edu.udo.miningmart.m4.core.Case");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.caseObj = (Case)dB.getM4Object(caseId, clazz);
        }
        catch (M4Exception e) {
            throw new M4CompilerInterfaceError(e.getClass() + " while loading case for caseId " + caseId + "\nin method CompilerAccessLogic.setCase(caseId):\n" + e.getMessage());
        }
    }

    public Case getCase() {
        return this.caseObj;
    }

    private long getCaseIdByStepId(long stepId) throws M4CompilerInterfaceError {
        try {
            return this.getDb().readCaseIdForStepId(stepId);
        }
        catch (Exception e) {
            throw new M4CompilerInterfaceError(e.getClass() + " while loading caseId for stepId " + stepId + "\nin method CompilerAccessLogic.getCaseIdByStepId(stepId):\n" + e.getMessage());
        }
    }

    public Print getPrintObject() {
        return this.getCurrentPrintObject();
    }

    private void doPrint(int verbosity, String message) {
        this.getCurrentPrintObject().doPrint(verbosity, message);
    }

    private void doPrint(Exception e) {
        this.getCurrentPrintObject().doPrint(e);
    }

    public void compileAll(long caseId, boolean lazy, int verbosity) throws M4CompilerInterfaceError {
        this.compileAll(caseId, lazy);
    }

    public void compileStep(long stepId, boolean lazy, int verbosity) throws M4CompilerInterfaceError {
        this.compileStep(stepId, lazy);
    }

    public void compileStepFrom(long stepId, boolean lazy, int verbosity) throws M4CompilerInterfaceError {
        this.compileStepFrom(stepId, lazy);
    }

    public boolean killCompilerThread(long caseId) {
        return false;
    }
}

