/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compilerInterface;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.m4.hciImpl.CaseImpl;
import edu.udo.miningmart.m4.utils.Print;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import miningmart.compilerInterface.CompilerAccess;
import miningmart.compilerInterface.CompilerAccessLogic;
import miningmart.compilerInterface.M4CompilerInterfaceError;
import miningmart.m4.M4Interface;

public class CompilerAccessClient {
    private static final String LOOKUP_STRING = "aCompilerAccessImpl";
    private transient CompilerAccess compilerAccess;

    public CompilerAccessClient(Print printObject) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        String server = System.getProperty("COMPILER_SERVER");
        if (server == null) {
            String dbconfig = System.getProperty("DB_CONFIG_PATH");
            String verbosity = System.getProperty("PRINT_VERBOSITY");
            if (dbconfig == null || verbosity == null) {
                throw new M4CompilerInterfaceError("Missing System Property: Please set DB_CONFIG_PATH and PRINT_VERBOSITY");
            }
            DB db = ((CaseImpl)M4Interface.getCurrentCase()).getM4Db();
            this.compilerAccess = new CompilerAccessLogic(db, printObject);
            db.getCasePrintObject().doPrint(11, "Compiler running locally!");
        } else {
            this.compilerAccess = (CompilerAccess)((Object)Naming.lookup("//" + server + "/" + LOOKUP_STRING));
        }
    }

    public CompilerAccess getCompilerAccess() {
        return this.compilerAccess;
    }

    public static void main(String[] args) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        if (args.length > 1 || args.length == 1 && args[0].equalsIgnoreCase("exit")) {
            CompilerAccessClient c = new CompilerAccessClient(Print.getGlobalPrintObject());
            String command = args[0];
            int numArgs = args.length;
            String[] tmp = new String[numArgs - 1];
            int i = 0;
            while (i < tmp.length) {
                tmp[i] = args[i + 1];
                ++i;
            }
            args = tmp;
            if (command.equals("step")) {
                c.compileStep(args);
            } else if (command.equalsIgnoreCase("case")) {
                c.compileCase(args);
            } else if (command.equalsIgnoreCase("status")) {
                c.printStatus(args);
            } else if (command.equalsIgnoreCase("status_from")) {
                c.printStatusFrom(args);
            } else if (command.equalsIgnoreCase("stat-con")) {
                c.updateConceptStatistics(args);
            } else if (command.equalsIgnoreCase("stat-cs")) {
                c.updateColumnsetStatistics(args);
            } else if (command.equalsIgnoreCase("stat-col")) {
                c.updateColumnStatistics(args);
            } else if (command.equalsIgnoreCase("gc-step")) {
                c.garbageCollectionForStep(args);
            } else if (command.equalsIgnoreCase("gc-case")) {
                c.garbageCollectionForCase(args);
            } else if (command.equalsIgnoreCase("ready")) {
                c.checkStepReady(args);
            } else if (command.equalsIgnoreCase("exit")) {
                c.quitCompilerServer();
            }
        }
        System.err.println("Usage: java miningmart.compilerInterface.CompilerAccessClient\n          status   <caseId> [ numberOfLines ]\n          status_from <caseId> [ <startLineNum> ]\n        | case     <caseId> [<lazy> [<verbosity>]]\n        | step     <stepId> [<lazy> [<verbosity>]]\n        | stat-con <conceptId>\n        | stat-cs  <columnsetId>\n        | stat-col <columnId>\n        | gc-step  <stepId>\n        | gc-case  <caseId>\n        | ready    <stepId>\n        | exit\n");
        System.exit(-1);
    }

    private void printStatus(String[] args) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        int numberOfLines = 30;
        try {
            if (args.length > 1) {
                numberOfLines = Integer.parseInt(args[1]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        System.out.println("---------------------------------- Status ----------------------------------\n");
        String msg = this.getCompilerAccess().getStatusMessage(CompilerAccessClient.getObjId(args[0]), numberOfLines);
        System.out.println(msg);
        System.out.println("\n----------------------------------------------------------------------------");
        System.exit(0);
    }

    private void printStatusFrom(String[] args) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        int startNum = 0;
        try {
            if (args.length > 1) {
                startNum = Integer.parseInt(args[1]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        System.out.println("---------------------------------- Status ----------------------------------\n");
        String msg = this.getCompilerAccess().getStatusFromLine(CompilerAccessClient.getObjId(args[0]), startNum);
        System.out.println(msg);
        System.out.println("\n----------------------------------------------------------------------------");
        System.exit(0);
    }

    private void compileCase(String[] args) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        long objId = CompilerAccessClient.getObjId(args[0]);
        boolean lazyMode = args.length > 1 ? CompilerAccessClient.getLazyMode(args[1]) : false;
        System.out.println("Trying to compile case " + objId);
        String v = "";
        if (args.length <= 2) {
            this.getCompilerAccess().compileAll(objId, lazyMode);
        } else {
            v = ", " + args[2];
            int verbosity = CompilerAccessClient.getVerbosity(v);
            this.getCompilerAccess().compileAll(objId, lazyMode, verbosity);
        }
        System.out.println("Returned from compileAll(" + objId + ", " + (lazyMode ? "lazy" : "eager") + v + ");");
        System.exit(0);
    }

    private void compileStep(String[] args) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        long objId = CompilerAccessClient.getObjId(args[0]);
        boolean lazyMode = args.length > 1 ? CompilerAccessClient.getLazyMode(args[1]) : false;
        System.out.println("Trying to compile step " + objId + ".");
        String v = "";
        if (args.length > 2) {
            v = ", " + args[2];
            int verbosity = CompilerAccessClient.getVerbosity(v);
            this.getCompilerAccess().compileStep(objId, lazyMode, verbosity);
        } else {
            this.getCompilerAccess().compileStep(objId, lazyMode);
        }
        System.out.println("Returned from compileStep(" + objId + ", " + (lazyMode ? "lazy" : "eager") + v + ");");
        System.exit(0);
    }

    private void updateConceptStatistics(String[] args) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        long objId = CompilerAccessClient.getObjId(args[0]);
        System.out.println("Updating Concept statistics for Concept " + objId + ".");
        this.getCompilerAccess().updateStatisticsForConcept(objId);
        System.out.println("Statistics updated for object with id: " + objId + " !");
        System.exit(0);
    }

    private void updateColumnsetStatistics(String[] args) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        long objId = CompilerAccessClient.getObjId(args[0]);
        System.out.println("Updating Columnset statistics for Columnset " + objId + ".");
        this.getCompilerAccess().updateColumnsetStatistics(objId);
        System.out.println("Statistics updated for object with id: " + objId + " !");
        System.exit(0);
    }

    private void updateColumnStatistics(String[] args) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        long objId = CompilerAccessClient.getObjId(args[0]);
        System.out.println("Updating Column statistics for Column " + objId + ".");
        this.getCompilerAccess().updateColumnStatistics(objId);
        System.out.println("Statistics updated for object with id: " + objId + " !");
        System.exit(0);
    }

    private void garbageCollectionForStep(String[] args) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        long objId = CompilerAccessClient.getObjId(args[0]);
        System.out.println("Running Garbage Collection for Step " + objId + ".");
        this.getCompilerAccess().deleteTrashForStep(objId);
        System.out.println("Garbage for Step with id " + objId + " collected!");
        System.exit(0);
    }

    private void garbageCollectionForCase(String[] args) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        long objId = CompilerAccessClient.getObjId(args[0]);
        System.out.println("Running Garbage Collection for Case " + objId + ".");
        this.getCompilerAccess().deleteTrashForCase(objId);
        System.out.println("Garbage for Case with id " + objId + " collected!");
        System.exit(0);
    }

    private void checkStepReady(String[] args) throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        long objId = CompilerAccessClient.getObjId(args[0]);
        System.out.println("Checking if Step " + objId + " is ready for compilation.");
        boolean ready = this.getCompilerAccess().isReadyForCompilation(objId);
        System.out.println("Step with id " + objId + " is" + (ready ? "" : " not") + " ready for compilation!");
        System.exit(0);
    }

    private void quitCompilerServer() throws RemoteException, NotBoundException, MalformedURLException, M4CompilerInterfaceError {
        System.out.println("Trying to shut down the compiler server.");
        try {
            this.getCompilerAccess().killCompilerThread(-1L);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        System.exit(0);
    }

    private static long getObjId(String s) {
        try {
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static boolean getLazyMode(String s) {
        String lazyString = s.trim().toLowerCase();
        return lazyString.startsWith("l") || lazyString.startsWith("y");
    }

    private static int getVerbosity(String s) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

