/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.wrapper.dista.C45;

import edu.udo.miningmart.m4.core.Step;
import java.io.BufferedReader;
import java.io.FileReader;
import miningmart.compiler.operator.ExecutableOperator;
import miningmart.compiler.wrapper.dista.C45.C45Wrapper;
import miningmart.compiler.wrapper.dista.C45.Rules;
import miningmart.compiler.wrapper.dista.C45.Rules2PLSql;
import miningmart.compiler.wrapper.dista.C45.RulesParser;

public class RulesWrapper
extends C45Wrapper {
    protected Rules m_rules;
    protected double m_pruning_confidence = 0.25;
    protected int m_min_obj = 2;

    public RulesWrapper(Step step, ExecutableOperator exOp) throws Exception {
        super(step, exOp);
    }

    public void setPruningConfidence(double v) {
        this.m_pruning_confidence = v;
    }

    public void setMinObj(int v) {
        this.m_min_obj = v;
    }

    protected void callTool() throws Exception {
        this.callScript("c4.5 -c " + this.m_pruning_confidence + " -m " + this.m_min_obj + " -f " + this.m_file_name);
        this.callScript("c4.5rules -c " + this.m_pruning_confidence + " -f " + this.m_file_name);
        this.callScript("rules2dlf -f " + this.m_file_name);
    }

    protected void importResult() throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(String.valueOf(this.m_file_name) + "_rules.dlf"));
        RulesParser rp = new RulesParser(r);
        this.m_rules = rp.parse();
    }

    protected void saveResult() throws Exception {
        Rules2PLSql r2sql = new Rules2PLSql();
        r2sql.setMetaData(this.m_md);
        r2sql.setResultName(this.m_result_name);
        r2sql.setConnection(this.getM4Db());
        r2sql.convert(this.m_rules);
    }
}

