/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.wrapper.dista.C45;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Step;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.util.Vector;
import miningmart.compiler.operator.ConceptOperator;
import miningmart.compiler.operator.ExecutableOperator;
import miningmart.compiler.operator.FeatureConstruction;
import miningmart.compiler.utils.DrawSample;
import miningmart.compiler.wrapper.dista.ColumnInfo;
import miningmart.compiler.wrapper.dista.DMException;
import miningmart.compiler.wrapper.dista.Wrapper;
import miningmart.compilerInterface.SystemPropertyInterface;

public abstract class C45Wrapper
extends Wrapper {
    protected String m_file_name;
    protected PrintWriter m_data;
    protected PrintWriter m_names;
    private String sampleTableName;

    public C45Wrapper(Step step, ExecutableOperator exOp) throws Exception {
        super(step, exOp);
    }

    public void checkMetaData() throws Exception {
        if (this.m_md.getColumnToLearn() == null) {
            throw new DMException("C45 is a supervised learningalgoritm.  It require a column to learn");
        }
        if (this.m_md.getColumnToLearn().getConceptType() != 1 && this.m_md.getColumnToLearn().getConceptType() != 0 && this.m_md.getColumnToLearn().getConceptType() != 6) {
            throw new DMException("C45 can learn only a CATEGORICAL/NOMINAL/BINARTY conceptual datatype");
        }
        int i = 0;
        while (i < this.m_md.getColumnInfos().size()) {
            ColumnInfo ci = (ColumnInfo)this.m_md.getColumnInfos().elementAt(i);
            if (ci.getDataType() == 0 && ci.getConceptType() != 0 && ci.getConceptType() != 3 && ci.getConceptType() != 6 && ci.getConceptType() != 1) {
                throw new DMException("C45 require that  the column " + ci.getName() + " that is a string has a Nominal or " + " Categorial or Ordinal conceptual datatype");
            }
            ++i;
        }
    }

    protected String makeQuery() throws DMException, DbConnectionClosed, M4CompilerError {
        Columnset cs;
        Columnset tmp = null;
        Step theStep = this.getStep();
        if (theStep != null) {
            ExecutableOperator op = this.getExecutableOperator();
            Concept inputCon = null;
            if (op != null && op instanceof FeatureConstruction) {
                inputCon = ((FeatureConstruction)op).getTheInputConcept();
            } else if (op != null && op instanceof ConceptOperator) {
                inputCon = ((ConceptOperator)op).getInputConcept();
            }
            if (inputCon != null) {
                try {
                    tmp = inputCon == null ? null : inputCon.getCurrentColumnSet();
                }
                catch (M4Exception m4e) {
                    throw new M4CompilerError("M4 interface error in C45Wrapper: " + m4e.getMessage());
                }
            }
        }
        if ((cs = tmp) == null) {
            throw new DMException("Could not determine Columnset in class miningmart.compiler.wrapper.dista.C45Wrapper!");
        }
        long stepId = this.getStep().getId();
        String sampleTableName = "SAMPLE_" + stepId;
        this.setSampleTableName(sampleTableName);
        String tempTableName = "TMP_" + stepId;
        try {
            new DrawSample(cs, null, sampleTableName, tempTableName, null, this.m_sample_size, null, this.getM4Db());
            this.getM4Db().addTableToTrash(this.getSampleTableName(), cs.getSchema(), stepId);
        }
        catch (M4CompilerError e) {
            throw new DMException(e.getMessage());
        }
        String select = "SELECT ";
        int numberOfColumns = this.m_md.getColumnInfos().size();
        String[] singleColumns = new String[numberOfColumns + 1];
        String columns = "";
        int i = 0;
        while (i < numberOfColumns) {
            ColumnInfo ci;
            if (i != 0) {
                columns = String.valueOf(columns) + ", ";
            }
            singleColumns[i] = (ci = (ColumnInfo)this.m_md.getColumnInfos().elementAt(i)).getDataType() == 1 ? "m4_date_to_timestamp(" + ci.getName() + ")" : (ci.getDataType() == 5 ? "m4_date_to_timestamp(" + ci.getName() + ")" : ci.getName());
            columns = String.valueOf(columns) + singleColumns[i];
            ++i;
        }
        if (this.m_md.getColumnToLearn() != null) {
            singleColumns[numberOfColumns] = this.m_md.getColumnToLearn().getName();
            columns = String.valueOf(columns) + ", " + singleColumns[numberOfColumns];
        }
        String from = " FROM " + sampleTableName + " ";
        String where = "";
        if (this.m_md.getColumnToLearn() != null) {
            where = "WHERE " + this.m_md.getColumnToLearn().getName() + " is not null ";
        }
        String query = "SELECT " + columns + from + where;
        return query.trim();
    }

    protected void getValues() throws Exception {
        int i = 0;
        while (i < this.m_md.getColumnInfos().size()) {
            ColumnInfo ci = (ColumnInfo)this.m_md.getColumnInfos().elementAt(i);
            if (ci.getConceptType() == 3 && ci.getDataType() == 0) {
                this.getValues(ci);
            }
            ++i;
        }
    }

    protected void getValues(ColumnInfo ci) throws Exception {
        String q = "select " + ci.getSqlName() + " from " + this.m_md.getTableName() + " order by  " + ci.getSqlName();
        ResultSet res = null;
        try {
            res = this.getM4Db().executeBusinessSqlRead(q);
            while (res.next()) {
                ci.addValue(res.getString(1));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            DB.closeResultSet(res);
            throw throwable;
        }
        Object var4_6 = null;
        DB.closeResultSet(res);
    }

    protected void exportTable() throws Exception {
        String temporaryDir = SystemPropertyInterface.getProperty("TEMP_DIR");
        this.m_file_name = String.valueOf(temporaryDir) + File.separator + "c45_" + this.m_md.getTableName();
        BufferedWriter w = new BufferedWriter(new FileWriter(String.valueOf(this.m_file_name) + ".data"));
        this.m_data = new PrintWriter(w);
        w = new BufferedWriter(new FileWriter(String.valueOf(this.m_file_name) + ".names"));
        this.m_names = new PrintWriter(w);
        this.getValues();
        this.exportData();
        this.exportNames();
        this.m_data.close();
        this.m_data = null;
        this.m_names.close();
        this.m_names = null;
    }

    protected void exportData() throws Exception {
        ResultSet res = null;
        try {
            res = this.getM4Db().executeBusinessSqlRead(this.makeQuery());
            int col_num = this.m_md.getColumnInfos().size();
            while (res.next()) {
                int col_i = 1;
                while (col_i <= col_num) {
                    if (col_i != 1) {
                        this.m_data.print(",");
                    }
                    ColumnInfo ci = (ColumnInfo)this.m_md.getColumnInfos().elementAt(col_i - 1);
                    this.exportValue(res, col_i, ci);
                    ++col_i;
                }
                if (this.m_md.getColumnToLearn() != null) {
                    this.m_data.print(",");
                    this.exportValue(res, col_num + 1, this.m_md.getColumnToLearn());
                } else {
                    this.m_data.print(",X");
                }
                this.m_data.print("\n");
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            DB.closeResultSet(res);
            throw throwable;
        }
        Object var5_7 = null;
        DB.closeResultSet(res);
    }

    protected void exportValue(ResultSet res, int col_i, ColumnInfo ci) throws Exception {
        block0 : switch (ci.getConceptType()) {
            case 2: 
            case 4: 
            case 5: {
                switch (ci.getDataType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.m_data.print(res.getLong(col_i));
                        break;
                    }
                    case 5: {
                        this.m_data.print(res.getLong(col_i));
                        break;
                    }
                    case 2: {
                        this.m_data.print(res.getDouble(col_i));
                    }
                }
                break;
            }
            case 3: {
                switch (ci.getDataType()) {
                    case 0: {
                        this.m_data.print(ci.getValueIndex(res.getString(col_i)));
                        break;
                    }
                    case 1: {
                        this.m_data.print(res.getLong(col_i));
                        break;
                    }
                    case 5: {
                        this.m_data.print(res.getLong(col_i));
                        break;
                    }
                    case 2: {
                        this.m_data.print(res.getDouble(col_i));
                    }
                }
                break;
            }
            case 0: 
            case 1: 
            case 6: {
                switch (ci.getDataType()) {
                    case 0: {
                        this.m_data.print(ci.getValueIndex(res.getString(col_i)));
                        break block0;
                    }
                    case 1: {
                        ci.addValue(res.getString(col_i));
                        this.m_data.print(res.getString(col_i));
                        break block0;
                    }
                    case 5: {
                        ci.addValue(res.getString(col_i));
                        this.m_data.print(res.getString(col_i));
                        break block0;
                    }
                    case 2: {
                        ci.addValue(res.getString(col_i));
                        this.m_data.print(res.getString(col_i));
                    }
                }
            }
        }
    }

    protected void exportNames() throws Exception {
        int i;
        Vector values;
        if (this.m_md.getColumnToLearn() != null) {
            values = this.m_md.getColumnToLearn().getValues();
            i = 0;
            while (i < values.size()) {
                if (i != 0) {
                    this.m_names.print(",");
                }
                this.m_names.print(i);
                ++i;
            }
            this.m_names.print(".\n\n");
        } else {
            this.m_names.print("X,Y .\n\n");
        }
        i = 0;
        while (i < this.m_md.getColumnInfos().size()) {
            ColumnInfo ci = (ColumnInfo)this.m_md.getColumnInfos().elementAt(i);
            this.m_names.print(String.valueOf(ci.getName()) + ": ");
            switch (ci.getConceptType()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.m_names.print("continuous");
                    break;
                }
                case 0: 
                case 1: 
                case 6: {
                    int j;
                    values = ci.getValues();
                    if (ci.getDataType() == 0) {
                        j = 0;
                        while (j < values.size()) {
                            if (j != 0) {
                                this.m_names.print(",");
                            }
                            this.m_names.print(j);
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < values.size()) {
                            if (j != 0) {
                                this.m_names.print(",");
                            }
                            this.m_names.print(values.elementAt(j));
                            ++j;
                        }
                    }
                    break;
                }
            }
            this.m_names.print(".\n");
            ++i;
        }
    }

    protected void clean() throws Exception {
        this.callScript("rm " + this.m_file_name + ".* " + this.m_file_name + "_*");
    }

    protected void setSampleTableName(String sampleTableName) {
        this.sampleTableName = sampleTableName;
    }

    protected String getSampleTableName() {
        return this.sampleTableName;
    }
}

