/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.wrapper;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Value;
import edu.udo.miningmart.m4.utils.Print;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import miningmart.compiler.utils.DrawSample;
import miningmart.compiler.wrapper.SVM_Wrapper;

abstract class SupportVectorMachine
extends SVM_Wrapper {
    private String svmCommand;
    private String tempDir;
    protected String svmOutput;

    public SupportVectorMachine(CompilerDatabaseService databaseObj, Print printObj, String nameForDatabaseUse, String nameOfDatabaseSchema, long stepId, long sampleSize) throws M4CompilerError {
        super(databaseObj, printObj, nameForDatabaseUse, nameOfDatabaseSchema, stepId);
        this.sampleSize = sampleSize;
        String path = System.getProperty("ML_HOME");
        String osName = System.getProperty("os.name");
        if (osName.substring(0, 3).equalsIgnoreCase("win")) {
            osName = "Windows";
        }
        if (!(osName.equals("SunOS") || osName.equals("Linux") || osName.equals("Windows"))) {
            throw new M4CompilerError("SVM-Wrapper: current implementation works only on SunOS. Install\nmySVM for your Operating System and change the constructor in\n'SupportVectorMachine.java' (set the mySVM-command path) to adapt\nthe implementation.\nYour operating system is: " + System.getProperty("os.name"));
        }
        String s = File.separator;
        this.svmCommand = String.valueOf(path) + "bin" + s + osName + s + "mysvm";
        this.tempDir = System.getProperty("TEMP_DIR");
    }

    public void callSVM(Columnset inputColumnset, Column targetColumn, long conceptId, String c, String kernelType, String epsilon, Vector thePredictingColumns) throws M4CompilerError {
        Vector convertThisColumn = new Vector();
        String[] columnsToSelect = this.checkForConversion(inputColumnset, thePredictingColumns, targetColumn, convertThisColumn);
        if (columnsToSelect == null) {
            throw new M4CompilerError("Error in SVM Wrapper. No business data read.");
        }
        String ttable = "tmp1_" + this.myStepId;
        Vector<String> selectedCols = new Vector<String>();
        StringBuffer columnsBuf = new StringBuffer();
        int i = 0;
        while (i < columnsToSelect.length) {
            String cstring = columnsToSelect[i];
            selectedCols.add(cstring.toUpperCase());
            columnsBuf.append(String.valueOf(cstring) + ", ");
            ++i;
        }
        int le = columnsBuf.length();
        columnsBuf.delete(le - 2, le);
        String columns = columnsBuf.toString();
        new DrawSample(inputColumnset, selectedCols, ttable, "tmp2_" + this.myStepId, null, this.sampleSize, null, this.getDatabaseObj());
        String sql_getData = "SELECT " + columns + " FROM " + ttable + " WHERE " + targetColumn.getName() + " IS NOT NULL";
        ResultSet rs = null;
        try {
            try {
                rs = this.getDatabaseObj().executeBusinessSqlRead(sql_getData);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error in SVM Wrapper when reading business data: " + sqle.getMessage());
            }
            Process svmProcess = null;
            this.getPrint().doPrint(7, "Starting external algorithm (mySVM) (command: '" + this.svmCommand + "')...");
            try {
                String[] args = new String[]{this.svmCommand};
                svmProcess = Runtime.getRuntime().exec(args, null, new File(this.tempDir));
            }
            catch (IOException ioe) {
                if (svmProcess != null) {
                    svmProcess.destroy();
                }
                throw new M4CompilerError("Error accessing mySVM binary: " + ioe.getMessage());
            }
            OutputStream streamForDataInput = svmProcess.getOutputStream();
            try {
                this.createSVM_Input(rs, kernelType, c, epsilon, streamForDataInput, convertThisColumn);
            }
            catch (M4CompilerError mce) {
                svmProcess.destroy();
                throw mce;
            }
            this.svmOutput = this.readStream(svmProcess.getInputStream());
            if (this.svmOutput == null || this.svmOutput.equals("")) {
                throw new M4CompilerError("Error trying to read mySVM-Output!");
            }
            if (this.svmOutput.indexOf("* Error") > -1) {
                throw new M4CompilerError("Error in SVM: " + this.svmOutput);
            }
            String svmErrors = this.readStream(svmProcess.getErrorStream());
            if (!svmErrors.equals("")) {
                throw new M4CompilerError("An error occurred in mySVM: " + svmErrors);
            }
            this.getPrint().doPrint(0, "\n--- SVM output ---");
            this.getPrint().doPrint(0, this.svmOutput);
            this.getPrint().doPrint(0, "------------------\n");
        }
        catch (Throwable throwable) {
            Object var21_26 = null;
            DB.closeResultSet(rs);
            try {
                CompilerDatabaseService db = this.getDatabaseObj();
                db.dropBusinessTable(ttable);
            }
            catch (M4CompilerError m4e) {
                // empty catch block
            }
            throw throwable;
        }
        Object var21_27 = null;
        DB.closeResultSet(rs);
        try {
            CompilerDatabaseService db = this.getDatabaseObj();
            db.dropBusinessTable(ttable);
        }
        catch (M4CompilerError m4e) {
            // empty catch block
        }
        Vector<String> colNamesPredictingAttributes = new Vector<String>();
        int i2 = 0;
        while (i2 < thePredictingColumns.size()) {
            colNamesPredictingAttributes.add(((Column)thePredictingColumns.get(i2)).getName());
            ++i2;
        }
        try {
            this.processSVMResult(colNamesPredictingAttributes);
        }
        catch (Exception e) {
            throw new M4CompilerError("Wrapper for SVM: Error processing result of mySVM: " + e.getMessage());
        }
        if (this.forClassification) {
            this.extractXiAlpha();
        }
        this.createDecisionFunctionAsSQL_Function(kernelType, colNamesPredictingAttributes, convertThisColumn);
    }

    private void processSVMResult(Vector colNamesPredictingAttribs) throws M4CompilerError {
        int numberOfLearnAttribs = colNamesPredictingAttribs.size();
        String[] xValues = new String[numberOfLearnAttribs];
        boolean tableExisted = true;
        int numberOfSupportVectors = 0;
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(String.valueOf(this.tempDir) + "mysvm.svm"));
            String line = lnr.readLine().trim();
            while (line != null && (!Character.isDigit(line.charAt(0)) || line.charAt(0) == '-' && Character.isDigit(line.charAt(1)))) {
                if (line.startsWith("b ")) {
                    try {
                        this.b = Double.parseDouble(line.substring(1).trim());
                    }
                    catch (NumberFormatException nfe) {
                        throw new M4CompilerError("Error reading b from mySVM-Output: tried to convert " + line.substring(1).trim() + " into double.");
                    }
                    catch (IndexOutOfBoundsException ioube) {
                        throw new M4CompilerError("Error reading b from mySVM-Output: tried to read line " + line);
                    }
                }
                line = lnr.readLine();
            }
            tableExisted = this.getDatabaseObj().dropBusinessTable(this.getModelTableName());
            String sql_createTable = "CREATE TABLE " + this.getModelTableName() + " (";
            String numbertype = this.getDBMS_Datatype("NUMBER", null);
            int i = 0;
            while (i < numberOfLearnAttribs - 1) {
                sql_createTable = String.valueOf(sql_createTable) + (String)colNamesPredictingAttribs.get(i) + " " + numbertype + ", ";
                ++i;
            }
            sql_createTable = String.valueOf(sql_createTable) + (String)colNamesPredictingAttribs.get(numberOfLearnAttribs - 1) + " " + numbertype + ",  Alpha " + numbertype + ")";
            try {
                this.getDatabaseObj().executeBusinessSqlWrite(sql_createTable);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error trying to create the intermediate table, under name '" + this.getModelTableName() + "': " + sqle.getMessage());
            }
            this.getDatabaseObj().addTableToTrash(this.getModelTableName(), this.schema, this.myStepId);
            while (line != null) {
                StringTokenizer tok = new StringTokenizer(line);
                int i2 = 0;
                while (i2 < numberOfLearnAttribs) {
                    if (!tok.hasMoreTokens()) {
                        throw new M4CompilerError("Error reading the support vectors: wrong dimension!");
                    }
                    xValues[i2] = tok.nextToken();
                    xValues[i2] = this.checkDouble(xValues[i2]);
                    if (xValues[i2] == null) {
                        throw new M4CompilerError("Error reading mySVM-Resultfile (reading an x-Value): expected double, found " + xValues[i2]);
                    }
                    ++i2;
                }
                if (!tok.hasMoreTokens()) {
                    throw new M4CompilerError("Error reading the support vectors: wrong dimension!");
                }
                String label = tok.nextToken();
                if ((label = this.checkDouble(label)) == null) {
                    throw new M4CompilerError("Error reading mySVM-Resultfile (reading a label): expected double, found " + label);
                }
                if (!tok.hasMoreTokens()) {
                    throw new M4CompilerError("Error reading the support vectors: wrong dimension!");
                }
                String alpha = tok.nextToken();
                if ((alpha = this.checkDouble(alpha)) == null) {
                    throw new M4CompilerError("Error reading mySVM-Resultfile (reading an alpha): expected double, found " + alpha);
                }
                if (Double.parseDouble(alpha) != 0.0) {
                    String sql_insert = "insert into " + this.getModelTableName() + " values (";
                    i2 = 0;
                    while (i2 < numberOfLearnAttribs) {
                        sql_insert = String.valueOf(sql_insert) + xValues[i2] + ", ";
                        ++i2;
                    }
                    sql_insert = String.valueOf(sql_insert) + alpha + ")";
                    try {
                        this.getDatabaseObj().executeBusinessSqlWrite(sql_insert);
                    }
                    catch (SQLException sqle) {
                        throw new M4CompilerError("Error trying to insert values into intermediate table '" + this.getModelTableName() + "': " + sqle.getMessage());
                    }
                    ++numberOfSupportVectors;
                }
                line = lnr.readLine();
            }
        }
        catch (IOException ioe) {
            throw new M4CompilerError("Error: Could not access SVM-file after training: " + ioe.getMessage());
        }
        File f = new File(String.valueOf(this.tempDir) + "mysvm.svm");
        f.delete();
        this.noSV = numberOfSupportVectors;
        try {
            this.getDatabaseObj().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error trying to commit the transactions for the intermediate table: " + sqle.getMessage());
        }
        String message = "Found " + numberOfSupportVectors + " support vectors, entered them into intermediate table in database.";
        message = tableExisted ? String.valueOf(message) + " Replaced " : String.valueOf(message) + " Created ";
        message = String.valueOf(message) + "intermediate database table '" + this.getModelTableName() + "'.";
        this.getPrint().doPrint(7, message);
    }

    protected void extractNumberSV() {
    }

    private void createSVM_Input(ResultSet rs, String kernelType, String c, String epsilon, OutputStream whereTo, Vector convertColumn) throws M4CompilerError {
        if ((c = this.checkDouble(c)) == null) {
            throw new M4CompilerError("Wrapper for SVM: Parameter 'C' must be a real number!");
        }
        if (!this.forClassification) {
            this.lossPos = this.checkDouble(this.lossPos);
            if (this.lossPos == null) {
                throw new M4CompilerError("Wrapper for SVM: Parameter 'LossFunctionPos' must be a real number!");
            }
            this.lossNeg = this.checkDouble(this.lossNeg);
            if (this.lossNeg == null) {
                throw new M4CompilerError("Wrapper for SVM: Parameter 'LossFunctionNeg' must be a real number!");
            }
        }
        if (epsilon != null && (epsilon = this.checkDouble(epsilon)) == null) {
            throw new M4CompilerError("Wrapper for SVM: Parameter 'Epsilon' must be a real number!");
        }
        this.checkKernel(kernelType);
        PrintStream output = new PrintStream(whereTo);
        output.println("\n@parameters");
        if (this.forClassification) {
            output.println("pattern");
        } else {
            output.println("regression");
            output.println("epsilon " + epsilon);
        }
        output.println("C " + c);
        if (!this.forClassification) {
            output.println("L+ " + this.lossPos);
            output.println("L- " + this.lossNeg);
        }
        output.println("\n@kernel");
        output.println("type " + kernelType.toLowerCase());
        this.addKernelParameters(kernelType, output);
        output.println("\n@examples");
        output.println("format xy\n");
        int numberOfColumns = convertColumn.size();
        this.symbolsForBooleanValues = new String[2][numberOfColumns];
        int i = 0;
        while (i < numberOfColumns) {
            String colId = (String)convertColumn.get(i);
            if (colId != null) {
                int colid = 0;
                try {
                    colid = Integer.parseInt(colId);
                }
                catch (NumberFormatException nfe) {
                    throw new M4CompilerError("SVM-Wrapper: String '" + colId + "' was expected to be integer!");
                }
                Value[] vs = this.getDatabaseObj().getDistinctElements(colid);
                if (vs == null || vs.length != 2) {
                    throw new M4CompilerError("SVM-Wrapper: Column with Id " + colId + " is of type BINARY, but does not contain exactly two different values!");
                }
                String negValue = vs[0].getValue();
                String posValue = vs[1].getValue();
                if (i == numberOfColumns - 1) {
                    if (!posValue.equalsIgnoreCase(this.getPositiveTargetValue())) {
                        String a = posValue;
                        posValue = negValue;
                        negValue = a;
                    }
                    if (!posValue.equalsIgnoreCase(this.getPositiveTargetValue())) {
                        throw new M4CompilerError("SVM: Positive Target Value '" + this.getPositiveTargetValue() + "' not found in target attribute!");
                    }
                }
                this.symbolsForBooleanValues[0][i] = negValue;
                this.symbolsForBooleanValues[1][i] = posValue;
            } else {
                this.symbolsForBooleanValues[0][i] = "-1";
                this.symbolsForBooleanValues[1][i] = "1";
            }
            ++i;
        }
        boolean nothingWritten = true;
        int noOfWrittenRows = 0;
        try {
            while (rs.next()) {
                String line = "";
                int i2 = 1;
                while (i2 <= numberOfColumns) {
                    String entry = this.checkDouble(rs.getString(i2));
                    if (this.symbolsForBooleanValues[0][i2 - 1].equals("-1")) {
                        line = String.valueOf(line) + entry + " ";
                    } else if (entry.equalsIgnoreCase(this.symbolsForBooleanValues[0][i2 - 1])) {
                        line = String.valueOf(line) + "-1 ";
                    } else if (entry.equalsIgnoreCase(this.symbolsForBooleanValues[1][i2 - 1])) {
                        line = String.valueOf(line) + "1 ";
                    } else {
                        throw new M4CompilerError("Error producing SVM-input: found unknown entry in column with col_id = " + (String)convertColumn.get(i2) + ": " + entry);
                    }
                    ++i2;
                }
                output.println(line);
                ++noOfWrittenRows;
                nothingWritten = false;
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error accessing database query result: " + sqle.getMessage());
        }
        output.close();
        if (nothingWritten) {
            throw new M4CompilerError("SVM wrapper: empty training set!");
        }
        this.getPrint().doPrint(7, "SVM read " + noOfWrittenRows + " examples.");
    }

    protected void checkKernel(String kern) throws M4CompilerError {
        if (!(kern.equalsIgnoreCase("dot") || kern.equalsIgnoreCase("polynomial") || kern.equalsIgnoreCase("radial") || kern.equalsIgnoreCase("neural") || kern.equalsIgnoreCase("anova"))) {
            throw new M4CompilerError("Support Vector Machine: unknown or disallowed kernel type: " + kern + "!");
        }
    }

    protected void checkColSetType(String type) throws M4CompilerError {
    }

    protected Vector getColNamesInput(Vector colNamesPredictingAttribs) {
        return colNamesPredictingAttribs;
    }

    protected String getModelTablePlusCondition() {
        return this.getModelTableName();
    }

    private String readStream(InputStream in) throws M4CompilerError {
        StringBuffer sb;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            sb = new StringBuffer();
            String line = br.readLine();
            while (line != null) {
                sb.append(String.valueOf(line) + "\n");
                line = br.readLine();
            }
        }
        catch (IOException ioe) {
            throw new M4CompilerError("SupportVectorMachine: could not read mySVM-Output");
        }
        return sb.toString();
    }

    private void addKernelParameters(String kern, PrintStream output) throws M4CompilerError {
        Vector theKernelParams = this.getKernelParams(kern);
        if (theKernelParams == null) {
            return;
        }
        int i = 0;
        while (i < theKernelParams.size()) {
            output.println((String)theKernelParams.get(i));
            ++i;
        }
    }
}

