/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.wrapper;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Value;
import edu.udo.miningmart.m4.utils.Print;
import java.sql.SQLException;
import java.util.Vector;
import miningmart.compiler.utils.DrawSample;
import miningmart.compiler.wrapper.SVM_Wrapper;

public abstract class DB_SVM
extends SVM_Wrapper {
    private String defaultGamma = "0,1";
    private boolean viewWasCreated = false;
    private String keyCol = null;

    public DB_SVM(CompilerDatabaseService databaseObj, Print printObj, String nameForDatabaseUse, String nameOfDatabaseSchema, long stepId, String colNameKeyColumn) throws M4CompilerError {
        super(databaseObj, printObj, nameForDatabaseUse, nameOfDatabaseSchema, stepId);
        this.keyCol = colNameKeyColumn;
        this.sampleSize = -1L;
    }

    public DB_SVM(CompilerDatabaseService databaseObj, Print printObj, String nameForDatabaseUse, String nameOfDatabaseSchema, long stepId, String colNameKeyColumn, long sampleSize) throws M4CompilerError {
        this(databaseObj, printObj, nameForDatabaseUse, nameOfDatabaseSchema, stepId, colNameKeyColumn);
        this.sampleSize = sampleSize;
    }

    public void callSVM(Columnset inputColumnset, Column targetColumn, long conceptId, String c, String kernelType, String epsilon, Vector predictingColumns) throws M4CompilerError {
        Vector convertThisColumn = new Vector();
        String[] columns = this.checkForConversion(inputColumnset, predictingColumns, targetColumn, convertThisColumn);
        if (columns == null || columns.length < 2) {
            throw new M4CompilerError("Error in DB-SVM Wrapper. No business data read.");
        }
        Vector<Object> colNames = new Vector<Object>();
        int i = 0;
        while (i < predictingColumns.size()) {
            colNames.add(((Column)predictingColumns.get(i)).getName());
            ++i;
        }
        colNames.add(targetColumn);
        this.makeParameterTable(inputColumnset, columns, convertThisColumn, colNames, c, epsilon, kernelType);
        String[] procedureParams = new String[]{DB.quote(this.getParTableName())};
        this.getDatabaseObj().executeDBProcedure("mySVM", procedureParams, true);
        this.getDatabaseObj().addTableToTrash(this.getModelTableName(), this.schema, this.myStepId);
        this.getDatabaseObj().addTableToTrash(this.getLogTableName(), this.schema, this.myStepId);
        this.readSVMParameterB();
        if (this.forClassification) {
            this.extractXiAlpha();
        }
        this.extractNumberSV();
        Vector<String> colNamesPredictingAttributes = new Vector<String>();
        int i2 = 0;
        while (i2 < predictingColumns.size()) {
            colNamesPredictingAttributes.add(((Column)predictingColumns.get(i2)).getName());
            ++i2;
        }
        this.createDecisionFunctionAsSQL_Function(kernelType, colNamesPredictingAttributes, convertThisColumn);
    }

    private void makeParameterTable(Columnset inputColumnset, String[] columns, Vector convertThisColumn, Vector allColNames, String c, String epsilon, String kernelType) throws M4CompilerError {
        String parTableName = this.getParTableName();
        String modelName = this.getModelTableName();
        String logTableName = this.getLogTableName();
        this.checkKernel(kernelType);
        c = this.checkDouble(c);
        epsilon = this.checkDouble(epsilon);
        if (!this.forClassification) {
            this.lossPos = this.checkDouble(this.lossPos);
            this.lossNeg = this.checkDouble(this.lossNeg);
        }
        boolean inputIsView = false;
        String inputViewName = null;
        if (this.shouldCreateInputView(columns, convertThisColumn)) {
            inputIsView = true;
            inputViewName = this.createInputView(inputColumnset, columns, allColNames, convertThisColumn);
        }
        this.createParameterTable(parTableName);
        Vector theKernelParams = this.getKernelParams(kernelType);
        if (theKernelParams != null && !theKernelParams.isEmpty()) {
            String g = (String)theKernelParams.get(0);
            this.defaultGamma = g.substring(g.indexOf(" ") + 1);
        }
        try {
            CompilerDatabaseService db = this.getDatabaseObj();
            if (inputIsView) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "trainset", inputViewName));
            } else {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "trainset", this.inputTableName));
            }
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "verbosity", "0"));
            if (this.forClassification) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "svm_type", "pattern"));
                if (this.targetPositive != null && !this.targetPositive.equals("")) {
                    db.executeBusinessSqlWrite(this.insertionString(parTableName, "target_concept", this.targetPositive));
                }
            } else {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "svm_type", "regression"));
            }
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "kernel:type", kernelType));
            if (kernelType.equalsIgnoreCase("radial")) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "kernel:gamma", this.defaultGamma));
            }
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "c", c));
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "epsilon", epsilon));
            if (!this.forClassification) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "Cpos", this.lossPos));
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "Cneg", this.lossNeg));
            }
            if (inputIsView) {
                int i = 0;
                while (i < columns.length - 1) {
                    db.executeBusinessSqlWrite(this.insertionString(parTableName, "x_column", "X" + i));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < columns.length - 1) {
                    db.executeBusinessSqlWrite(this.insertionString(parTableName, "x_column", columns[i]));
                    ++i;
                }
            }
            if (inputIsView) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "y_column", "Y"));
            } else {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "y_column", columns[columns.length - 1]));
            }
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "model_name", modelName));
            if (this.keyCol != null) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "key_column", this.keyCol));
            }
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "xi_alpha", ""));
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "log_name", logTableName));
            db.commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: could not fill parameter table '" + parTableName + "' for mySVM/db; SQL exception: " + sqle.getMessage());
        }
    }

    private void createParameterTable(String name) throws M4CompilerError {
        try {
            this.getDatabaseObj().dropBusinessTable(name);
            String query = "CREATE TABLE " + name + "(PARAMETER VARCHAR2(100) NOT NULL, VALUE VARCHAR2(100))";
            this.getDatabaseObj().executeBusinessSqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: could not create parameter table '" + name + "' for mySVM/db; SQL exception: " + sqle.getMessage());
        }
        this.getDatabaseObj().addTableToTrash(name, this.schema, this.myStepId);
    }

    private boolean shouldCreateInputView(String[] columnDefinitions, Vector columnsToConvert) {
        if (this.sampleSize > -1L) {
            return true;
        }
        int i = 0;
        while (i < columnDefinitions.length) {
            if ((String)columnsToConvert.get(i) != null) {
                return true;
            }
            if (!Character.isLetter(columnDefinitions[i].charAt(0))) {
                return true;
            }
            if (columnDefinitions[i].startsWith("to_number")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String createInputView(Columnset inputColumnset, String[] columnDefinitions, Vector allColNames, Vector convertThisColumn) throws M4CompilerError {
        String inViewName = this.getInputViewName();
        this.createBooleanConversionFunctions(columnDefinitions, convertThisColumn);
        try {
            boolean useSample;
            this.getDatabaseObj().dropBusinessTable(inViewName);
            String ttable = "tmp1_" + this.myStepId;
            boolean bl = useSample = this.sampleSize > -1L;
            if (useSample) {
                new DrawSample(inputColumnset, allColNames, ttable, "tmp2_" + this.myStepId, null, this.sampleSize, null, this.getDatabaseObj());
                this.getDatabaseObj().addTableToTrash(ttable, inputColumnset.getSchema(), this.myStepId);
            }
            String query = "CREATE TABLE " + inViewName + " AS (";
            String select = "SELECT ";
            int i = 0;
            while (i < columnDefinitions.length - 1) {
                select = (String)convertThisColumn.get(i) != null ? String.valueOf(select) + this.getConversionFunctionName(i) + "(" + columnDefinitions[i] + ") AS X" + i + ", " : String.valueOf(select) + columnDefinitions[i] + " AS X" + i + ", ";
                ++i;
            }
            int t = columnDefinitions.length - 1;
            select = (String)convertThisColumn.get(t) != null ? String.valueOf(select) + this.getConversionFunctionName(t) + "(" + columnDefinitions[t] + ") AS Y" : String.valueOf(select) + columnDefinitions[t] + " AS Y";
            if (this.keyCol == null) {
                throw new M4CompilerError("DB-SVM: need to construct input view, but found no key column for input table!");
            }
            select = String.valueOf(select) + ", " + this.keyCol;
            query = useSample ? String.valueOf(query) + select + " FROM " + ttable + ")" : String.valueOf(query) + select + " FROM " + this.inputTableName + ")";
            this.getDatabaseObj().executeBusinessSqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: could not create inputView '" + inViewName + "' for mySVM/db; SQL exception: " + sqle.getMessage());
        }
        this.getDatabaseObj().addTableToTrash(inViewName, this.schema, this.myStepId);
        this.viewWasCreated = true;
        return inViewName;
    }

    private String insertionString(String tableName, String paramName, String value) {
        return "insert into " + tableName + " values ('" + paramName + "', '" + value + "')";
    }

    protected void checkColSetType(String type) throws M4CompilerError {
        if (type.equals("V") && this.keyCol == null) {
            throw new M4CompilerError("DB-SVM wrapper: No parameter 'TheKey' found, but input columnset is View!");
        }
    }

    protected void checkKernel(String kern) throws M4CompilerError {
        if (!kern.equalsIgnoreCase("dot") && !kern.equalsIgnoreCase("radial")) {
            throw new M4CompilerError("DB-SVM wrapper: unknown or disallowed kernel type: " + kern + "!");
        }
    }

    protected Vector getColNamesInput(Vector colNamesPredictingAttribs) {
        if (this.viewWasCreated) {
            Vector<String> inputNames = new Vector<String>(colNamesPredictingAttribs.size());
            int i = 0;
            while (i < colNamesPredictingAttribs.size()) {
                inputNames.add("X" + i);
                ++i;
            }
            return inputNames;
        }
        return colNamesPredictingAttribs;
    }

    protected String getModelTablePlusCondition() throws M4CompilerError {
        String s = "";
        if (this.viewWasCreated) {
            s = String.valueOf(this.getInputViewName()) + ", " + this.getModelTableName() + " WHERE " + this.getInputViewName() + "." + this.keyCol + " = " + this.getModelTableName() + ".KEY";
        } else {
            String key = null;
            if (this.keyCol != null) {
                key = this.keyCol;
            } else {
                if (this.usePostgres) {
                    throw new M4CompilerError("DB_SVM: Cannot work on input table without specified key under Postgres!");
                }
                key = "ROWID";
            }
            s = String.valueOf(this.inputTableName) + ", " + this.getModelTableName() + " WHERE " + this.inputTableName + "." + key + " = " + this.getModelTableName() + ".KEY";
        }
        return s;
    }

    private void createBooleanConversionFunctions(String[] columnDefinitions, Vector convertThisColumn) throws M4CompilerError {
        String columnId = null;
        try {
            boolean isTarget = false;
            int i = 0;
            while (i < convertThisColumn.size()) {
                columnId = (String)convertThisColumn.get(i);
                if (columnId != null) {
                    int colid = 0;
                    try {
                        colid = Integer.parseInt(columnId);
                    }
                    catch (NumberFormatException nfe) {
                        throw new M4CompilerError("DB-SVM-Wrapper: String '" + columnId + "' was expected to be integer!");
                    }
                    Value[] vs = this.getDatabaseObj().getDistinctElements(colid);
                    if (vs == null || vs.length != 2) {
                        throw new M4CompilerError("DB-SVM-Wrapper: Column with Id " + columnId + " is of type BINARY, but does not contain exactly two different values!");
                    }
                    isTarget = false;
                    if (i == convertThisColumn.size() - 1) {
                        isTarget = true;
                    }
                    String conversionFunction = this.createConversionFunction(vs, this.schema, this.getConversionFunctionName(i), isTarget);
                    this.getDatabaseObj().executeBusinessSqlWrite(conversionFunction);
                }
                ++i;
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: could not create boolean conversion functions, SQL exception: " + sqle.getMessage());
        }
        int i = 0;
        while (i < convertThisColumn.size()) {
            columnId = (String)convertThisColumn.get(i);
            if (columnId != null) {
                this.getDatabaseObj().addFunctionToTrash(this.getConversionFunctionName(i), this.schema, this.myStepId);
            }
            ++i;
        }
    }

    private String createConversionFunction(Value[] theSymbols, String schema, String functionName, boolean isTarget) throws M4CompilerError {
        String theFunction = "CREATE OR REPLACE function ";
        if (this.useOracle) {
            theFunction = String.valueOf(theFunction) + functionName + "\n(\n";
            theFunction = String.valueOf(theFunction) + "X IN VARCHAR";
            theFunction = String.valueOf(theFunction) + "\n)\nRETURN NUMBER \nAS\n";
            theFunction = String.valueOf(theFunction) + "BEGIN\n";
        }
        if (this.usePostgres) {
            theFunction = String.valueOf(theFunction) + schema + "." + functionName + "\n(\n";
            theFunction = String.valueOf(theFunction) + "NUMERIC";
            theFunction = String.valueOf(theFunction) + "\n)\nRETURNS NUMERIC \nAS '\n";
        }
        theFunction = String.valueOf(theFunction) + "  DECLARE\n";
        if (this.useOracle) {
            theFunction = String.valueOf(theFunction) + "    retValue NUMBER;\n";
        }
        if (this.usePostgres) {
            theFunction = String.valueOf(theFunction) + "    X ALIAS FOR $1;\n";
            theFunction = String.valueOf(theFunction) + "    retValue NUMERIC;\n";
        }
        theFunction = String.valueOf(theFunction) + "  BEGIN\n";
        String posValue = theSymbols[0].getValue();
        String negValue = theSymbols[1].getValue();
        if (isTarget && this.forClassification && this.targetPositive != null) {
            if (!this.targetPositive.equalsIgnoreCase(posValue)) {
                String a = posValue;
                posValue = negValue;
                negValue = a;
            }
            if (!this.targetPositive.equalsIgnoreCase(posValue)) {
                throw new M4CompilerError("SVM: Positive Target Value '" + this.getPositiveTargetValue() + "' not found in target attribute!");
            }
        }
        theFunction = String.valueOf(theFunction) + "    IF X = '" + posValue + "'\n" + "      THEN retValue := -1;\n";
        theFunction = String.valueOf(theFunction) + "    ELSIF X = '" + negValue + "'\n" + "      THEN retValue := 1;\n    END IF;\n";
        theFunction = String.valueOf(theFunction) + "    RETURN retValue;\n";
        theFunction = String.valueOf(theFunction) + "  END;\n";
        if (this.useOracle) {
            theFunction = String.valueOf(theFunction) + "END;\n";
        }
        if (this.usePostgres) {
            theFunction = String.valueOf(theFunction) + "' LANGUAGE 'plpgsql';";
        }
        return theFunction;
    }

    private String getConversionFunctionName(int index) {
        return String.valueOf(this.getDecisionFunctionName()) + index;
    }

    private void readSVMParameterB() throws M4CompilerError {
        try {
            String query = "SELECT alpha FROM " + this.getModelTableName() + " WHERE key IS NULL";
            String valueD = this.getDatabaseObj().executeBusinessSingleValueSqlRead(query);
            if (valueD == null) {
                throw new M4CompilerError("DB-SVM wrapper: could not find parameter b in SVM output! Tried to check in table: " + this.getModelTableName());
            }
            this.b = Double.parseDouble(valueD);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: error trying to read parameter b: " + sqle.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("DB-SVM wrapper: error trying to read parameter b: " + nfe.getMessage());
        }
    }

    protected void extractNumberSV() throws M4CompilerError {
        try {
            String query = "SELECT COUNT(*) FROM " + this.getModelTableName() + " WHERE key IS NOT NULL";
            Long count = this.getDatabaseObj().executeBusinessSingleValueSqlReadL(query);
            if (count == null) {
                throw new M4CompilerError("DB-SVM wrapper: could not extract number of support vectors in SVM output! Tried to check in table: " + this.getModelTableName());
            }
            this.noSV = count.intValue();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: error trying to read number of support vectors: " + sqle.getMessage());
        }
    }
}

