/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.utils;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Key;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

abstract class Sampling {
    public static final long COMMIT_LIMIT = 10000L;
    private final Columnset sourceCs;
    private final String tempTable;
    private final Collection selectedColumns;
    private final long rowcount;
    private final Random random;
    private final CompilerDatabaseService db;
    protected boolean materializedInput;
    protected boolean usingPostgres;
    protected boolean usingOracle;
    private String inputTableName;
    private static String SUFFIX_FOR_MATERIALIZED_INPUT = "_MATERIALIZED_FOR_SAMPLING";
    protected Vector allRowIds;
    protected String[] thePrimaryKey;
    protected String numericDatatypeName;
    protected String rowIdentifierName;

    protected Sampling(Columnset sourceCs, Collection selectedColumns, String tempTable, Long rowcount, Long seed, CompilerDatabaseService db) throws M4CompilerError {
        this.sourceCs = sourceCs;
        this.db = db;
        this.inputTableName = this.sourceCs.getSchemaPlusName();
        this.usingPostgres = this.db.getBusinessDbms() == 2;
        this.usingOracle = this.db.getBusinessDbms() == 1;
        this.numericDatatypeName = this.db.getNameOfNumericDatatype();
        this.rowIdentifierName = this.db.getUniqueRowIdentifier(true);
        this.thePrimaryKey = this.findPrimaryKeyAttribute();
        this.selectedColumns = selectedColumns;
        this.tempTable = tempTable;
        this.allRowIds = new Vector();
        this.rowcount = this.calculateRowCount(rowcount, this.sourceCs, this.db, this.usingPostgres, this.allRowIds, this.inputTableName);
        this.random = seed == null ? new Random() : new Random(seed);
    }

    private long calculateRowCount(Long rowcount, Columnset cs, DB db, boolean usingPostgres, Vector allRowIds, String inputTableName) throws M4CompilerError {
        try {
            if (rowcount == null) {
                String selectWhat = "";
                selectWhat = this.usingOracle ? "COUNT(*)" : this.thePrimaryKey[0];
                String query = "SELECT " + selectWhat + " FROM " + this.inputTableName;
                ResultSet rs = db.executeBusinessSqlRead(query);
                if (this.usingOracle) {
                    rowcount = rs.next() ? new Long(rs.getLong(1)) : null;
                } else {
                    this.allRowIds = new Vector();
                    while (rs.next()) {
                        this.allRowIds.add(new Long(rs.getLong(1)));
                        this.allRowIds.trimToSize();
                    }
                    rowcount = new Long(this.allRowIds.size());
                }
                if (rowcount == null) {
                    throw new M4CompilerError("Constructor of DrawSample: Could not determine number of rows for Columnset " + cs.getName());
                }
            }
        }
        catch (SQLException e) {
            throw new M4CompilerError("miningmart.compiler.utils.DrawSample:\n" + e.getMessage());
        }
        return rowcount;
    }

    public String getSourceAttributes() throws M4CompilerError {
        try {
            Collection columns = this.getSourceTableColumns();
            StringBuffer sb = new StringBuffer();
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column theCol = (Column)it.next();
                String colName = theCol.getName().toUpperCase();
                if (this.selectedColumns != null && !this.selectedColumns.contains(colName) || theCol.getTheBaseAttribute() == null) continue;
                sb.append(String.valueOf(colName) + ", ");
            }
            int le = sb.length();
            if (le >= 2) {
                sb.delete(le - 2, le);
            }
            return sb.toString();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in Sampling: " + m4e.getMessage());
        }
    }

    public String getSourceAttributeDefinitions() throws M4CompilerError {
        try {
            Collection columns = this.getSourceTableColumns();
            StringBuffer sb = new StringBuffer();
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column theColumn = (Column)it.next();
                if (this.selectedColumns != null && !this.selectedColumns.contains(theColumn.getName().toUpperCase()) || theColumn.getTheBaseAttribute() == null) continue;
                String sql = theColumn.getSQLDefinition();
                String name = theColumn.getName();
                if (sql == null || sql.equals(name) || this.materializedInput) {
                    sb.append(name);
                } else {
                    sb.append("(" + sql + ") AS " + name);
                }
                sb.append(", ");
            }
            int le = sb.length();
            if (le >= 2) {
                sb.delete(le - 2, le);
            }
            return sb.toString();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in Sampling: " + m4e.getMessage());
        }
    }

    public String getSourceTableName() {
        return this.inputTableName;
    }

    public Collection getSourceTableColumns() throws M4CompilerError {
        try {
            return this.sourceCs.getColumns();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in Sampling: " + m4e.getMessage());
        }
    }

    public String getTempTableName() {
        return this.tempTable;
    }

    public long getRowCount() {
        return this.rowcount;
    }

    public double getNextRandomDouble() {
        return this.random.nextDouble();
    }

    protected void dbWrite(String sql) throws SQLException, DbConnectionClosed {
        this.db.executeBusinessSqlWrite(sql);
    }

    protected void deleteTable(String tableName) throws M4CompilerError {
        this.db.dropBusinessTable(tableName);
    }

    protected void commit() throws DbConnectionClosed, SQLException {
        this.db.commitBusinessTransactions();
    }

    private void createInputTable() throws M4CompilerError {
        this.inputTableName = String.valueOf(this.inputTableName) + SUFFIX_FOR_MATERIALIZED_INPUT;
        this.materializedInput = true;
        try {
            String inputSelect = this.sourceCs.getCompleteSQLQuery();
            if (inputSelect.toUpperCase().indexOf(" FROM (SELECT") > -1) {
                inputSelect = String.valueOf(inputSelect) + " AS ZZZ";
            }
            String sql = "CREATE TABLE " + this.inputTableName + " AS " + inputSelect;
            this.db.executeBusinessSqlWrite(sql);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Sampling: could not materialize input view for Postgres: " + sqle.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Sampling: could not materialize input view for Postgres: " + m4e.getMessage());
        }
    }

    private String[] findPrimaryKeyAttribute() throws M4CompilerError {
        if (this.usingOracle) {
            String[] keyAttribute = new String[]{this.db.getUniqueRowIdentifier(true), this.db.getDbNameOfM4Datatype("NUMBER", 0, true)};
            return keyAttribute;
        }
        try {
            Key pk;
            Column primKeyColumn;
            Iterator it = this.sourceCs.getPrimaryKeys().iterator();
            if (it.hasNext() && (primKeyColumn = (pk = (Key)it.next()).getFirstPrimaryKeyColumn()) != null) {
                String[] keyAttribute = new String[]{primKeyColumn.getName(), primKeyColumn.getColumnDataTypeName()};
                return keyAttribute;
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Sampling: M4 exception when determining primary key for Columnset '" + this.sourceCs.getName() + "': " + m4e.getMessage());
        }
        if (this.sourceCs.getType().equals("V") && this.usingPostgres) {
            this.createInputTable();
        } else {
            this.materializedInput = false;
        }
        String[] keyAttribute = new String[]{this.rowIdentifierName, this.numericDatatypeName};
        return keyAttribute;
    }
}

