/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.utils;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.Columnset;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import miningmart.compiler.utils.Sampling;

public class RandomPartition
extends Sampling {
    private final String[] destTableNames;
    private final boolean stopWithTempTable;

    public RandomPartition(Columnset sourceCs, Collection selectedColumns, String[] destTableNames, boolean stopWithTempTable, String tempTable, Long rowcount, Long seed, CompilerDatabaseService db) throws M4CompilerError {
        super(sourceCs, selectedColumns, tempTable, rowcount, seed, db);
        this.destTableNames = destTableNames;
        this.stopWithTempTable = stopWithTempTable;
        try {
            this.createTempTable();
            if (!this.isStopWithTempTable()) {
                this.joinSourceWithTempTable();
                this.deleteTable(this.getTempTableName());
            }
            db.commitBusinessTransactions();
        }
        catch (SQLException e) {
            throw new M4CompilerError("miningmart.compiler.utils.DrawSample:\n" + e.getMessage());
        }
    }

    private String getDestTableName(int i) {
        String[] dtm = this.destTableNames;
        if (dtm != null && i > 0 && i < dtm.length) {
            return this.destTableNames[i];
        }
        return null;
    }

    private int getHowMany() {
        return this.destTableNames.length;
    }

    private int getNextRandomPartition() {
        double d = this.getNextRandomDouble();
        return (int)(d *= (double)this.getHowMany());
    }

    private void createTempTable() throws M4CompilerError, SQLException {
        this.deleteTable(this.getTempTableName());
        this.dbWrite("CREATE TABLE " + this.getTempTableName() + " ( the_Id " + this.numericDatatypeName + ", the_Segment " + this.numericDatatypeName + " )");
        String prefix = "INSERT INTO " + this.getTempTableName() + " VALUES ( ";
        String separ = ", ";
        String suffix = " )";
        long loops = this.getRowCount();
        long commitCounter = 0L;
        Iterator it = null;
        if (this.usingPostgres) {
            it = ((AbstractList)this.allRowIds).iterator();
        }
        long i = 1L;
        while (i <= loops) {
            Long nextNumber = this.usingPostgres ? (Long)it.next() : new Long(i);
            int partition = this.getNextRandomPartition();
            this.dbWrite(String.valueOf(prefix) + nextNumber + ", " + partition + " )");
            if (++commitCounter >= 10000L) {
                this.commit();
                commitCounter = 0L;
            }
            ++i;
        }
    }

    private void joinSourceWithTempTable() throws M4CompilerError, SQLException {
        int howMany = this.getHowMany();
        int segmentNumber = 0;
        while (segmentNumber < howMany) {
            String destTable = this.getDestTableName(segmentNumber);
            String sqlDefs = this.getSourceAttributeDefinitions();
            String colNames = this.getSourceAttributes();
            this.deleteTable(destTable);
            String idAttr = "ROW_NUM_";
            while (colNames.indexOf(idAttr) >= 0) {
                idAttr = String.valueOf(idAttr) + "Z";
            }
            String innerQuery = "( SELECT " + this.rowIdentifierName + " AS " + idAttr + ", " + sqlDefs + " FROM " + this.getSourceTableName() + " )";
            String query = "CREATE TABLE " + destTable + " AS SELECT " + colNames + " FROM " + this.getTempTableName() + " T, " + innerQuery + " S" + " WHERE t.the_Segment = " + segmentNumber + " AND s." + idAttr + " = t.the_Id";
            this.dbWrite(query);
            ++segmentNumber;
        }
    }

    public boolean isStopWithTempTable() {
        return this.stopWithTempTable;
    }
}

