/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.utils;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.Columnset;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import miningmart.compiler.utils.Sampling;

public class DrawSample
extends Sampling {
    private final String destTable;
    private final double ratio;

    public DrawSample(Columnset sourceCs, String destTable, String tempTable, double ratio, CompilerDatabaseService db) throws M4CompilerError {
        this(sourceCs, destTable, tempTable, null, ratio, null, db);
    }

    public DrawSample(Columnset sourceCs, String destTable, String tempTable, Long rowcount, double ratio, Long seed, CompilerDatabaseService db) throws M4CompilerError {
        super(sourceCs, null, tempTable, rowcount, seed, db);
        this.destTable = destTable;
        this.ratio = ratio;
        try {
            this.createTempTable();
            this.joinSourceWithTempTable();
            this.deleteTable(this.getTempTableName());
            db.commitBusinessTransactions();
        }
        catch (SQLException e) {
            this.deleteTable(this.getTempTableName());
            this.deleteTable(this.getDestTableName());
            throw new M4CompilerError("miningmart.compiler.utils.DrawSample:\n" + e.getMessage());
        }
    }

    public DrawSample(Columnset sourceCs, String destTable, String tempTable, Long rowcount, long sampleSize, Long seed, CompilerDatabaseService db) throws M4CompilerError {
        this(sourceCs, null, destTable, tempTable, rowcount, sampleSize, seed, db);
    }

    public DrawSample(Columnset sourceCs, Collection selectedColumns, String destTable, String tempTable, Long rowcount, long sampleSize, Long seed, CompilerDatabaseService db) throws M4CompilerError {
        block6: {
            super(sourceCs, selectedColumns, tempTable, rowcount, seed, db);
            this.destTable = destTable;
            this.ratio = (double)sampleSize / (double)this.getRowCount();
            try {
                try {
                    this.createTempTable();
                    this.joinSourceWithTempTable();
                    this.deleteTable(this.getTempTableName());
                    db.commitBusinessTransactions();
                }
                catch (SQLException e) {
                    this.deleteTable(this.getTempTableName());
                    this.deleteTable(this.getDestTableName());
                    throw new M4CompilerError("miningmart.compiler.utils.DrawSample:\n" + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (this.materializedInput) {
                    this.deleteTable(this.getSourceTableName());
                }
                throw throwable;
            }
            Object var11_12 = null;
            if (!this.materializedInput) break block6;
            this.deleteTable(this.getSourceTableName());
        }
    }

    public String getDestTableName() {
        return this.destTable;
    }

    public boolean getNextBoolean() {
        return this.getNextRandomDouble() <= this.ratio;
    }

    private void createTempTable() throws M4CompilerError, SQLException {
        this.deleteTable(this.getTempTableName());
        this.dbWrite("CREATE TABLE " + this.getTempTableName() + " ( the_Id " + this.numericDatatypeName + " )");
        String prefix = "INSERT INTO " + this.getTempTableName() + " VALUES ( ";
        String suffix = " )";
        long loops = this.getRowCount();
        long commitCounter = 0L;
        Iterator it = null;
        if (this.usingPostgres) {
            it = ((AbstractList)this.allRowIds).iterator();
        }
        long i = 1L;
        while (i <= loops) {
            Long nextNumber;
            Long l = nextNumber = this.usingPostgres ? (Long)it.next() : new Long(i);
            if (this.getNextBoolean()) {
                this.dbWrite(String.valueOf(prefix) + nextNumber.toString() + " )");
                if (++commitCounter >= 10000L) {
                    this.commit();
                    commitCounter = 0L;
                }
            }
            ++i;
        }
        this.commit();
    }

    private void joinSourceWithTempTable() throws M4CompilerError, SQLException {
        String destTable = this.getDestTableName();
        String sqlDefs = this.getSourceAttributeDefinitions();
        String colNames = this.getSourceAttributes();
        this.deleteTable(destTable);
        String idAttr = "ROW_NUM_";
        while (colNames.indexOf(idAttr) >= 0) {
            idAttr = String.valueOf(idAttr) + "Z";
        }
        String innerQuery = "";
        innerQuery = "( SELECT " + this.rowIdentifierName + " AS " + idAttr + ", " + sqlDefs + " FROM " + this.getSourceTableName() + " )";
        String query = "CREATE TABLE " + destTable + " AS SELECT " + colNames + " FROM " + this.getTempTableName() + " T, " + innerQuery + " S" + " WHERE s." + idAttr + " = t.the_Id";
        this.dbWrite(query);
    }
}

