/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.utils;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Case;
import edu.udo.miningmart.m4.core.Chain;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Operator;
import edu.udo.miningmart.m4.core.Parameter;
import edu.udo.miningmart.m4.core.ParameterObject;
import edu.udo.miningmart.m4.core.Step;
import edu.udo.miningmart.m4.core.Value;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class AttributeCreationTool {
    protected final DB myDB;
    protected final Case myCase;
    protected final Concept myInputConcept;
    protected final Chain myChain;
    protected final Columnset myInputColumnset;
    protected final Column myIndexColumn;
    protected final BaseAttribute myIndexBA;
    protected Step myStep;
    protected Operator myOperator;
    protected int numOfLoops;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public AttributeCreationTool(Concept inputConcept, BaseAttribute indexBA, Chain chain) throws M4Exception {
        String msgIntro = "Constructor of " + this.getClass().getName() + ":\n";
        if (inputConcept == null || indexBA == null || chain == null) {
            throw new M4Exception(String.valueOf(msgIntro) + "<null> argument found!");
        }
        if (!inputConcept.equals(indexBA.getTheConcept())) {
            throw new M4Exception(String.valueOf(msgIntro) + "The specified index BaseAttribute does not belong to the InputConcept!");
        }
        this.myDB = inputConcept.getM4Db();
        this.myInputConcept = inputConcept;
        this.myChain = chain;
        this.myCase = inputConcept.getTheCase();
        this.myIndexBA = indexBA;
        if (this.myCase == null || !this.myCase.equals(chain.getTheCase())) {
            throw new M4Exception(String.valueOf(msgIntro) + "InputConcept and Chain are not part of the same Case!");
        }
        Collection csCollection = this.myInputConcept.getColumnSets();
        if (csCollection.size() != 1) {
            throw new M4Exception(String.valueOf(msgIntro) + "InputConcept must have exactly one Columnset, but has" + csCollection.size() + "!");
        }
        this.myInputColumnset = (Columnset)csCollection.iterator().next();
        if (this.myInputColumnset == null) {
            throw new M4Exception(String.valueOf(msgIntro) + "InputConcept has no Columnset (NULL entry in Columnset list)!");
        }
        Collection indexColCollection = indexBA.getColumns();
        if (indexColCollection.size() != 1) {
            boolean exception = true;
            if (indexColCollection.size() > 1) {
                Iterator it = indexColCollection.iterator();
                while (it.hasNext()) {
                    Column col = (Column)it.next();
                    if (col == null || !this.myInputColumnset.equals(col.getColumnset())) continue;
                    this.myDB.getCasePrintObject().doPrint(11, String.valueOf(msgIntro) + "WARNING: found multiple Columns in Index BaseAttribute, choosing the one linked to the found Columnset!");
                    indexColCollection.clear();
                    indexColCollection.add(col);
                    exception = false;
                    break;
                }
            }
            if (exception) {
                throw new M4Exception(String.valueOf(msgIntro) + "Found no (suitable) Column for Index BaseAttribute!");
            }
        }
        this.myIndexColumn = (Column)indexColCollection.iterator().next();
        if (this.myIndexColumn == null) {
            throw new M4Exception(String.valueOf(msgIntro) + "Index BaseAttribute has a null entry instead of the column!");
        }
    }

    public void execute() throws Exception {
        Iterator it = this.createOutputBAs().iterator();
        this.createStep();
        while (it.hasNext()) {
            Object[] array = (Object[])it.next();
            String val = (String)array[0];
            BaseAttribute newBa = (BaseAttribute)array[1];
            this.createLoopForBa(newBa, val);
        }
        this.updateLoopNr();
        this.myDB.getCasePrintObject().doPrint(7, String.valueOf(this.getClass().getName()) + ": Writing changes to M4 database!");
        this.commit();
    }

    protected abstract int getIdOfOperator();

    protected abstract String getNameOfOperator();

    protected abstract String getNameOfNewStep();

    protected abstract String getConceptualDatatypeNameOfNewAttributes() throws M4Exception;

    protected abstract void insertSpecificParameters(int var1, int var2, String var3) throws M4Exception;

    protected void createStep() throws M4Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Step");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Step newStep = (Step)this.myDB.createNewInstance(clazz);
        newStep.setTheCase(this.myCase);
        newStep.setTheChain(this.myChain);
        int stepNr = this.myCase.getTheSteps().size();
        String stepName = String.valueOf(stepNr) + " " + this.getNameOfNewStep();
        newStep.setName(stepName);
        newStep.setNumber(stepNr);
        long l = this.getIdOfOperator();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("edu.udo.miningmart.m4.core.Operator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.myOperator = (Operator)this.myDB.getM4Object(l, clazz2);
        if (this.myOperator == null || !this.myOperator.getName().equals(this.getNameOfOperator())) {
            throw new M4Exception("PivotizeWithoutAggregation: Could not find operator " + this.getNameOfOperator() + "," + " expected to have ID " + this.getIdOfOperator() + "!");
        }
        newStep.setTheOperator(this.myOperator);
        this.numOfLoops = 0;
        newStep.setLoopCount(this.numOfLoops);
        this.myStep = newStep;
        this.createParameterForNewStep(this.numOfLoops, 1, "TheInputConcept", true, this.myInputConcept);
    }

    protected void createLoopForBa(BaseAttribute outputBa, String targetValS) throws M4Exception {
        int loopNr = ++this.numOfLoops;
        int parNr = 2;
        this.createParameterForNewStep(loopNr, parNr++, "TheTargetAttribute", true, this.myIndexBA);
        this.createParameterForNewStep(loopNr, parNr++, "TheOutputAttribute", false, outputBa);
        this.insertSpecificParameters(loopNr, parNr, targetValS);
    }

    protected Collection createOutputBAs() throws M4Exception, M4CompilerError {
        Vector<Object[]> newBaCollection = new Vector<Object[]>();
        String query = "SELECT DISTINCT " + this.myIndexColumn.getSQLDefinition() + " FROM " + this.myInputColumnset.getSQLDefinition();
        String baNamePre = String.valueOf(this.myIndexBA.getName()) + "_";
        ResultSet rs = null;
        try {
            try {
                rs = this.myDB.executeBusinessSqlRead(query);
                while (rs.next()) {
                    String value = rs.getString(1);
                    if (rs.wasNull()) continue;
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("edu.udo.miningmart.m4.core.BaseAttribute");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    BaseAttribute newBa = (BaseAttribute)this.myDB.createNewInstance(clazz);
                    newBa.setName(String.valueOf(baNamePre) + value);
                    newBa.setConceptualDataTypeName(this.myIndexBA.getConceptualDataTypeName());
                    newBa.setDBAttrib(false);
                    newBa.setConcept(this.myInputConcept);
                    Object[] baData = new Object[]{value, newBa};
                    newBaCollection.add(baData);
                }
            }
            catch (SQLException sqle) {
                throw new M4Exception("PivotizeWithoutAggregation: SQLException caught when reading distinct values of index attribute: " + sqle.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var8_11 = null;
        DB.closeResultSet(rs);
        this.myDB.getCasePrintObject().doPrint(7, "PivotizeWithoutAggregation: Successfully created BaseAttributes for " + newBaCollection.size() + " values!");
        return newBaCollection;
    }

    protected void createParameterForNewStep(int loopNr, int parNr, String parName, boolean isInput, ParameterObject theParObject) throws M4Exception {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("edu.udo.miningmart.m4.core.Parameter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Parameter newPar = (Parameter)this.myDB.createNewInstance(clazz);
        newPar.setName(String.valueOf(parName) + loopNr);
        newPar.setTheParameterObject(theParObject);
        newPar.setTheOperator(this.myOperator);
        newPar.setIsInputParam(isInput);
        newPar.setParamNr(parNr);
        newPar.setTheStep(this.myStep);
        newPar.setLoopNr(loopNr);
    }

    protected void createInputValueParameter(String parameterName, int loopNr, String value, int valCondDT, int parNr) throws M4Exception {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("edu.udo.miningmart.m4.core.Value");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Value valueObj = (Value)this.myDB.createNewInstance(clazz);
        String valueName = String.valueOf(parameterName) + "_" + loopNr;
        valueObj.setName(valueName);
        valueObj.setType(valCondDT);
        valueObj.setValue(value);
        this.createParameterForNewStep(loopNr, parNr, parameterName, true, valueObj);
    }

    private void updateLoopNr() {
        this.myStep.setLoopCount(this.numOfLoops);
    }

    private void commit() throws M4Exception {
        this.myDB.updateDatabase();
    }
}

