/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.uep;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Value;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeMap;
import miningmart.compiler.operator.uep.Discretization;

public class ImplicitErrorBasedDiscretization
extends Discretization {
    public Value getFullMerge() {
        return (Value)this.getSingleParameter("FullMerge", this.getCurrentLoopNumber());
    }

    public Value getClosedTo() {
        return (Value)this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
    }

    public Value[] getSampleSize() {
        return (Value[])this.getParameter("SampleSize", this.getCurrentLoopNumber());
    }

    private long sampleSize() {
        Value[] tmp = this.getSampleSize();
        if (tmp.length == 0) {
            return 10000L;
        }
        return Long.parseLong(tmp[0].getValue());
    }

    public BaseAttribute getTheClassAttribute() {
        return (BaseAttribute)this.getSingleParameter("TheClassAttribute", this.getCurrentLoopNumber());
    }

    public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError {
        myData x1;
        Column theClassAttributeColumn;
        ArrayList<myData> cutPoint = new ArrayList<myData>();
        TreeMap<String, Long> clss = new TreeMap<String, Long>();
        this.doPrint(7, "ImplicitErrorBasedDiscretization:");
        try {
            theClassAttributeColumn = this.getTheClassAttribute().getCurrentColumn();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        Value[] classes = this.getM4Db().getDistinctElementsWithoutNull(theClassAttributeColumn);
        int i = 0;
        while (i < classes.length) {
            clss.put(classes[i].getValue(), new Long(i + 1));
            ++i;
        }
        Value[] elements = this.getM4Db().getCountOfElements(theClassAttributeColumn, theTargetAttributeColumn, this.sampleSize());
        myData val = null;
        i = 0;
        while (i < elements.length) {
            StringTokenizer t = new StringTokenizer(elements[i].getValue(), ",");
            long cnt = Long.parseLong(t.nextToken());
            String s = t.nextToken();
            double v = Double.parseDouble(t.nextToken());
            if (i == 0) {
                val = new myData();
                val.value = v;
                val.maxfreq = 0L;
                val.label = 0L;
                val.LBound = v - 1.0;
                val.UBound = v + 1.0;
                val.count = 0L;
                cutPoint.add(val);
            } else if (v != val.value) {
                double d;
                val.UBound = d = (v + val.value) / 2.0;
                val = new myData();
                val.value = v;
                val.maxfreq = 0L;
                val.label = 0L;
                val.LBound = d;
                val.UBound = v + 1.0;
                val.count = 0L;
                cutPoint.add(val);
            }
            val.count += cnt;
            if (cnt >= val.maxfreq) {
                if (cnt == val.maxfreq) {
                    val.label += (long)(1 << (int)((Long)clss.get(s) - 1L));
                } else {
                    val.maxfreq = cnt;
                    val.label = 1 << (int)((Long)clss.get(s) - 1L);
                }
            }
            ++i;
        }
        i = 0;
        while (i < cutPoint.size() - 1) {
            x1 = (myData)cutPoint.get(i);
            myData x2 = (myData)cutPoint.get(i + 1);
            if (x1.label == x2.label) {
                x1.maxfreq += x2.maxfreq;
                x1.UBound = x2.UBound;
                x1.count += x2.count;
                cutPoint.remove(i + 1);
                continue;
            }
            ++i;
        }
        if (this.getFullMerge().getValue().equalsIgnoreCase("yes")) {
            myData x3;
            this.doPrint(7, "Satrting FullMerge ...");
            i = 1;
            while (i < cutPoint.size() - 1) {
                x1 = (myData)cutPoint.get(i - 1);
                myData x2 = (myData)cutPoint.get(i);
                x3 = (myData)cutPoint.get(i + 1);
                if (x1.label == x3.label && (x1.label & x2.label) > 0L) {
                    x1.maxfreq = x1.maxfreq + x2.maxfreq + x3.maxfreq;
                    x1.UBound = x3.UBound;
                    x1.count = x1.count + x2.count + x3.count;
                    cutPoint.remove(i);
                    cutPoint.remove(i);
                    continue;
                }
                ++i;
            }
            i = 1;
            while (i < cutPoint.size() - 1) {
                x1 = (myData)cutPoint.get(i - 1);
                myData x2 = (myData)cutPoint.get(i);
                x3 = (myData)cutPoint.get(i + 1);
                if ((x1.label & x2.label) > 0L || (x2.label & x3.label) > 0L) {
                    if ((x1.label & x2.label) > 0L && (x2.label & x3.label) > 0L) {
                        if (x1.count < x3.count) {
                            x1.maxfreq += x2.maxfreq;
                            x1.UBound = x2.UBound;
                            x1.count += x2.count;
                            cutPoint.remove(i);
                            ++i;
                            continue;
                        }
                        x2.maxfreq += x3.maxfreq;
                        x2.UBound = x3.UBound;
                        x2.count += x3.count;
                        cutPoint.remove(i + 1);
                        ++i;
                        continue;
                    }
                    if ((x1.label & x2.label) > 0L) {
                        x1.maxfreq += x2.maxfreq;
                        x1.UBound = x2.UBound;
                        x1.count += x2.count;
                        cutPoint.remove(i);
                        ++i;
                        continue;
                    }
                    x2.maxfreq += x3.maxfreq;
                    x2.UBound = x3.UBound;
                    x2.count += x3.count;
                    cutPoint.remove(i + 1);
                    ++i;
                    continue;
                }
                ++i;
                ++i;
            }
        }
        this.doPrint(7, "\nNew intervals:");
        i = 0;
        while (i < cutPoint.size()) {
            this.doPrint(7, ((myData)cutPoint.get(i)).Text());
            ++i;
        }
        double[] cp = new double[cutPoint.size() - 1];
        i = 0;
        while (i < cutPoint.size() - 1) {
            cp[i] = ((myData)cutPoint.get((int)i)).UBound;
            ++i;
        }
        return cp;
    }

    public class myData {
        public double value;
        public double LBound;
        public double UBound;
        public long label;
        public long maxfreq;
        public long count;

        public String Text() {
            return "(" + this.LBound + ", " + this.UBound + ") - " + this.count + " elements";
        }
    }
}

