/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.uep;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Value;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeMap;
import miningmart.compiler.operator.uep.Grouping;

public class ErrorBasedGroupingGivenNoOfGroups
extends Grouping {
    private final int SORT_BY_LABEL = 1;
    private final int SORT_BY_COUNT = 2;

    public Value getNoOfGroups() {
        return (Value)this.getSingleParameter("NoOfGroups", this.getCurrentLoopNumber());
    }

    public Value[] getLabels() {
        return (Value[])this.getParameter("Labels", this.getCurrentLoopNumber());
    }

    public Value[] getSampleSize() {
        return (Value[])this.getParameter("SampleSize", this.getCurrentLoopNumber());
    }

    private long sampleSize() {
        Value[] tmp = this.getSampleSize();
        if (tmp.length == 0) {
            return 10000L;
        }
        return Long.parseLong(tmp[0].getValue());
    }

    public BaseAttribute getTheClassAttribute() {
        return (BaseAttribute)this.getSingleParameter("TheClassAttribute", this.getCurrentLoopNumber());
    }

    public String[] generateLabels(int num) {
        Value[] l = this.getLabels();
        String[] labels = new String[num];
        boolean gen = true;
        if (l.length != 0) {
            if (l.length > 0 && l.length != num) {
                this.doPrint(7, "Incorrect number of given labels, labels generated automaticaly!");
            } else {
                gen = false;
            }
        }
        int i = 0;
        while (i < num) {
            labels[i] = gen ? "_" + (i + 1) : l[i].getValue();
            ++i;
        }
        return labels;
    }

    public String[] generateGroups(Column theTargetAttributeColumn) throws M4CompilerError {
        Column theClassAttributeColumn;
        TreeMap<cmpMyData, myData> cutPointSort = new TreeMap<cmpMyData, myData>();
        TreeMap<String, Long> clss = new TreeMap<String, Long>();
        this.defaultValue = true;
        this.doPrint(7, "ErrorBasedGroupingGivenNoOfGroups:");
        try {
            theClassAttributeColumn = this.getTheClassAttribute().getCurrentColumn();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        Value[] classes = this.getM4Db().getDistinctElementsWithoutNull(theClassAttributeColumn);
        int i = 0;
        while (i < classes.length) {
            clss.put(classes[i].getValue(), new Long(i + 1));
            ++i;
        }
        Value[] elements = this.getM4Db().getCountOfElements(theClassAttributeColumn, theTargetAttributeColumn, this.sampleSize());
        myData val = null;
        i = 0;
        while (i < elements.length) {
            StringTokenizer t = new StringTokenizer(elements[i].getValue(), ",");
            long cnt = Long.parseLong(t.nextToken());
            String s = t.nextToken();
            String v = "'" + t.nextToken() + "'";
            if (i == 0) {
                val = new myData();
                val.value = v;
                val.maxfreq = 0L;
                val.label = 0L;
                val.count = 0L;
                val.sortBy = 1;
            } else if (!v.equals(val.value)) {
                cutPointSort.put(new cmpMyData(val), val);
                val = new myData();
                val.value = v;
                val.maxfreq = 0L;
                val.label = 0L;
                val.count = 0L;
                val.sortBy = 1;
            }
            val.count += cnt;
            if (cnt >= val.maxfreq) {
                if (cnt == val.maxfreq) {
                    val.label += (long)(1 << (int)((Long)clss.get(s) - 1L));
                    ++val.maxgrps;
                } else {
                    val.maxfreq = cnt;
                    val.label = 1 << (int)((Long)clss.get(s) - 1L);
                    val.maxgrps = 1;
                }
            }
            ++i;
        }
        cutPointSort.put(new cmpMyData(val), val);
        ArrayList cutPoint = new ArrayList(cutPointSort.values());
        i = 0;
        while (i < cutPoint.size() - 1) {
            myData x1 = (myData)cutPoint.get(i);
            myData x2 = (myData)cutPoint.get(i + 1);
            if (x1.label == x2.label) {
                x1.maxfreq += x2.maxfreq;
                x1.count += x2.count;
                x1.value = String.valueOf(x1.value) + ", " + x2.value;
                cutPoint.remove(i + 1);
                continue;
            }
            ++i;
        }
        long minGroups = Long.parseLong(this.getNoOfGroups().getValue());
        if (minGroups < (long)cutPoint.size()) {
            this.doPrint(7, "Satrting FullMerge ...");
            TreeMap<cmpMyData, myData> singleMax = new TreeMap<cmpMyData, myData>();
            TreeMap<cmpMyData, myData> multiMax = new TreeMap<cmpMyData, myData>();
            i = 0;
            while (i < cutPoint.size()) {
                myData tmp = (myData)cutPoint.get(i);
                tmp.sortBy = 2;
                if (tmp.maxgrps == 1) {
                    singleMax.put(new cmpMyData(tmp), tmp);
                } else {
                    multiMax.put(new cmpMyData(tmp), tmp);
                }
                ++i;
            }
            long min = minGroups - (long)singleMax.size();
            if (min < 0L) {
                min = 0L;
            }
            while ((long)multiMax.size() > min) {
                myData attach = null;
                myData tmp = (myData)multiMax.get(multiMax.firstKey());
                multiMax.remove(multiMax.firstKey());
                ArrayList tmplst = new ArrayList(singleMax.values());
                i = 0;
                while (i < tmplst.size()) {
                    if ((tmp.label & ((myData)tmplst.get((int)i)).label) > 0L) {
                        attach = (myData)tmplst.get(i);
                        break;
                    }
                    ++i;
                }
                if (attach == null) {
                    singleMax.put(new cmpMyData(tmp), tmp);
                    continue;
                }
                singleMax.remove(new cmpMyData(attach));
                attach.label &= tmp.label;
                attach.maxfreq += tmp.maxfreq;
                attach.count += tmp.count;
                attach.value = String.valueOf(attach.value) + ", " + tmp.value;
                singleMax.put(new cmpMyData(attach), attach);
            }
            if (minGroups < (long)singleMax.size()) {
                while ((long)singleMax.size() > minGroups) {
                    myData x1 = (myData)singleMax.get(singleMax.firstKey());
                    singleMax.remove(singleMax.firstKey());
                    myData x2 = (myData)singleMax.get(singleMax.firstKey());
                    singleMax.remove(singleMax.firstKey());
                    x1.count += x2.count;
                    x1.label = 0L;
                    x1.maxfreq = 0L;
                    x1.value = String.valueOf(x1.value) + ", " + x2.value;
                    singleMax.put(new cmpMyData(x1), x1);
                }
                cutPoint = new ArrayList(singleMax.values());
            } else {
                cutPoint = new ArrayList(singleMax.values());
                if (multiMax.size() > 0) {
                    cutPoint.addAll(multiMax.values());
                }
            }
        }
        this.doPrint(7, "New groups:");
        i = 0;
        while (i < cutPoint.size()) {
            this.doPrint(7, ((myData)cutPoint.get(i)).Text());
            ++i;
        }
        String[] gr = new String[cutPoint.size()];
        i = 0;
        while (i < cutPoint.size()) {
            gr[i] = ((myData)cutPoint.get((int)i)).value;
            ++i;
        }
        return gr;
    }

    public class myData {
        public final int SORT_BY_LABEL = 1;
        public final int SORT_BY_COUNT = 2;
        public String value;
        public long label;
        public long maxfreq;
        public long count;
        public int sortBy;
        public int maxgrps;

        public String Text() {
            return String.valueOf(this.value) + " - " + this.count + " items.";
        }

        public int compareTo(Object Obj) {
            int ret = 1;
            switch (this.sortBy) {
                case 1: {
                    ret = new Long(this.label).compareTo(new Long(((myData)Obj).label));
                    break;
                }
                case 2: {
                    ret = new Long(this.count).compareTo(new Long(((myData)Obj).count));
                }
            }
            if (ret == 0) {
                ret = this.value.compareTo(((myData)Obj).value);
            }
            return ret;
        }

        public boolean equals(Object Obj) {
            boolean ret = false;
            switch (this.sortBy) {
                case 1: {
                    ret = this.label == ((myData)Obj).label;
                    break;
                }
                case 2: {
                    boolean bl = ret = this.count == ((myData)Obj).count;
                }
            }
            return ret && this.value.equals(((myData)Obj).value);
        }
    }

    public class cmpMyData
    implements Comparable {
        public myData value;

        public cmpMyData(myData val) {
            this.value = val;
        }

        public int compareTo(Object Obj) {
            return this.value.compareTo(((cmpMyData)Obj).value);
        }

        public boolean equals(Object Obj) {
            return this.value.equals(((cmpMyData)Obj).value);
        }
    }
}

