/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.uep;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Value;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeMap;
import miningmart.compiler.operator.uep.Discretization;

public class ErrorBasedDiscretizationGivenMinCardinality
extends Discretization {
    public Value getMinCardinality() {
        return (Value)this.getSingleParameter("MinCardinality", this.getCurrentLoopNumber());
    }

    public Value getMinCardinalityType() {
        return (Value)this.getSingleParameter("MinCardinalityType", this.getCurrentLoopNumber());
    }

    public Value getClosedTo() {
        return (Value)this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
    }

    public Value[] getSampleSize() {
        return (Value[])this.getParameter("SampleSize", this.getCurrentLoopNumber());
    }

    private long sampleSize() {
        Value[] tmp = this.getSampleSize();
        if (tmp.length == 0) {
            return 10000L;
        }
        return Long.parseLong(tmp[0].getValue());
    }

    public BaseAttribute getTheClassAttribute() {
        return (BaseAttribute)this.getSingleParameter("TheClassAttribute", this.getCurrentLoopNumber());
    }

    public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError {
        Column theClassAttributeColumn;
        ArrayList<myData> cutPoint = new ArrayList<myData>();
        TreeMap<String, Long> clss = new TreeMap<String, Long>();
        this.doPrint(7, "ErrorBasedDiscretizationMinCardinality:");
        try {
            theClassAttributeColumn = this.getTheClassAttribute().getCurrentColumn();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        Value[] classes = this.getM4Db().getDistinctElementsWithoutNull(theClassAttributeColumn);
        int i = 0;
        while (i < classes.length) {
            clss.put(classes[i].getValue(), new Long(i + 1));
            ++i;
        }
        Value[] elements = this.getM4Db().getCountOfElements(theClassAttributeColumn, theTargetAttributeColumn, this.sampleSize());
        myData val = null;
        i = 0;
        while (i < elements.length) {
            StringTokenizer t = new StringTokenizer(elements[i].getValue(), ",");
            long cnt = Long.parseLong(t.nextToken());
            String s = t.nextToken();
            double v = Double.parseDouble(t.nextToken());
            if (i == 0) {
                val = new myData();
                val.value = v;
                val.maxfreq = 0L;
                val.label = 0L;
                val.LBound = v - 1.0;
                val.UBound = v + 1.0;
                val.count = 0L;
                cutPoint.add(val);
            } else if (v != val.value) {
                double d;
                val.UBound = d = (v + val.value) / 2.0;
                val = new myData();
                val.value = v;
                val.maxfreq = 0L;
                val.label = 0L;
                val.LBound = d;
                val.UBound = v + 1.0;
                val.count = 0L;
                cutPoint.add(val);
            }
            val.count += cnt;
            int id = ((Long)clss.get(s)).intValue() - 1;
            val.freq[id] = cnt;
            if (cnt >= val.maxfreq) {
                if (cnt == val.maxfreq) {
                    val.label += (long)(1 << id);
                } else {
                    val.maxfreq = cnt;
                    val.label = 1 << id;
                }
            }
            ++i;
        }
        i = 0;
        while (i < cutPoint.size() - 1) {
            myData x1 = (myData)cutPoint.get(i);
            myData x2 = (myData)cutPoint.get(i + 1);
            if (x1.label == x2.label) {
                x1.maxfreq += x2.maxfreq;
                x1.UBound = x2.UBound;
                x1.count += x2.count;
                int x = 0;
                while (x < classes.length) {
                    x1.freq[x] = x1.freq[x] + x2.freq[x];
                    ++x;
                }
                cutPoint.remove(i + 1);
                continue;
            }
            ++i;
        }
        long minCard = Long.parseLong(this.getMinCardinality().getValue());
        do {
            int x;
            myData x1;
            int minID = 0;
            long min = ((myData)cutPoint.get((int)minID)).count;
            i = 1;
            while (i < cutPoint.size()) {
                if (((myData)cutPoint.get((int)i)).count < min) {
                    min = ((myData)cutPoint.get((int)i)).count;
                    minID = i;
                }
                ++i;
            }
            if (min >= minCard) break;
            myData x2 = (myData)cutPoint.get(minID);
            if (minID == 0) {
                myData x3 = (myData)cutPoint.get(minID + 1);
                int x4 = 0;
                while (x4 < classes.length) {
                    x2.freq[x4] = x2.freq[x4] + x3.freq[x4];
                    if (x2.freq[x4] > x2.maxfreq) {
                        x2.label = 1 << x4;
                        x2.maxfreq = x2.freq[x4];
                    } else if (x2.freq[x4] == x2.maxfreq) {
                        x2.label += (long)(1 << x4);
                    }
                    ++x4;
                }
                x2.count += x3.count;
                x2.UBound = x3.UBound;
                cutPoint.remove(minID + 1);
                continue;
            }
            if (minID == cutPoint.size() - 1) {
                x1 = (myData)cutPoint.get(minID - 1);
                int x5 = 0;
                while (x5 < classes.length) {
                    x1.freq[x5] = x1.freq[x5] + x2.freq[x5];
                    if (x1.freq[x5] > x1.maxfreq) {
                        x1.label = 1 << x5;
                        x1.maxfreq = x1.freq[x5];
                    } else if (x1.freq[x5] == x1.maxfreq) {
                        x1.label += (long)(1 << x5);
                    }
                    ++x5;
                }
                x1.count += x2.count;
                x1.UBound = x2.UBound;
                cutPoint.remove(minID);
                continue;
            }
            x1 = (myData)cutPoint.get(minID - 1);
            myData x3 = (myData)cutPoint.get(minID + 1);
            if (x1.count + x2.count - (x1.maxfreq + x2.maxfreq) < x2.count + x3.count - (x2.maxfreq + x3.maxfreq)) {
                x = 0;
                while (x < classes.length) {
                    x1.freq[x] = x1.freq[x] + x2.freq[x];
                    if (x1.freq[x] > x1.maxfreq) {
                        x1.label = 1 << x;
                        x1.maxfreq = x1.freq[x];
                    } else if (x1.freq[x] == x1.maxfreq) {
                        x1.label += (long)(1 << x);
                    }
                    ++x;
                }
                x1.count += x2.count;
                x1.UBound = x2.UBound;
                cutPoint.remove(minID);
                continue;
            }
            x = 0;
            while (x < classes.length) {
                x2.freq[x] = x2.freq[x] + x3.freq[x];
                if (x2.freq[x] > x2.maxfreq) {
                    x2.label = 1 << x;
                    x2.maxfreq = x2.freq[x];
                } else if (x2.freq[x] == x2.maxfreq) {
                    x2.label += (long)(1 << x);
                }
                ++x;
            }
            x2.count += x3.count;
            x2.UBound = x3.UBound;
            cutPoint.remove(minID + 1);
        } while (cutPoint.size() > 2);
        this.doPrint(7, "\nNew intervals:");
        i = 0;
        while (i < cutPoint.size()) {
            this.doPrint(7, ((myData)cutPoint.get(i)).Text());
            ++i;
        }
        double[] cp = new double[cutPoint.size() - 1];
        i = 0;
        while (i < cutPoint.size() - 1) {
            cp[i] = ((myData)cutPoint.get((int)i)).UBound;
            ++i;
        }
        return cp;
    }

    public class myData {
        public double value;
        public double LBound;
        public double UBound;
        public long label;
        public long maxfreq;
        public long[] freq = new long[64];
        public long count;

        public String Text() {
            return "(" + this.LBound + ", " + this.UBound + ") - " + this.count + " elements";
        }
    }
}

