/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.uep;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Value;
import java.util.ArrayList;
import java.util.StringTokenizer;
import miningmart.compiler.operator.uep.Discretization;

public class EquifrequentDiscretizationGivenNoOfIntervals
extends Discretization {
    public Value getNoOfIntervals() {
        return (Value)this.getSingleParameter("NoOfIntervals", this.getCurrentLoopNumber());
    }

    public Value getClosedTo() {
        return (Value)this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
    }

    public Value[] getLabels() {
        return (Value[])this.getParameter("Labels", this.getCurrentLoopNumber());
    }

    public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError {
        ArrayList<Double> cutPoints = new ArrayList<Double>();
        Value[] elements = this.getM4Db().getCountOfElements(theTargetAttributeColumn);
        long[] cnt = new long[elements.length + 1];
        double[] val = new double[elements.length + 1];
        long sum = 0L;
        int i = 0;
        while (i < elements.length) {
            StringTokenizer t = new StringTokenizer(elements[i].getValue(), ",");
            cnt[i] = Long.parseLong(t.nextToken());
            val[i] = Double.parseDouble(t.nextToken());
            sum += cnt[i];
            ++i;
        }
        cnt[elements.length] = 0L;
        val[elements.length] = val[elements.length - 1] + 0.05;
        long IntCardA = Math.round((double)sum / Double.parseDouble(this.getNoOfIntervals().getValue()));
        i = 0;
        long MaxDiff = 0L;
        this.doPrint(7, "EquifrequentDiscretizationGivenNoOfIntervals:");
        while (i < val.length) {
            long count = 0L;
            while (count <= IntCardA && i < val.length) {
                count += cnt[i];
                ++i;
            }
            if (count - IntCardA > IntCardA - (count - cnt[--i])) {
                if (MaxDiff < IntCardA - (count - cnt[i])) {
                    MaxDiff = IntCardA - (count - cnt[i]);
                }
                if ((count -= cnt[i]) == 0L && MaxDiff < (count = cnt[i++]) - IntCardA) {
                    MaxDiff = count - IntCardA;
                }
            } else {
                if (MaxDiff < count - IntCardA) {
                    MaxDiff = count - IntCardA;
                }
                ++i;
            }
            if (i == val.length) {
                cutPoints.add(new Double(val[i - 1] + (val[i - 1] - val[0]) * 0.001));
            } else {
                cutPoints.add(new Double((val[i - 1] + val[i]) / 2.0));
            }
            this.doPrint(7, "Interval no. " + cutPoints.size() + ",  Cardinality " + count);
        }
        double[] cp = new double[cutPoints.size() - 1];
        i = 0;
        while (i < cutPoints.size() - 1) {
            cp[i] = (Double)cutPoints.get(i);
            ++i;
        }
        return cp;
    }

    public String[] generateLabels(int num) {
        Value[] l = this.getLabels();
        String[] labels = new String[num];
        boolean gen = true;
        if (l.length != 0) {
            if (l.length > 0 && l.length != num) {
                this.doPrint(7, "Incorrect number of given labels, labels generated automaticaly!");
            } else {
                gen = false;
            }
        }
        int i = 0;
        while (i < num) {
            labels[i] = gen ? "_" + (i + 1) : l[i].getValue();
            ++i;
        }
        return labels;
    }
}

