/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.uep;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Value;
import miningmart.compiler.operator.uep.Discretization;

public class EquidistantDiscretizationGivenWidth
extends Discretization {
    public Value[] getStartPoint() {
        return (Value[])this.getParameter("StartPoint", this.getCurrentLoopNumber());
    }

    public Value[] getEndPoint() {
        return (Value[])this.getParameter("EndPoint", this.getCurrentLoopNumber());
    }

    public Value getIntervalWidth() {
        return (Value)this.getSingleParameter("IntervalWidth", this.getCurrentLoopNumber());
    }

    public Value getClosedTo() {
        return (Value)this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
    }

    public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError {
        this.doPrint(7, "EquidistantDiscretizationGivenWidth:");
        double start = this.getStartPointOrMinum(theTargetAttributeColumn);
        double width = Double.parseDouble(this.getIntervalWidth().getValue());
        double end = this.getEndPointOrMaximum(theTargetAttributeColumn);
        int numOfIntervals = (int)Math.ceil((end - start) / width);
        double[] cutPoints = new double[numOfIntervals];
        int i = 0;
        while (i < numOfIntervals) {
            cutPoints[i] = start + (double)i * width;
            ++i;
        }
        return cutPoints;
    }

    public double getStartPointOrMinum(Column theTargetAttributeColumn) throws M4CompilerError {
        Value[] myVal = this.getStartPoint();
        if (myVal.length == 0) {
            try {
                String min = theTargetAttributeColumn.readOrComputeMinimum();
                return Double.parseDouble(min);
            }
            catch (M4Exception e) {
                throw new M4CompilerError(e.getMessage());
            }
        }
        return Double.parseDouble(myVal[0].getValue());
    }

    public double getEndPointOrMaximum(Column theTargetAttributeColumn) throws M4CompilerError {
        Value[] myVal = this.getEndPoint();
        if (myVal.length == 0) {
            try {
                String max = theTargetAttributeColumn.readOrComputeMaximum();
                return Double.parseDouble(max);
            }
            catch (M4Exception e) {
                throw new M4CompilerError(e.getMessage());
            }
        }
        return Double.parseDouble(myVal[0].getValue());
    }
}

