/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.uep;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Value;
import miningmart.compiler.operator.FeatureConstruction;

public abstract class Discretization
extends FeatureConstruction {
    abstract Value getClosedTo();

    abstract double[] generateCutPoints(Column var1) throws M4CompilerError;

    public String[] generateLabels(int num) {
        String[] labels = new String[num];
        int i = 0;
        while (i < num) {
            labels[i] = "_" + (i + 1);
            ++i;
        }
        return labels;
    }

    public String generateSQL(Column theTargetAttributeColumn) throws M4CompilerError {
        boolean closedToRight = false;
        if (this.getClosedTo().getValue().equalsIgnoreCase("right")) {
            closedToRight = true;
        }
        double[] myCP = this.generateCutPoints(theTargetAttributeColumn);
        String[] myL = this.generateLabels(myCP.length + 1);
        String f = "(CASE ";
        int i = 0;
        while (i < myCP.length) {
            f = String.valueOf(f) + "WHEN " + theTargetAttributeColumn.getSQLPlusLocation() + " <";
            if (closedToRight) {
                f = String.valueOf(f) + "=";
            }
            f = String.valueOf(f) + " " + myCP[i] + " THEN ('" + myL[i] + "') ";
            String s = String.valueOf(myCP[i]) + "<";
            if (closedToRight) {
                s = String.valueOf(s) + "=";
            }
            s = String.valueOf(s) + "'" + myL[i] + "'\n";
            ++i;
        }
        f = String.valueOf(f) + "ELSE ('" + myL[myL.length - 1] + "') END)";
        this.doPrint(7, "String returned by discretization: " + f);
        return f;
    }
}

