/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.dista;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Value;
import miningmart.compiler.operator.dista.DistaFeatureSelection;
import miningmart.compiler.operator.dista.FS;
import miningmart.compiler.operator.dista.StatisticalFS;

public class StatisticalFeatureSelection
extends DistaFeatureSelection {
    private StatisticalFS myStatisticalFSWrapper;

    protected void initialiseWrapper() throws M4CompilerError {
        try {
            this.myStatisticalFSWrapper = new StatisticalFS(this.getM4Db(), this.getStep(), this);
        }
        catch (Exception e) {
            throw new M4CompilerError("Error while constructing  StatisticalFS Wrapper: " + e.getMessage());
        }
    }

    protected FS getWrapper() throws M4CompilerError {
        return this.myStatisticalFSWrapper;
    }

    protected void callWrapper(BaseAttribute[] featuresToSelectFrom) throws M4CompilerError {
        try {
            this.myStatisticalFSWrapper.call(this.getInputConcept(), featuresToSelectFrom, null, this.sampleSize);
        }
        catch (Exception e) {
            throw new M4CompilerError("Error excecuting StatisticalFS Wrapper: " + e.getMessage());
        }
    }

    protected void loadParameters() throws M4CompilerError {
        this.myStatisticalFSWrapper.m_threshold = this.getThreshold();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double getThreshold() throws M4CompilerError {
        String errMsg = String.valueOf(this.getName()) + ": Parameter 'Threshold' must be specified, and must be a real number!";
        Value v = (Value)this.getSingleParameter("Threshold");
        if (v == null) throw new M4CompilerError(errMsg);
        String s = v.getValue();
        if (s == null) throw new M4CompilerError(errMsg);
        try {
            void var2_4;
            double threshold = Double.parseDouble(s);
            return (double)var2_4;
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError(errMsg);
        }
    }
}

