/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.dista;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Value;
import java.sql.SQLException;
import miningmart.compiler.operator.Segmentation;
import miningmart.compiler.operator.dista.KMean;

public final class SegmentationWithKMean
extends Segmentation {
    private static final String MULTISTEPBRANCH_ATTRIBUTE = "(KMeansPartition)";
    private Value howManyPartitions;
    protected Value optimize;
    protected Value sampleSize;
    protected BaseAttribute[] thePredictingAttributes;
    protected int m_cluster_num;
    protected KMean m_kmean;

    public String generateConditionForOp(int columnSetIndex) throws M4CompilerError {
        String fctCall = this.m_kmean.getNameFunctionCall();
        String sqlCondition = String.valueOf(fctCall) + " = " + columnSetIndex;
        return sqlCondition;
    }

    private void callStatement() throws M4CompilerError {
        boolean opt;
        long sample;
        this.loadParameters();
        this.m_kmean = null;
        try {
            this.m_kmean = new KMean(this.getM4Db(), this.getStep(), this);
        }
        catch (InterruptedException e) {
            throw new M4CompilerError("Error while constructing KMean Wrapper : " + e.getMessage());
        }
        catch (Exception e) {
            throw new M4CompilerError("Error while constructing KMean Wrapper : " + e.getMessage());
        }
        try {
            sample = Long.parseLong(this.sampleSize.getValue());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("KMean: SampleSize must  be an integer!");
        }
        try {
            this.m_cluster_num = Integer.parseInt(this.howManyPartitions.getValue());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("SegmentationWithKMean: Parameter 'HowManyPartitions' must  be an integer!");
        }
        try {
            opt = Boolean.valueOf(this.optimize.getValue());
        }
        catch (Exception nfe) {
            throw new M4CompilerError("SegmentationWithKMean: Parameter 'OptimizePartitionNum' must  be a boolean!");
        }
        try {
            this.m_kmean.setOptimizeClusterNum(opt);
            this.m_kmean.call(this.getInputConcept(), this.thePredictingAttributes, sample, this.m_cluster_num);
            this.m_cluster_num = this.m_kmean.getClusterNum();
        }
        catch (Exception e) {
            throw new M4CompilerError("KMean-Wrapper: " + e);
        }
        try {
            this.getM4Db().commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("KMean-Wrapper: could not commit DB updates: " + sqle.getMessage());
        }
        try {
            Columnset theColumnSet = this.getInputConcept().getCurrentColumnSet();
            String fctSchema = theColumnSet.getSchema();
            this.getM4Db().addFunctionToTrash(this.m_kmean.getNameFunction(), fctSchema, this.getStep().getId());
        }
        catch (Exception e) {
            throw new M4CompilerError("Error adding function to Trash : " + e);
        }
    }

    private void loadParameters() throws M4CompilerError {
        this.howManyPartitions = (Value)this.getSingleParameter("HowManyPartitions");
        this.sampleSize = (Value)this.getSingleParameter("SampleSize");
        this.thePredictingAttributes = (BaseAttribute[])this.getParameter("ThePredictingAttributes");
        this.optimize = (Value)this.getSingleParameter("OptimizePartitionsNum");
    }

    public Value getHowManyPartitions() {
        return this.howManyPartitions;
    }

    public int numberOfSegments() throws M4CompilerError {
        this.callStatement();
        return this.m_cluster_num;
    }

    public void setCSSegmentInfo(String inputMultiStepBranch, Columnset cs, int index) throws M4CompilerError {
        try {
            cs.addMultiStepBranchInfo(inputMultiStepBranch, MULTISTEPBRANCH_ATTRIBUTE, Integer.toString(index));
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }
}

