/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.dista;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Value;
import java.sql.SQLException;
import miningmart.compiler.operator.MissingValues;
import miningmart.compiler.operator.dista.DistaTool;

public abstract class DecisionOperator
extends MissingValues {
    protected static long defaultSampleSize = 10000L;
    protected static long defaultPruningConfidence = 50L;
    protected DistaTool myDecisionOperator;

    public String generateValueForOp(Column theTargetAttributeColumn) throws M4CompilerError {
        this.callStatement(theTargetAttributeColumn);
        return this.myDecisionOperator.getNameFunctionCall();
    }

    protected abstract DistaTool prepareLearner() throws M4CompilerError;

    protected void callStatement(Column columnToFill) throws M4CompilerError {
        this.myDecisionOperator = this.prepareLearner();
        int l = this.getCurrentLoopNumber();
        long sample = this.getSampleSize(l);
        double prunconf = this.getPruningConfidence(l);
        try {
            this.myDecisionOperator.setPruningConfidence(prunconf);
            this.myDecisionOperator.call(this.getTheInputConcept(), this.getThePredictingAttributes(l), columnToFill, sample);
            this.getM4Db().commitM4Transactions();
            Columnset theColumnSet = this.getTheInputConcept().getCurrentColumnSet();
            String fctSchema = theColumnSet.getSchema();
            this.getM4Db().addFunctionToTrash(this.myDecisionOperator.getNameFunction(), fctSchema, this.getStep().getId());
        }
        catch (SQLException e) {
            throw new M4CompilerError(String.valueOf(this.getName()) + ": Error committing M4 transactions or inserting decision function: " + e.getMessage());
        }
        catch (Exception e) {
            throw new M4CompilerError(String.valueOf(this.getName()) + ": Error executing decision tree: " + e.getMessage());
        }
    }

    private long getSampleSize(int loopNr) throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("SampleSize", loopNr);
        String s = v.getValue();
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException nfe) {
                throw new M4CompilerError(String.valueOf(this.getName()) + ": SampleSize must be an integer!");
            }
        }
        return defaultSampleSize;
    }

    private double getPruningConfidence(int loopNr) throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("PruningConf", loopNr);
        String s = v.getValue();
        if (s != null) {
            double pc = -1.0;
            try {
                pc = Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                throw new M4CompilerError(String.valueOf(this.getName()) + ": PruningConf must be real and between 0 and 100!");
            }
            if (pc < 0.0 || pc > 100.0) {
                this.doPrint(7, String.valueOf(this.getName()) + ": WARNING: PruningConf must be real and between 0 and 100; using default: " + defaultPruningConfidence);
            }
            return pc;
        }
        return defaultPruningConfidence;
    }

    public BaseAttribute[] getThePredictingAttributes(int loopNr) {
        return (BaseAttribute[])this.getParameter("ThePredictingAttributes", loopNr);
    }
}

