/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Value;
import java.sql.SQLException;
import miningmart.compiler.operator.SingleCSOperator;
import miningmart.storedProcedures.TimeOperatorException;

public abstract class TimeOperator
extends SingleCSOperator {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected abstract String getColumnSetSuffix();

    protected abstract void runStoredProcedure(String var1) throws SQLException, M4CompilerError, TimeOperatorException;

    protected abstract void createJavaColumns(Columnset var1) throws SQLException, M4CompilerError;

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        return null;
    }

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return false;
    }

    protected Columnset createSingleColumnSet(int index) throws M4CompilerError {
        try {
            String columnSetName = this.getNewCSName();
            try {
                this.runStoredProcedure(String.valueOf(this.getInputConcept().getCurrentColumnSet().getSchema()) + "." + columnSetName);
            }
            catch (TimeOperatorException e) {
                throw new M4CompilerError("Exception in stored procedure caught:\n" + e.getMessage());
            }
            Columnset newCS = this.createJavaColumnset(columnSetName);
            this.createJavaColumns(newCS);
            long step = this.getStep().getId();
            String schema = this.getInputConcept().getCurrentColumnSet().getSchema();
            this.getM4Db().addTableToTrash(columnSetName, schema, step);
            return newCS;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("TimeOperator: SQL error: " + sqle.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private Columnset createJavaColumnset(String columnSetName) throws M4CompilerError {
        try {
            CompilerDatabaseService compilerDatabaseService = this.getM4Db();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Columnset newCS = (Columnset)compilerDatabaseService.createNewInstance(clazz);
            newCS.setId(0L);
            newCS.setName(columnSetName);
            Columnset inputColumnSet = this.getInputConcept().getCurrentColumnSet();
            newCS.setSchema(inputColumnSet.getSchema());
            newCS.setType(this.getTypeOfNewColumnSet());
            newCS.setSQLDefinition(columnSetName);
            newCS.setTheConcept(this.getOutputConcept());
            newCS.setMultiStepBranch(inputColumnSet.getMultiStepBranch());
            this.getStep().addToTrash(newCS);
            return newCS;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected Column createM4Column(BaseAttribute outputBA, Columnset newCS, Column columnForType) throws M4CompilerError {
        try {
            String newColumnName = outputBA.getName();
            CompilerDatabaseService compilerDatabaseService = this.getM4Db();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.udo.miningmart.m4.core.Column");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Column newColumn = (Column)compilerDatabaseService.createNewInstance(clazz);
            newColumn.setId(0L);
            newColumn.setName(newColumnName);
            newColumn.setColumnset(newCS);
            newColumn.setBaseAttribute(outputBA);
            newColumn.setColumnDataType(columnForType.getColumnDataType());
            newColumn.setColumnDataTypeName(columnForType.getColumnDataTypeName());
            newColumn.setSQLDefinition(newColumnName);
            this.getStep().addToTrash(newColumn);
            return newColumn;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected void executeDbProcedure(String procedureName, String[] parameters) throws SQLException, M4CompilerError {
        if (parameters != null) {
            String[] p = new String[parameters.length + 1];
            int i = 0;
            while (i < parameters.length) {
                p[i + 1] = parameters[i];
                ++i;
            }
            p[0] = "NULL";
            parameters = p;
        }
        this.getM4Db().executeDBProcedure(procedureName, parameters, true);
    }

    protected static String getQuotedColNameforInpBA(BaseAttribute ba) throws M4CompilerError {
        try {
            return DB.quote(ba.getColumn(0).getName().toUpperCase());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in TimeOperator: " + m4e.getMessage());
        }
    }

    protected static String getQuotedColNameforOutBA(BaseAttribute ba) throws M4CompilerError {
        return DB.quote(ba.getName());
    }

    protected static String getQuotedColSetNameforCon(Concept c) throws M4CompilerError {
        try {
            Columnset cs = c.getCurrentColumnSet();
            return DB.quote(String.valueOf(cs.getSchema().toUpperCase()) + "." + cs.getName().toUpperCase());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in TimeOperator: " + m4e.getMessage());
        }
    }

    protected static String getUnquotedIntFromValue(Value v) {
        return v.getValue().trim();
    }

    protected static String unquote(String s) {
        return s.substring(1, s.length() - 1).trim();
    }

    protected void valueIsLong(Value v, String name) throws M4CompilerError {
        if (v == null || !v.isLong()) {
            this.createParameterException(name);
        }
    }

    protected void valueIsDouble(Value v, String name) throws M4CompilerError {
        if (v == null || !v.isDouble()) {
            this.createParameterException(name);
        }
    }

    protected void baseattribHasColumns(BaseAttribute b, String name) throws M4CompilerError {
        try {
            if (b == null || !b.hasColumns()) {
                this.createParameterException(name);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void createParameterException(String name) throws M4CompilerError {
        throw new M4CompilerError("Parameter '" + name + "' of step " + this.getStep().getId() + " of wrong data type (or BA without column)!");
    }
}

