/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.MultiColumnFeature;
import edu.udo.miningmart.m4.core.Value;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import miningmart.compiler.operator.SingleCSOperator;

public class SpecifiedStatistics
extends SingleCSOperator {
    private static final String SUM_SUFFIX = "_SUM";
    private static final String COUNT_SUFFIX = "_COUNT";
    private static final String UNIQUE_SUFFIX = "_UNIQUE";
    private static final String MIN_SUFFIX = "_MIN";
    private static final String MAX_SUFFIX = "_MAX";
    private final Vector columnNames = new Vector();
    private final Vector sqlDefs = new Vector();

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        try {
            String columnExpr = "";
            Feature inF = null;
            int iIn = 0;
            Feature outF = null;
            Iterator it = this.getOutputConcept().getFeatures().iterator();
            while (it.hasNext()) {
                Column outputColumn;
                Column inputColumn;
                BaseAttribute outBA;
                BaseAttribute inBA;
                outF = (Feature)it.next();
                if (!this.mustCopyFeature(outF.getName())) continue;
                iIn = 0;
                do {
                    inF = this.getInputConcept().getFeature(iIn);
                } while (++iIn < this.getInputConcept().getNumberOfFeatures() && !this.correspondsTo(outF, inF));
                if (!this.correspondsTo(outF, inF)) {
                    this.doPrint(7, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because no corresponding input feature was found.");
                    continue;
                }
                if (this.isDeselectedParameter(inF)) {
                    this.doPrint(5, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because the corresponding input feature was deselected by " + "a FeatureSelection operator.");
                    continue;
                }
                if (outF instanceof BaseAttribute) {
                    inBA = (BaseAttribute)inF;
                    outBA = (BaseAttribute)outF;
                    inputColumn = inBA.getCurrentColumn();
                    outputColumn = inputColumn.copyColTo(csForOutputConcept);
                    this.getStep().addToTrash(outputColumn);
                    outputColumn.setBaseAttribute(outBA);
                    outputColumn.setSQLDefinition(outBA.getName());
                    outputColumn.setName(outBA.getName());
                    continue;
                }
                if (!(outF instanceof MultiColumnFeature)) {
                    throw new M4CompilerError("Unknown Feature type found in Concept with id: " + this.getOutputConcept().getId() + "; Feature id: " + outF.getId());
                }
                MultiColumnFeature outMCF = (MultiColumnFeature)outF;
                MultiColumnFeature inMCF = (MultiColumnFeature)inF;
                Iterator theBAs = outMCF.getBaseAttributes().iterator();
                if (theBAs == null) continue;
                try {
                    while (theBAs.hasNext()) {
                        outBA = (BaseAttribute)theBAs.next();
                        inBA = inMCF.getBaseAttributeByName(outBA.getName());
                        inputColumn = inBA.getCurrentColumn();
                        outputColumn = inputColumn.copyColTo(csForOutputConcept);
                        outputColumn.setBaseAttribute(outBA);
                        outputColumn.setSQLDefinition(outBA.getName());
                        outputColumn.setName(outBA.getName());
                    }
                }
                catch (NullPointerException nfe) {
                    throw new M4CompilerError("ConceptOperator: Mismatch between MultiColumnFeatures in in- and output concept!");
                }
                catch (ArrayIndexOutOfBoundsException aie) {
                    throw new M4CompilerError("ConceptOperator: Mismatch between MultiColumnFeatures in in- and output concept!");
                }
            }
            return columnExpr;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private boolean correspondsTo(Feature out, Feature in) {
        if (out == null) {
            return false;
        }
        String outName = out.getName().toUpperCase();
        String inName = in.getName().toUpperCase();
        if (outName.endsWith(SUM_SUFFIX)) {
            outName = outName.substring(0, outName.length() - SUM_SUFFIX.length());
        }
        if (outName.endsWith(COUNT_SUFFIX)) {
            outName = outName.substring(0, outName.length() - COUNT_SUFFIX.length());
        }
        if (outName.endsWith(UNIQUE_SUFFIX)) {
            outName = outName.substring(0, outName.length() - UNIQUE_SUFFIX.length());
        }
        if (outName.endsWith(MIN_SUFFIX)) {
            outName = outName.substring(0, outName.length() - MIN_SUFFIX.length());
        }
        if (outName.endsWith(MAX_SUFFIX)) {
            outName = outName.substring(0, outName.length() - MAX_SUFFIX.length());
        }
        Value[] theDistribValues = (Value[])this.getParameter("DistribValues");
        int i = 0;
        while (i < theDistribValues.length) {
            String[] vals = this.getSingleValues(theDistribValues[i]);
            int j = 0;
            while (j < vals.length) {
                if (outName.endsWith("_" + vals[j])) {
                    outName = outName.substring(0, outName.length() - vals[j].length() - 1);
                }
                ++j;
            }
            ++i;
        }
        return out.getClass() == in.getClass() && outName.equalsIgnoreCase(inName);
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        this.doPrint(7, "Operator SpecifiedStatistics is computing...");
        String groupBy = this.getGroupByExpr();
        this.getStatisticsSQLFor("AttributesComputeSum", "SUM(", SUM_SUFFIX);
        this.getStatisticsSQLFor("AttributesComputeCount", "COUNT(", COUNT_SUFFIX);
        this.getStatisticsSQLFor("AttributesComputeUnique", "COUNT(DISTINCT ", UNIQUE_SUFFIX);
        this.getStatisticsSQLFor("AttributesComputeMin", "MIN(", MIN_SUFFIX);
        this.getStatisticsSQLFor("AttributesComputeMax", "MAX(", MAX_SUFFIX);
        String tableName = this.getNewCSName();
        StringBuffer query = new StringBuffer("INSERT INTO " + tableName + " ( ");
        Iterator it = ((AbstractList)this.columnNames).iterator();
        while (it.hasNext()) {
            query.append((String)it.next());
            if (it.hasNext()) {
                query.append(", ");
                continue;
            }
            query.append(" ) ( SELECT ");
        }
        it = ((AbstractList)this.sqlDefs).iterator();
        while (it.hasNext()) {
            Columnset inCs;
            String sqlDef = (String)it.next();
            query.append("(" + sqlDef + ")");
            if (it.hasNext()) {
                query.append(", ");
                continue;
            }
            try {
                inCs = this.getInputConcept().getCurrentColumnSet();
            }
            catch (M4Exception e) {
                throw new M4CompilerError("Specified Statistics: Could not get current Columnset of Concept '" + this.getInputConcept().getName() + "'!");
            }
            String inSqlFrom = " FROM " + inCs.getSchemaPlusName();
            query.append(String.valueOf(inSqlFrom) + groupBy + " )");
        }
        String inserts = query.toString();
        String dvals = this.computeDistributions();
        this.createTable(tableName);
        try {
            this.executeBusinessSqlWrite(inserts);
        }
        catch (SQLException e) {
            throw new M4CompilerError("SQLException for M4 write statement: " + inserts);
        }
        if (dvals != null) {
            String insert = "UPDATE " + tableName + " SET " + dvals;
            try {
                this.getM4Db().executeBusinessSqlWrite(insert);
            }
            catch (SQLException e) {
                throw new M4CompilerError("SQLException for business data write statement: " + insert);
            }
        }
        this.doPrint(7, "Operator SpecifiedStatistics has finished.");
        return this.getNewCSName();
    }

    private String getGroupByExpr() throws M4CompilerError {
        BaseAttribute[] theBAs = (BaseAttribute[])this.getParameter("GroupBy");
        StringBuffer buf = new StringBuffer();
        if (theBAs != null && theBAs.length >= 0) {
            int i = 0;
            while (i < theBAs.length) {
                BaseAttribute curBa = theBAs[i];
                if (curBa != null) {
                    String name = curBa.getName();
                    String sql = this.getColumnSQLForBaseAttribute(curBa);
                    buf.append(String.valueOf(sql) + ", ");
                    this.addColumnToTable(name);
                    this.sqlDefs.add(sql);
                }
                ++i;
            }
        }
        if (buf.length() > 2) {
            return " GROUP BY " + buf.substring(0, buf.length() - 2);
        }
        return "";
    }

    private void getStatisticsSQLFor(String m4ParameterName, String operator, String attributeSuffix) throws M4CompilerError {
        BaseAttribute[] theBAs = (BaseAttribute[])this.getParameter(m4ParameterName);
        if (theBAs == null) {
            return;
        }
        int i = 0;
        while (i < theBAs.length) {
            BaseAttribute curBa = theBAs[i];
            if (curBa != null) {
                String name = String.valueOf(curBa.getName()) + attributeSuffix;
                String sql = String.valueOf(operator) + this.getColumnSQLForBaseAttribute(curBa) + ")";
                this.addColumnToTable(name);
                this.sqlDefs.add(sql);
            }
            ++i;
        }
    }

    private String computeDistributions() throws M4CompilerError {
        BaseAttribute[] theBAs = (BaseAttribute[])this.getParameter("AttributesComputeDistrib");
        Value[] theDistribValues = (Value[])this.getParameter("DistribValues");
        if (theBAs != null && theBAs.length > 0 && theDistribValues == null || theBAs != null && theDistribValues != null && theBAs.length != theDistribValues.length) {
            throw new M4CompilerError("Operator SpecifiedStatistics: expected as many parameters 'DistribValues' as 'AttributesComputeDistrib'!");
        }
        if (theBAs != null) {
            StringBuffer distrib = new StringBuffer();
            int i = 0;
            while (i < theBAs.length) {
                String[] vals = this.getSingleValues(theDistribValues[i]);
                int j = 0;
                while (j < vals.length) {
                    String count = this.computeDistCount(theBAs[i], vals[j]);
                    String name = String.valueOf(theBAs[i].getName()) + "_" + vals[j];
                    this.addColumnToTable(name);
                    distrib.append(String.valueOf(name) + "=" + count + ", ");
                    ++j;
                }
                if (distrib.length() > 2) {
                    return distrib.substring(0, distrib.length() - 2);
                }
                ++i;
            }
        }
        return null;
    }

    private Column getColumnForBaseAttribute(BaseAttribute ba) throws M4CompilerError {
        Column column;
        try {
            column = ba.getCurrentColumn();
        }
        catch (M4Exception e) {
            throw new M4CompilerError("SpecifiedStatistics: Exception when trying to get current column for BaseAttribute '" + ba.getName() + "'!");
        }
        return column;
    }

    /*
     * WARNING - void declaration
     */
    private String getColumnSQLForBaseAttribute(BaseAttribute ba) throws M4CompilerError {
        void var3_3;
        String sql;
        Column column = this.getColumnForBaseAttribute(ba);
        if (column == null || (sql = column.getSQLDefinition()) == null) {
            throw new M4CompilerError("SpecifiedStatistics: Found <null> Column for BaseAttribute that is NOT deselected!\nBaseAttribute name is " + column.getName());
        }
        return var3_3;
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return true;
    }

    private void addColumnToTable(String columnName) throws M4CompilerError {
        if (columnName == null) {
            return;
        }
        try {
            Concept outC = this.getOutputConcept();
            Iterator it = outC.getFeatures().iterator();
            boolean found = false;
            while (it.hasNext()) {
                if (!((Feature)it.next()).getName().equalsIgnoreCase(columnName)) continue;
                found = true;
            }
            if (!found) {
                throw new M4CompilerError("Operator SpecifiedStatistics: TheOutputConcept must contain a BaseAttribute named '" + columnName + "'!");
            }
            this.columnNames.add(columnName);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void createTable(String tableName) throws M4CompilerError {
        try {
            this.getM4Db().dropBusinessTable(tableName);
            String numericDatatype = this.getM4Db().getNameOfNumericDatatype();
            String create = "create table " + tableName + " (";
            int i = 0;
            while (i < this.columnNames.size()) {
                create = String.valueOf(create) + (String)this.columnNames.get(i) + " " + numericDatatype + ", ";
                ++i;
            }
            create = String.valueOf(create.substring(0, create.length() - 2)) + ")";
            this.getM4Db().executeBusinessSqlWrite(create);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator SpecifiedStatistics: could not create table with the computed values, SQL error: " + sqle.getMessage());
        }
        try {
            this.getM4Db().addTableToTrash(tableName, this.getInputConcept().getCurrentColumnSet().getSchema(), this.getStep().getId());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private String[] getSingleValues(Value v) {
        String s = v.getValue();
        StringTokenizer st = new StringTokenizer(s, ", ");
        String[] ret = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            ret[i] = st.nextToken();
            ++i;
        }
        return ret;
    }

    private String computeDistCount(BaseAttribute distBA, String value) throws M4CompilerError {
        String d = null;
        Column c = this.getColumnForBaseAttribute(distBA);
        d = this.getM4Db().computeNumberOfElementsForValue(c, value);
        if (d == null) {
            this.doPrint(7, "Warning: Operator SpecifiedStatistics: output table contains NULL values!");
        }
        return d;
    }
}

