/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Value;
import java.util.Collection;
import java.util.Iterator;
import miningmart.compiler.operator.Segmentation;
import miningmart.compiler.utils.RandomPartition;

public final class SegmentationByPartitioning
extends Segmentation {
    private static final String MULTISTEPBRANCH_ATTRIBUTE = "(Random)";

    public String generateSQLDefinition(String selectPart, int index) throws M4CompilerError {
        Columnset cs;
        int howMany = new Integer(this.getHowManyPartitions().getValue());
        try {
            cs = this.getInputConcept().getCurrentColumnSet();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        String tempTableName = this.getTempCsName(cs);
        if (index <= 0) {
            new RandomPartition(cs, null, new String[howMany], true, tempTableName, null, null, this.getM4Db());
            this.getM4Db().addTableToTrash(tempTableName, cs.getSchema(), this.getStep().getId());
        }
        String artCol = this.getArtificalColumnName(selectPart);
        String sqlDefs = this.getSourceAttributeDefinitions();
        String colNames = this.getSourceAttributes();
        String innerQuery = "( SELECT ROWNUM AS " + artCol + ", " + sqlDefs + " FROM " + cs.getSchemaPlusName() + " )";
        String viewDef = "(SELECT " + colNames + " FROM " + tempTableName + " T, " + innerQuery + " S" + " WHERE t.the_Segment = " + index + " AND s." + artCol + " = t.the_Id)";
        return viewDef;
    }

    public String getSourceAttributeDefinitions() throws M4CompilerError {
        try {
            Columnset cs = this.getInputConcept().getCurrentColumnSet();
            Collection columns = cs.getColumns();
            StringBuffer sb = new StringBuffer();
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column theColumn = (Column)it.next();
                String sql = theColumn.getSQLDefinition();
                String name = theColumn.getName();
                if (sql == null || sql.equals(name)) {
                    sb.append(name);
                } else {
                    sb.append("(" + sql + ") AS " + name);
                }
                sb.append(", ");
            }
            int le = sb.length();
            if (le >= 2) {
                sb.delete(le - 2, le);
            }
            return sb.toString();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public String getSourceAttributes() throws M4CompilerError {
        try {
            Columnset cs = this.getInputConcept().getCurrentColumnSet();
            Collection columns = cs.getColumns();
            StringBuffer sb = new StringBuffer();
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                String colName = ((Column)it.next()).getName().toUpperCase();
                sb.append(String.valueOf(colName) + ", ");
            }
            int le = sb.length();
            if (le >= 2) {
                sb.delete(le - 2, le);
            }
            return sb.toString();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    String getTempCsName(Columnset inputCs) {
        return "T_" + this.getStep().getId() + "_" + inputCs.getId();
    }

    public String getTypeOfNewColumnSet(int index) {
        return "V";
    }

    public String generateConditionForOp(int columnSetIndex) throws M4CompilerError {
        return null;
    }

    public Value getHowManyPartitions() {
        return (Value)this.getSingleParameter("HowManyPartitions");
    }

    public int numberOfSegments() throws M4CompilerError {
        try {
            return Integer.parseInt(this.getHowManyPartitions().getValue());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("SegmentationByPartitioning: Parameter 'HowManyPartitions' must be an integer!");
        }
    }

    public void setCSSegmentInfo(String inputMultiStepBranch, Columnset cs, int index) throws M4CompilerError {
        try {
            cs.addMultiStepBranchInfo(inputMultiStepBranch, MULTISTEPBRANCH_ATTRIBUTE, Integer.toString(index));
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }
}

