/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Value;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import miningmart.compiler.operator.RowSelection;

public class RowSelectionByUnbiasing
extends RowSelection {
    private static final String ROW_ID = "ID";
    private static final String PREDICTED_LABEL = "PL";
    private static final String CORRECT_LABEL = "LA";
    private int numRowsInputCs;
    private String sqlQuery;
    private final HashMap nominalsToIntMappingPredictions = new HashMap();
    private final HashMap nominalsToIntMappingLabel = new HashMap();
    private int remainingTupels;
    private int[][] remainingTupelsByPL;
    private final Random random = new Random();

    private static int getIdForNomToInt(HashMap hm, String prediction) {
        Integer index = (Integer)hm.get(prediction);
        if (index == null) {
            index = new Integer(hm.size());
            hm.put(prediction, index);
        }
        return index;
    }

    private int getIdForPrediction(String prediction) {
        return RowSelectionByUnbiasing.getIdForNomToInt(this.nominalsToIntMappingPredictions, prediction);
    }

    private int getIdForLabel(String label) {
        return RowSelectionByUnbiasing.getIdForNomToInt(this.nominalsToIntMappingLabel, label);
    }

    private boolean decreaseIfTupleUseful(int predicted, int label) {
        boolean useful;
        boolean bl = useful = this.remainingTupelsByPL[predicted][label] > 0;
        if (useful) {
            int[] nArray = this.remainingTupelsByPL[predicted];
            int n = label;
            nArray[n] = nArray[n] - 1;
            --this.remainingTupels;
        }
        return useful;
    }

    private String getTmpTableName() {
        return "tmp_" + this.getStep().getId();
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        try {
            String viewDef = "(select " + selectPart + " from (" + this.getInputConcept().getCurrentColumnSet().getCompleteSQLQuery(ROW_ID) + ") AS T1, (SELECT " + ROW_ID + " FROM " + this.getTmpTableName() + ") AS T2" + " where T1." + ROW_ID + "=T2." + ROW_ID + ")";
            this.selectRowsForResult();
            return viewDef;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected void initByMasterBlock() throws M4CompilerError, SQLException {
        this.remainingTupels = Math.min(this.getHowMany(), this.numRowsInputCs);
        Vector<Integer> predPriors = new Vector<Integer>();
        Vector<Integer> labelPriors = new Vector<Integer>();
        int i = 0;
        while (i < this.remainingTupels) {
            int rowId = this.random.nextInt(this.numRowsInputCs);
            int[] predLabel = this.getTuple(rowId);
            int prediction = predLabel[0];
            int label = predLabel[1];
            while (predPriors.size() < prediction + 1) {
                predPriors.add(new Integer(0));
            }
            int current = (Integer)predPriors.get(prediction);
            predPriors.set(prediction, new Integer(current + 1));
            while (labelPriors.size() < label + 1) {
                labelPriors.add(new Integer(0));
            }
            current = (Integer)labelPriors.get(label);
            labelPriors.set(label, new Integer(current + 1));
            ++i;
        }
        double[] priors = new double[labelPriors.size()];
        int i2 = 0;
        while (i2 < priors.length) {
            priors[i2] = ((Integer)labelPriors.get(i2)).doubleValue() / (double)this.remainingTupels;
            ++i2;
        }
        int[][] countArray = new int[predPriors.size()][labelPriors.size()];
        Iterator it = ((AbstractList)predPriors).iterator();
        int row = 0;
        while (row < countArray.length) {
            int predCount = (Integer)it.next();
            int col = 0;
            while (col < priors.length) {
                countArray[row][col] = (int)(priors[col] * (double)predCount);
                ++col;
            }
            ++row;
        }
        this.remainingTupelsByPL = countArray;
    }

    protected void selectRowsForResult() throws M4CompilerError {
        try {
            Columnset inputCS = this.getInputConcept().getCurrentColumnSet();
            this.numRowsInputCs = Integer.parseInt(inputCS.readOrComputeCount());
            Column predCol = this.getPredictedLabelBA().getCurrentColumn();
            Column labelCol = this.getLabelBA().getCurrentColumn();
            this.sqlQuery = "SELECT " + predCol.getSQLDefinition() + " AS " + PREDICTED_LABEL + ", " + labelCol.getSQLDefinition() + " AS " + CORRECT_LABEL + " FROM (" + inputCS.getCompleteSQLQuery(ROW_ID) + ")";
            try {
                this.initByMasterBlock();
                String tmpTableName = this.getTmpTableName();
                String createSql = "CREATE TABLE " + tmpTableName + " ( " + ROW_ID + " NUMBER )";
                this.getM4Db().dropBusinessTable(tmpTableName);
                this.executeBusinessSqlWrite(createSql);
                this.getM4Db().addTableToTrash(tmpTableName, inputCS.getSchema(), this.getStep().getId());
                int maxIterations = this.getMaxTuplesToRead();
                if (maxIterations == 0) {
                    maxIterations = this.numRowsInputCs;
                }
                String sqlInsertPre = "INSERT INTO " + tmpTableName + " VALUES ( ";
                String sqlInsertPost = " )";
                int i = 0;
                while (i < maxIterations && this.remainingTupels > 0) {
                    int label;
                    int rowId = this.random.nextInt(this.numRowsInputCs);
                    int[] predLabel = this.getTuple(rowId);
                    int pred = predLabel[0];
                    boolean useful = this.decreaseIfTupleUseful(pred, label = predLabel[1]);
                    if (useful) {
                        String sqlInsert = String.valueOf(sqlInsertPre) + rowId + sqlInsertPost;
                        this.executeBusinessSqlWrite(sqlInsert);
                    }
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new M4CompilerError("SQLException caught:\n " + e.getMessage());
            }
            this.getM4Db().addTableToTrash(this.getNewCSName(), this.getInputConcept().getCurrentColumnSet().getSchema(), this.getStep().getId());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private int[] getTuple(int rowId) throws M4CompilerError, SQLException {
        int[] result;
        block4: {
            String sql = String.valueOf(this.sqlQuery) + " WHERE " + ROW_ID + " = " + rowId;
            ResultSet rs = null;
            result = null;
            try {
                rs = this.executeBusinessSqlRead(sql);
                if (!rs.next()) {
                    throw new M4CompilerError("RowSelectionByUnbiasing: Cannot access row id " + rowId + "!\nQuery was: " + sql);
                }
                result = new int[]{this.getIdForPrediction(rs.getString(PREDICTED_LABEL)), this.getIdForLabel(rs.getString(CORRECT_LABEL))};
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (rs != null) {
                    rs.close();
                }
                throw throwable;
            }
            Object var5_7 = null;
            if (rs == null) break block4;
            rs.close();
        }
        return result;
    }

    public String generateConditionForOp() {
        return null;
    }

    public BaseAttribute getPredictedLabelBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("PredictedLabel");
    }

    public BaseAttribute getLabelBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("Label");
    }

    public int getHowMany() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("HowMany");
        try {
            return Integer.parseInt(v.getValue());
        }
        catch (NumberFormatException e) {
            throw new M4CompilerError("Parameter 'HowMany' of Operator RowSelectionByUnbiasing does not contain an integer value: " + v.getValue());
        }
        catch (NullPointerException e) {
            throw new M4CompilerError("Parameter 'HowMany' of Operator RowSelectionByRowSelectionByUnbiasing not found!");
        }
    }

    public int getMaxTuplesToRead() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("MaxNumOfTuplesRead");
        if (v == null) {
            return 0;
        }
        try {
            return Math.max(0, Integer.parseInt(v.getValue()));
        }
        catch (NumberFormatException e) {
            throw new M4CompilerError("Parameter 'MaxNumOfTuplesRead' of Operator RowSelectionByUnbiasing does not contain an integer value: " + v.getValue());
        }
    }
}

