/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.MultiColumnFeature;
import edu.udo.miningmart.m4.core.Value;
import java.util.Collection;
import java.util.Iterator;
import miningmart.compiler.operator.SingleCSOperator;

public class PivotizeWithAggregation
extends SingleCSOperator {
    private static final String PARAMETER_GROUPBY_ATTR = "TheGroupByAttributes";
    private static final String PARAMETER_INDEX_ATTR = "TheIndexAttribute";
    private static final String PARAMETER_PIVOT_ATTR = "ThePivotAttribute";
    private static final String PARAMETER_VALUES = "IndexValue";
    private static final String PARAMETER_MAPPED_ATTR = "MappedAttribute";
    private static final String PARAMETER_AGGREGATION = "AggregationOperator";
    private static final String PARAMETER_NULLORZERO = "NullOrZero";

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        try {
            String sqlDef = "(SELECT " + selectPart + " FROM " + this.getInputConcept().getCurrentColumnSet().getSchemaPlusName() + " GROUP BY " + this.getGroupByStatement() + ")";
            return sqlDef;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator PivotizeWithAggregation: M4Exception caught when accessing input concept/its columnset: " + m4e.getMessage());
        }
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        String columnExpr = "";
        Feature[] theGroupByFeatures = (Feature[])this.getParameter(PARAMETER_GROUPBY_ATTR);
        int noOfLoops = this.getNumberOfLoops();
        BaseAttribute[] theMappedBAs = new BaseAttribute[noOfLoops];
        Value[] theIndexValues = new Value[noOfLoops];
        int i = 0;
        while (i < noOfLoops) {
            theMappedBAs[i] = (BaseAttribute)this.getSingleParameter(PARAMETER_MAPPED_ATTR, i);
            if (theMappedBAs[i] == null) {
                throw new M4CompilerError("Operator PivotizeWithAggregation: Found no entry for 'MappedAttribute' for loop number " + i + "!");
            }
            theIndexValues[i] = (Value)this.getSingleParameter(PARAMETER_VALUES, i);
            if (theIndexValues[i] == null) {
                throw new M4CompilerError("Operator PivotizeWithAggregation: Found no entry for 'IndexValue' for loop number " + i + "!");
            }
            ++i;
        }
        try {
            Collection outFeatures = this.getOutputConcept().getFeatures();
            if (outFeatures == null || outFeatures.isEmpty()) {
                throw new M4CompilerError("Operator PivotizeWithAggregation: No Features found in the output concept!");
            }
            Iterator it = outFeatures.iterator();
            while (it.hasNext()) {
                Feature outF = (Feature)it.next();
                if (outF.correspondsTo(this.getIndexBA())) {
                    throw new M4CompilerError("Operator PivotizeWithAggregation: found the Index BA in the Output Concept!");
                }
                Feature inF = this.correspondsToOneOf(outF, theGroupByFeatures);
                if (inF != null) {
                    columnExpr = this.createMetadata(inF, outF, csForOutputConcept, columnExpr);
                    continue;
                }
                if (!(outF instanceof BaseAttribute)) {
                    throw new M4CompilerError("Operator PivotizeWithAggregation: Feature '" + outF.getName() + "' in Output concept should not be there!");
                }
                BaseAttribute mappedBA = (BaseAttribute)outF;
                int i2 = 0;
                while (i2 < theMappedBAs.length && !theMappedBAs[i2].correspondsTo(mappedBA)) {
                    ++i2;
                }
                if (!theMappedBAs[i2].correspondsTo(mappedBA)) {
                    throw new M4CompilerError("Operator PivotizeWithAggregation: BaseAttribute '" + mappedBA.getName() + "' (from the output concept) should be one of the Mapped Attributes, " + "but could not be found in the list of Mapped Attributes!");
                }
                String indexValue = theIndexValues[i2].getValue();
                columnExpr = this.createPivotizedColumn(mappedBA, indexValue, csForOutputConcept, columnExpr);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator PivotizeWithAggregation: M4 Exception caught when generating metadata: " + m4e.getMessage());
        }
        if (columnExpr.length() <= 2) {
            throw new M4CompilerError("Operator PivotizeWithAggregation: No columns created for output concept!");
        }
        columnExpr = columnExpr.substring(0, columnExpr.length() - 2);
        return columnExpr;
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return false;
    }

    private Feature correspondsToOneOf(Feature f, Feature[] someFeatures) {
        int i = 0;
        while (i < someFeatures.length) {
            if (someFeatures[i].correspondsTo(f)) {
                return someFeatures[i];
            }
            ++i;
        }
        return null;
    }

    private String createPivotizedColumn(BaseAttribute outBA, String pivotValue, Columnset csForOutputConcept, String columnExpr) throws M4CompilerError {
        Column outputColumn;
        String myNull;
        Column indexCol;
        Column pivotCol;
        BaseAttribute pivotBA = (BaseAttribute)this.getSingleParameter(PARAMETER_PIVOT_ATTR);
        BaseAttribute indexBA = (BaseAttribute)this.getSingleParameter(PARAMETER_INDEX_ATTR);
        try {
            pivotCol = pivotBA.getCurrentColumn();
            if (pivotCol == null) {
                throw new M4CompilerError("Operator PivotizeWithAggregation: Could not find column for pivot BA '" + pivotBA.getName() + "!");
            }
            indexCol = indexBA.getCurrentColumn();
            if (indexCol == null) {
                throw new M4CompilerError("Operator PivotizeWithAggregation: Could not find column for index BA '" + indexBA.getName() + "!");
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator PivotizeWithAggregation: M4 Exception caught when accessing column of index or pivot attribute: " + m4e.getMessage());
        }
        Value nullOrZero = (Value)this.getSingleParameter(PARAMETER_NULLORZERO);
        if (nullOrZero == null || nullOrZero.getValue().equalsIgnoreCase("null")) {
            myNull = "NULL";
        } else if (nullOrZero.getValue().equalsIgnoreCase("zero")) {
            myNull = "0";
        } else {
            throw new M4CompilerError("Operator PivotizeWithAggregation: Parameter 'NullOrZero' must be 'Null' or 'Zero'!");
        }
        boolean indexBaNominal = indexBA.getConceptualDataType() == 1L || indexBA.getConceptualDataType() == 2L;
        Value agg = (Value)this.getSingleParameter(PARAMETER_AGGREGATION);
        String colDef = String.valueOf(agg.getValue().toUpperCase()) + "(CASE WHEN " + indexCol.getSQLPlusLocation() + " = " + (indexBaNominal ? DB.quote(pivotValue) : pivotValue) + " THEN " + pivotCol.getSQLPlusLocation() + " ELSE " + myNull + " END)";
        try {
            outputColumn = pivotCol.copyColTo(csForOutputConcept);
            this.getStep().addToTrash(outputColumn);
            outputColumn.setBaseAttribute(outBA);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator PivotizeWithAggregation: M4 exception caught when creating column for output BaseAttribute '" + outBA.getName() + "' (Id: " + outBA.getId() + "): " + m4e.getMessage());
        }
        outputColumn.setSQLDefinition(outBA.getName());
        outputColumn.setName(outBA.getName());
        return String.valueOf(columnExpr) + colDef + " AS " + outBA.getName() + ", ";
    }

    private String getGroupByStatement() throws M4CompilerError {
        Feature[] theGroupByFeatures = (Feature[])this.getParameter(PARAMETER_GROUPBY_ATTR);
        String theList = "";
        try {
            int i = 0;
            while (i < theGroupByFeatures.length) {
                if (theGroupByFeatures[i] instanceof BaseAttribute) {
                    theList = String.valueOf(theList) + ((BaseAttribute)theGroupByFeatures[i]).getCurrentColumn().getName() + ", ";
                } else {
                    if (!(theGroupByFeatures[i] instanceof MultiColumnFeature)) {
                        throw new M4CompilerError("Operator PivotizeWithAggregation: One of the features listed in 'TheGroupByAttributes' is neither a BaseAttribute nor a MCF!");
                    }
                    Collection c = ((MultiColumnFeature)theGroupByFeatures[i]).getBaseAttributes();
                    if (c == null || c.isEmpty()) {
                        throw new M4CompilerError("Operator PivotizeWithAggregation: No BAs found in MCF '" + theGroupByFeatures[i].getName() + "'!");
                    }
                    Iterator it = c.iterator();
                    while (it.hasNext()) {
                        BaseAttribute ba = (BaseAttribute)it.next();
                        theList = String.valueOf(theList) + ba.getCurrentColumn().getName() + ", ";
                    }
                }
                ++i;
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator PivotizeWithAggregation: M4Exception caught when collecting the names of the GroupBy-Attributes: " + m4e.getMessage());
        }
        if (theList.length() > 2) {
            theList = theList.substring(0, theList.length() - 2);
        }
        return theList;
    }

    private BaseAttribute getIndexBA() throws M4CompilerError {
        BaseAttribute ba = (BaseAttribute)this.getSingleParameter(PARAMETER_INDEX_ATTR);
        if (ba == null) {
            throw new M4CompilerError("Operator PivotizeWithAggregation: Parameter 'TheIndexAttribute' not found!");
        }
        return ba;
    }
}

