/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Step;
import java.sql.SQLException;
import miningmart.compiler.operator.ManualDiscretization;

public class NumericalIntervalManualDiscretization
extends ManualDiscretization {
    private String tableName;

    public void load(Step st) throws M4CompilerError {
        super.load(st);
        if (this.getIntervalStart().length != this.getIntervalEnd().length || this.getIntervalEnd().length != this.getMapTo().length || this.getMapTo().length != this.getStartIncExc().length || this.getStartIncExc().length != this.getEndIncExc().length) {
            throw new M4CompilerError("NumericalIntervalManualDiscretization: Parameters lists IntervalStart, IntervalEnd, MapTo, StartIncExc and EndIncExc sizes must be equal!");
        }
    }

    private void createTable(String schema) throws M4CompilerError {
        this.tableName = "M4_DT_" + this.getStep().getId() + "_" + this.getCurrentLoopNumber();
        this.getM4Db().dropBusinessTable(this.tableName);
        boolean useBusinessDbmsDatatypes = true;
        String numberDatatype = this.getM4Db().getDbNameOfM4Datatype("NUMBER", 0, useBusinessDbmsDatatypes);
        String string100Datatype = this.getM4Db().getDbNameOfM4Datatype("STRING", 100, useBusinessDbmsDatatypes);
        String charDatatype = this.getM4Db().getDbNameOfM4Datatype("STRING", 1, useBusinessDbmsDatatypes);
        String create_table = "CREATE TABLE " + this.tableName + " (int_start " + numberDatatype + ", int_end " + numberDatatype + ", value " + string100Datatype + ", left_b " + charDatatype + ", right_b " + charDatatype + ")";
        try {
            this.getM4Db().executeBusinessSqlWrite(create_table);
        }
        catch (SQLException e) {
            throw new M4CompilerError("Error trying to create the table " + this.tableName + ": " + e.getMessage());
        }
        String alter_table = "ALTER TABLE " + this.tableName + " ADD CONSTRAINT " + this.tableName + "_chk CHECK (left_b IN ('I','E') AND right_b IN ('I','E'))";
        try {
            this.getM4Db().executeBusinessSqlWrite(alter_table);
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException e) {
            throw new M4CompilerError("Error trying to alter the table " + this.tableName + ": " + e.getMessage());
        }
        this.getM4Db().addTableToTrash(this.tableName, schema, this.getStep().getId());
        String insert_query = null;
        int i = 0;
        while (i < this.getIntervalStart().length) {
            insert_query = "INSERT INTO " + schema + "." + this.tableName + " VALUES (" + this.getIntervalStart()[i].getValue() + "," + this.getIntervalEnd()[i].getValue() + ",'" + this.getMapTo()[i].getValue() + "','" + this.getStartIncExc()[i].getValue() + "','" + this.getEndIncExc()[i].getValue() + "')";
            this.doPrint(3, insert_query);
            try {
                this.getM4Db().executeBusinessSqlWrite(insert_query);
                this.getM4Db().commitBusinessTransactions();
            }
            catch (SQLException e) {
                throw new M4CompilerError("Error trying to fill the discretization table " + this.tableName + ": " + e.getMessage());
            }
            ++i;
        }
    }

    public String generateSQL(Column theTargetAttributeColumn) throws M4CompilerError {
        String inputColumn = theTargetAttributeColumn.getSQLDefinition();
        int numberOfIntervals = this.getIntervalStart().length;
        String sql = "(CASE ";
        int i = 0;
        while (i < numberOfIntervals) {
            String oneIntervalQuery = "WHEN (";
            oneIntervalQuery = String.valueOf(oneIntervalQuery) + inputColumn + this.getGreater(i, true) + this.getIntervalStart()[i].getValue() + ") AND (" + inputColumn + this.getSmaller(i, false) + this.getIntervalEnd()[i].getValue() + ")" + " THEN '" + this.getMapTo()[i].getValue() + "' ";
            sql = String.valueOf(sql) + oneIntervalQuery;
            ++i;
        }
        sql = String.valueOf(sql) + "ELSE '" + this.getDefaultValue().getValue() + "' END)";
        return sql;
    }
}

