/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.ParameterDeselectedError;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.Relation;
import edu.udo.miningmart.m4.core.Step;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import miningmart.compiler.operator.SingleCSOperator;

public class MultiRelationalFeatureConstruction
extends SingleCSOperator {
    private String condition;
    private String listOfColumnSets;

    protected Concept[] getMyChainConcepts() {
        return (Concept[])this.getParameter("TheConcepts");
    }

    protected Relation[] getMyRelations() {
        return (Relation[])this.getParameter("TheRelations");
    }

    protected Feature[] getSelectedFeatures() {
        return (Feature[])this.getParameter("TheChainedFeatures");
    }

    protected String getCondition() {
        return this.condition;
    }

    protected String getListOfColumnSets() {
        return this.listOfColumnSets;
    }

    protected void setCondition(String condition) {
        this.condition = condition;
    }

    protected void setListOfColumnSets(String listOfColumnSets) {
        this.listOfColumnSets = listOfColumnSets;
    }

    public void load(Step st) throws ParameterDeselectedError, M4CompilerError {
        super.load(st);
        this.checkChainValidity();
    }

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return false;
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        String ret = "(select " + selectPart + " from " + this.getListOfColumnSets() + " where " + this.getCondition() + ")";
        return ret;
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        try {
            String listOfColumns = "";
            this.setCondition("");
            this.setListOfColumnSets("");
            int index = 0;
            Concept actualDomain = this.getInputConcept();
            listOfColumns = this.addToListsAndCreateMetadata(actualDomain, csForOutputConcept, listOfColumns);
            while (index < this.getMyRelations().length) {
                Columnset actualRangeCS;
                Columnset actualDomainCS;
                Column actualRangeKeyCol;
                Column actualDomainKeyCol;
                Column rangeKeyCol;
                Column domainKeyCol;
                Concept actualRange = this.getMyChainConcepts()[index];
                Columnset crossCS = this.getMyRelations()[index].getCrossLinkColumnSet();
                if (crossCS == null) {
                    domainKeyCol = this.getMyRelations()[index].getFromKey().getFirstForeignKeyColumn();
                    rangeKeyCol = this.getMyRelations()[index].getFromKey().getFirstPrimaryKeyColumn();
                    actualDomainKeyCol = this.findColumnInConcept(domainKeyCol, actualDomain);
                    actualRangeKeyCol = this.findColumnInConcept(rangeKeyCol, actualRange);
                    actualDomainCS = actualDomain.getCurrentColumnSet();
                    actualRangeCS = actualRange.getCurrentColumnSet();
                    this.setCondition(String.valueOf(this.getCondition()) + actualDomainCS.getSchema() + "." + actualDomainCS.getName() + "." + actualDomainKeyCol.getSQLDefinition() + " = " + actualRangeCS.getSchema() + "." + actualRangeCS.getName() + "." + actualRangeKeyCol.getSQLDefinition() + " AND ");
                } else {
                    if (this.getMyRelations()[index].getToKey() == null) {
                        throw new M4CompilerError("MRFC: Relation with Id " + this.getMyRelations()[index].getId() + " seems to be n:m, but the second key is missing!");
                    }
                    domainKeyCol = this.getMyRelations()[index].getFromKey().getFirstPrimaryKeyColumn();
                    Column crossKeyCol_1 = this.getMyRelations()[index].getFromKey().getFirstForeignKeyColumn();
                    Column crossKeyCol_2 = this.getMyRelations()[index].getToKey().getFirstForeignKeyColumn();
                    rangeKeyCol = this.getMyRelations()[index].getToKey().getFirstPrimaryKeyColumn();
                    actualDomainKeyCol = this.findColumnInConcept(domainKeyCol, actualDomain);
                    actualRangeKeyCol = this.findColumnInConcept(rangeKeyCol, actualRange);
                    actualDomainCS = actualDomain.getCurrentColumnSet();
                    actualRangeCS = actualRange.getCurrentColumnSet();
                    this.setCondition(String.valueOf(this.getCondition()) + actualDomainCS.getSchema() + "." + actualDomainCS.getName() + "." + actualDomainKeyCol.getSQLDefinition() + " = " + crossCS.getSchema() + "." + crossCS.getName() + "." + crossKeyCol_1.getSQLDefinition() + " AND " + actualRangeCS.getSchema() + "." + actualRangeCS.getName() + "." + actualRangeKeyCol.getSQLDefinition() + " = " + crossCS.getSchema() + "." + crossCS.getName() + "." + crossKeyCol_2.getSQLDefinition() + " AND ");
                    this.setListOfColumnSets(String.valueOf(this.getListOfColumnSets()) + crossCS.getSchema() + "." + crossCS.getName() + ", ");
                }
                listOfColumns = this.addToListsAndCreateMetadata(actualRange, csForOutputConcept, listOfColumns);
                ++index;
                actualDomain = actualRange;
            }
            this.setCondition(this.getCondition().substring(0, this.getCondition().length() - 5));
            listOfColumns = listOfColumns.substring(0, listOfColumns.length() - 2);
            this.setListOfColumnSets(this.getListOfColumnSets().substring(0, this.getListOfColumnSets().length() - 2));
            return listOfColumns;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private String addToListsAndCreateMetadata(Concept currentConcept, Columnset csForOutputConcept, String listOfColumns) throws M4CompilerError {
        try {
            Vector<Feature> selectedFeaturesOfCurrentConcept = new Vector<Feature>();
            Collection concFeatures = currentConcept.getFeatures();
            Iterator it = concFeatures.iterator();
            Feature[] selectedFeat = this.getSelectedFeatures();
            while (it.hasNext()) {
                Feature f = (Feature)it.next();
                int j = 0;
                while (j < selectedFeat.length) {
                    if (f.getId() == selectedFeat[j].getId()) {
                        selectedFeaturesOfCurrentConcept.add(f);
                    }
                    ++j;
                }
            }
            if (selectedFeaturesOfCurrentConcept.isEmpty()) {
                return listOfColumns;
            }
            this.setListOfColumnSets(String.valueOf(this.getListOfColumnSets()) + currentConcept.getCurrentColumnSet().getSchema() + "." + currentConcept.getCurrentColumnSet().getName() + ", ");
            int i = 0;
            while (i < selectedFeaturesOfCurrentConcept.size()) {
                Feature oldF = (Feature)selectedFeaturesOfCurrentConcept.get(i);
                Feature newF = null;
                int k = 0;
                while (k < this.getOutputConcept().getFeatures().size() && !(newF = this.getOutputConcept().getFeature(k)).correspondsTo(oldF)) {
                    ++k;
                }
                if (k == this.getOutputConcept().getFeatures().size()) {
                    throw new M4CompilerError("MRFC: TheChainedFeature '" + oldF.getName() + "' not found in TheOutputConcept!");
                }
                if (this.isDeselectedParameter(oldF)) {
                    this.doPrint(5, "MRFC: TheChainedFeature '" + oldF.getName() + "' is skipped " + "because it was deselected by a FeatureSelection operator.");
                } else {
                    listOfColumns = this.createMetadata(oldF, newF, csForOutputConcept, listOfColumns);
                }
                ++i;
            }
            return listOfColumns;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private Column findColumnInConcept(Column keyCol, Concept toSearch) throws M4CompilerError {
        try {
            Collection fs = toSearch.getFeatures();
            Feature foundFeature = null;
            Iterator it = fs.iterator();
            while (it.hasNext()) {
                Feature f = (Feature)it.next();
                if (!f.correspondsTo(keyCol.getTheBaseAttribute())) continue;
                foundFeature = f;
            }
            if (foundFeature == null) {
                throw new M4CompilerError("MRFC: Column '" + keyCol.getName() + "' (Id: " + keyCol.getId() + ") was found in one of the relation keys, " + "but could not be matched to the current Concept!");
            }
            BaseAttribute foundBA = (BaseAttribute)foundFeature;
            Column foundColumn = foundBA.getCurrentColumn();
            return foundColumn;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void checkChainValidity() throws M4CompilerError {
        String info = "No valid chain of relations found among the input concepts! \nParameter 'TheInputConcept' must be the first element of the chain. \nThe following elements must be given as parameters 'TheConcepts' \nin the order of the chain. The relations between these concepts \nmust be given as parameters 'TheRelations' in the same order. \nThere must be as many relations as concepts, excluding 'TheInputConcept'.";
        if (this.getMyRelations().length != this.getMyChainConcepts().length) {
            throw new M4CompilerError(info);
        }
    }

    protected void setNewCSMultiStepBranch(Columnset newCS, int index) throws M4CompilerError {
        try {
            Concept[] theConcepts = this.getMyChainConcepts();
            Object[] msbArray = new String[theConcepts.length + 1];
            int i = 0;
            while (i < theConcepts.length) {
                String msb = theConcepts[i].getCurrentColumnSet().getMultiStepBranch();
                msbArray[i++] = MultiRelationalFeatureConstruction.nullToEmpty(msb);
            }
            msbArray[i] = MultiRelationalFeatureConstruction.nullToEmpty(this.getInputConcept().getCurrentColumnSet().getMultiStepBranch());
            Arrays.sort(msbArray);
            newCS.setMultiStepBranch("");
            i = 0;
            while (i < msbArray.length) {
                newCS.addMultiStepBranch((String)msbArray[i]);
                ++i;
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }
}

