/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.ParameterDeselectedError;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.Step;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import miningmart.compiler.operator.SingleCSOperator;

public class JoinByKey
extends SingleCSOperator {
    private String listOfColumnSets;
    private String condition;
    private BaseAttribute[] sortedKeys;
    private Concept[] sortedConcepts;

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        String sqlDef = "(select " + selectPart + " from " + this.createListOfColumnSets() + " where " + this.createCondition() + ")";
        return sqlDef;
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        try {
            String columnExpr = "";
            Feature inF = null;
            int iIn = 0;
            Feature outF = null;
            Feature[][] mapping = this.getInOutMap();
            Iterator it = this.getOutputConcept().getFeatures().iterator();
            Vector<Feature> outputFeaturesNotInMapping = new Vector<Feature>();
            while (it.hasNext()) {
                outF = (Feature)it.next();
                int mapPos = this.checkOccurrence(mapping, outF);
                if (mapPos > -1) {
                    inF = mapping[0][mapPos];
                    columnExpr = this.createMetadata(inF, outF, csForOutputConcept, columnExpr);
                    continue;
                }
                outputFeaturesNotInMapping.add(outF);
            }
            it = ((AbstractList)outputFeaturesNotInMapping).iterator();
            while (it.hasNext()) {
                outF = (Feature)it.next();
                int conceptNumber = 0;
                do {
                    Concept currentConcept = this.getSortedConcepts()[conceptNumber];
                    iIn = 0;
                    do {
                        inF = currentConcept.getFeature(iIn);
                    } while (++iIn < currentConcept.getNumberOfFeatures() && !outF.correspondsTo(inF));
                } while (++conceptNumber < this.sortedConcepts.length && !outF.correspondsTo(inF));
                if (!outF.correspondsTo(inF)) {
                    this.doPrint(7, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because no corresponding input feature was found.");
                    continue;
                }
                if (this.isDeselectedParameter(inF)) {
                    this.doPrint(5, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because the corresponding input feature was deselected by " + "a FeatureSelection operator.");
                    continue;
                }
                columnExpr = this.createMetadata(inF, outF, csForOutputConcept, columnExpr);
            }
            columnExpr = columnExpr.substring(0, columnExpr.length() - 2);
            return columnExpr;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected String createMetadataForOneBA(BaseAttribute inBA, BaseAttribute outBA, Columnset csForOutputConcept, String columnExpr) throws M4CompilerError {
        Column outputColumn;
        Column inputColumn;
        try {
            inputColumn = inBA.getCurrentColumn();
            outputColumn = inputColumn.copyColTo(csForOutputConcept);
            this.getStep().addToTrash(outputColumn);
            outputColumn.setBaseAttribute(outBA);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("JoinByKey: M4 Interface error occurred when creating metadata for input BaseAttribute '" + inBA.getName() + "' (Id: " + inBA.getId() + ") and output BaseAttribute '" + outBA.getName() + "' (Id: " + outBA.getId() + "): " + m4e.getMessage());
        }
        outputColumn.setSQLDefinition(outBA.getName());
        outputColumn.setName(outBA.getName());
        String nextAttrib = "";
        if (inputColumn.getSQLDefinition().equalsIgnoreCase(inputColumn.getName())) {
            nextAttrib = String.valueOf(inputColumn.getColumnset().getSchemaPlusName()) + ".";
        }
        nextAttrib = String.valueOf(nextAttrib) + inputColumn.getSQLDefinition() + " AS " + outBA.getName();
        columnExpr = String.valueOf(columnExpr) + nextAttrib + ", ";
        return columnExpr;
    }

    protected void setNewCSMultiStepBranch(Columnset newCS, int index) throws M4CompilerError {
        try {
            Concept[] theConcepts = this.getSortedConcepts();
            Object[] msbArray = new String[theConcepts.length + 1];
            int i = 0;
            while (i < theConcepts.length) {
                String msb = theConcepts[i].getCurrentColumnSet().getMultiStepBranch();
                msbArray[i++] = JoinByKey.nullToEmpty(msb);
            }
            msbArray[i] = JoinByKey.nullToEmpty(this.getInputConcept().getCurrentColumnSet().getMultiStepBranch());
            Arrays.sort(msbArray);
            newCS.setMultiStepBranch("");
            i = 0;
            while (i < msbArray.length) {
                newCS.addMultiStepBranch((String)msbArray[i]);
                ++i;
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public Concept getInputConcept() {
        return this.getSortedConcepts()[0];
    }

    private static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return false;
    }

    protected Concept[] getSortedConcepts() {
        return this.sortedConcepts;
    }

    protected BaseAttribute[] getSortedKeys() {
        return this.sortedKeys;
    }

    protected Feature[][] getInOutMap() throws M4CompilerError {
        int noOfMappings = this.getHighestLoopNr();
        Feature[][] theMap = new Feature[2][noOfMappings];
        int l = 0;
        while (l < noOfMappings) {
            theMap[0][l] = (Feature)this.getSingleParameter("MapInput", l);
            theMap[1][l] = (Feature)this.getSingleParameter("MapOutput", l);
            if (theMap[0][l] == null || theMap[1][l] == null) {
                throw new M4CompilerError("Operator JoinByKey: mapping information is incomplete!");
            }
            ++l;
        }
        return theMap;
    }

    private int checkOccurrence(Feature[][] map, Feature f) {
        int i = 0;
        while (i < map[1].length) {
            if (map[1][i].getId() == f.getId()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String createListOfColumnSets() throws M4CompilerError {
        try {
            String list = "";
            int i = 0;
            while (i < this.getSortedConcepts().length) {
                Columnset cs = this.getSortedConcepts()[i].getCurrentColumnSet();
                list = String.valueOf(list) + cs.getSchemaPlusName() + ", ";
                ++i;
            }
            list = list.substring(0, list.length() - 2);
            return list;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private String createCondition() throws M4CompilerError {
        try {
            Columnset cs = this.getSortedConcepts()[0].getCurrentColumnSet();
            BaseAttribute key = this.getSortedKeys()[0];
            int noOfCons = this.getSortedConcepts().length;
            String cond = String.valueOf(cs.getSchemaPlusName()) + "." + key.getCurrentColumn().getSQLDefinition();
            cond = String.valueOf(cond) + " = ";
            int i = 1;
            while (i < noOfCons - 1) {
                cs = this.getSortedConcepts()[i].getCurrentColumnSet();
                key = this.getSortedKeys()[i];
                cond = String.valueOf(cond) + cs.getSchemaPlusName() + "." + key.getCurrentColumn().getSQLDefinition();
                cond = String.valueOf(cond) + " AND ";
                cond = String.valueOf(cond) + cs.getSchemaPlusName() + "." + key.getCurrentColumn().getSQLDefinition();
                cond = String.valueOf(cond) + " = ";
                ++i;
            }
            cs = this.getSortedConcepts()[noOfCons - 1].getCurrentColumnSet();
            key = this.getSortedKeys()[noOfCons - 1];
            cond = String.valueOf(cond) + cs.getSchemaPlusName() + "." + key.getCurrentColumn().getSQLDefinition();
            return cond;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void relateKeysToConcepts() throws M4CompilerError {
        BaseAttribute[] keys = (BaseAttribute[])this.getParameter("TheKeys");
        this.sortedConcepts = (Concept[])this.getParameter("TheConcepts");
        if (keys == null || keys.length == 0) {
            throw new M4CompilerError("Operator JoinByKey: No keys found!");
        }
        if (this.sortedConcepts == null || this.sortedConcepts.length == 0) {
            throw new M4CompilerError("Operator JoinByKey: No concepts found!");
        }
        if (this.sortedConcepts.length != keys.length) {
            throw new M4CompilerError("Operator JoinByKey: Number of keys must be equal to number of concepts!");
        }
        this.sortedKeys = new BaseAttribute[keys.length];
        int i = 0;
        while (i < this.sortedConcepts.length) {
            this.sortedKeys[i] = keys[this.findKeyPosition(this.sortedConcepts[i], keys)];
            ++i;
        }
    }

    private int findKeyPosition(Concept c, BaseAttribute[] bas) throws M4CompilerError {
        Collection theConceptFeatures;
        try {
            theConceptFeatures = c.getFeatures();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        if (theConceptFeatures == null || theConceptFeatures.size() == 0) {
            throw new M4CompilerError("Operator JoinByKey: concept '" + c.getName() + "' has no features!");
        }
        int j = 0;
        while (j < bas.length) {
            Iterator it = theConceptFeatures.iterator();
            while (it.hasNext()) {
                if (bas[j].getId() != ((Feature)it.next()).getId()) continue;
                return j;
            }
            ++j;
        }
        throw new M4CompilerError("Operator JoinByKey: concept '" + c.getName() + "' does not contain any of the given keys!");
    }

    public void load(Step st) throws ParameterDeselectedError, M4CompilerError {
        super.load(st);
        this.relateKeysToConcepts();
    }
}

