/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.MultiColumnFeature;
import edu.udo.miningmart.m4.core.Value;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import miningmart.compiler.operator.FeatureConstruction;

public class GenericFeatureConstruction
extends FeatureConstruction {
    private BaseAttribute[] outputBAs = null;
    private static String NO_COLUMN_ATTACHED = "< *** No Column *** >";

    public String generateSQL(Column targetColumn) throws M4CompilerError {
        String translated = this.getTranslatedSQL_String();
        this.doPrint(7, translated);
        return translated;
    }

    private boolean isOutputBA(BaseAttribute ba) {
        int i;
        if (this.outputBAs == null) {
            this.outputBAs = new BaseAttribute[this.getHighestLoopNr()];
            i = 0;
            while (i < this.getHighestLoopNr()) {
                this.outputBAs[i] = (BaseAttribute)this.getSingleParameter("TheOutputAttribute", i);
                ++i;
            }
        }
        i = 0;
        while (i < this.getHighestLoopNr()) {
            if (this.outputBAs[i].getId() == ba.getId()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getTranslatedSQL_String() throws M4CompilerError {
        HashMap allMappings = this.getBaColumnMapping();
        String untranslatedSql = this.getSqlString();
        StringBuffer translated = new StringBuffer();
        int i = 0;
        while (i < untranslatedSql.length()) {
            int stop;
            int start = GenericFeatureConstruction.nextLetter(untranslatedSql, i);
            if (start > i) {
                translated.append(untranslatedSql.substring(i, start));
            }
            if ((stop = GenericFeatureConstruction.nextNotNameChar(untranslatedSql, start)) > start) {
                String token = untranslatedSql.substring(start, stop);
                String column = (String)allMappings.get(token.toUpperCase());
                if (column == NO_COLUMN_ATTACHED) {
                    throw new M4CompilerError("Operator GenericFeatureConstruction: An error occured when trying to apply the following Pseudo-SQL statement:\n" + untranslatedSql + "\nBaseAttribute " + token + " has no valid column!");
                }
                translated.append(column == null ? token : column);
            }
            i = stop;
        }
        return translated.toString();
    }

    private HashMap getBaColumnMapping() throws M4CompilerError {
        HashMap<String, String> allMappings = new HashMap<String, String>();
        Vector allBaseAttribs = this.getAllInputConceptBAs();
        Iterator it = ((AbstractList)allBaseAttribs).iterator();
        try {
            while (it.hasNext()) {
                BaseAttribute ba = (BaseAttribute)it.next();
                if (this.isOutputBA(ba)) continue;
                String baName = ba.getName();
                if (allMappings.containsKey(baName)) {
                    throw new M4CompilerError("Operator GenericFeatureConstruction: found more than one BaseAttribute '" + baName + "' in TheInputConcept!");
                }
                Column col = ba.getCurrentColumn();
                if (col != null) {
                    String colName = col.getSQLDefinition();
                    allMappings.put(baName.toUpperCase(), colName);
                    continue;
                }
                allMappings.put(baName.toUpperCase(), NO_COLUMN_ATTACHED);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        return allMappings;
    }

    private static int nextLetter(String s, int start) {
        int length = s.length();
        int i = start >= 0 ? start : 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                return i;
            }
            if (c == '\'' && i + 1 < length && (i = s.indexOf(39, i + 1)) == -1) {
                i = length;
            }
            ++i;
        }
        return length;
    }

    private static int nextNotNameChar(String s, int start) {
        int length = s.length();
        int i = start >= 0 ? start : 0;
        while (i < length) {
            char c = s.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_')) {
                return i;
            }
            ++i;
        }
        return length;
    }

    private Vector getAllInputConceptBAs() throws M4CompilerError {
        try {
            Vector<BaseAttribute> allBaseAttribs = new Vector<BaseAttribute>();
            Collection fs = this.getTheInputConcept().getFeatures();
            Iterator it = fs.iterator();
            while (it.hasNext()) {
                Feature f = (Feature)it.next();
                if (f instanceof BaseAttribute) {
                    allBaseAttribs.add((BaseAttribute)f);
                    continue;
                }
                Collection theBAs = ((MultiColumnFeature)f).getBaseAttributes();
                Iterator it2 = theBAs.iterator();
                while (it2.hasNext()) {
                    allBaseAttribs.add((BaseAttribute)it2.next());
                }
            }
            return allBaseAttribs;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public String getSqlString() {
        Value v = (Value)this.getSingleParameter("SQL_String", this.getCurrentLoopNumber());
        return v.getValue();
    }
}

