/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.ParameterDeselectedError;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.M4Object;
import edu.udo.miningmart.m4.core.OpParam;
import edu.udo.miningmart.m4.core.Operator;
import edu.udo.miningmart.m4.core.ParamDict;
import edu.udo.miningmart.m4.core.Parameter;
import edu.udo.miningmart.m4.core.ParameterArray;
import edu.udo.miningmart.m4.core.ParameterObject;
import edu.udo.miningmart.m4.core.Step;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class ExecutableOperator {
    private Step myStep;
    private Operator myOperator;
    private int numberOfLoops = -1;
    protected String[] generatedSQLDefinitions;
    private ParamDict myParameters;

    public void load(Step step) throws ParameterDeselectedError, M4CompilerError {
        if (step == null || step.getId() == 0L) {
            throw new M4CompilerError("Error in constructor of executable operator:\nParameter step " + (step == null ? "is null" : "has ID 0"));
        }
        this.myStep = step;
        this.myOperator = this.getStep().getTheOperator();
        if (this.myOperator == null) {
            throw new M4CompilerError("ExecutableOperator.getOpParamsIterator():\nStep with ID " + this.getStep().getId() + " has no operator embedded!");
        }
        this.removeDeselectedParameters();
    }

    public ParameterObject[] getParameter(String name, int loopNr) {
        try {
            ParameterArray p = this.getParameterDictionary().get(name, loopNr);
            if (p == null) {
                return null;
            }
            return p.getParameterObjectArray();
        }
        catch (M4Exception e) {
            this.doPrint(11, "Warning: Exception caught when trying to fetch parameters for Step " + this.getStep().getId());
            this.doPrint(e);
            return null;
        }
    }

    public ParameterObject[] getParameter(String name) {
        return this.getParameter(name, 0);
    }

    public M4Object getSingleParameter(String name) {
        return this.getSingleParameter(name, 0);
    }

    public M4Object getSingleParameter(String name, int loopNr) {
        ParameterObject[] array = this.getParameter(name, loopNr);
        if (array == null || array.length == 0) {
            return null;
        }
        return array[0];
    }

    private ParameterArray getParameterFromDict(String name, int loopNr) throws M4Exception {
        return this.getParameterDictionary().get(name, loopNr);
    }

    private ParamDict getParameterDictionary() throws M4Exception {
        if (this.myParameters == null) {
            this.myParameters = this.getStep().readParametersForExecutableFromDB();
        }
        return this.myParameters;
    }

    public CompilerDatabaseService getM4Db() throws M4CompilerError {
        DB theDB = this.getStep().getM4Db();
        if (theDB instanceof CompilerDatabaseService) {
            return (CompilerDatabaseService)theDB;
        }
        throw new M4CompilerError("Executable Operator (" + this.getName() + "): expected CompilerDatabaseService instead of DB!");
    }

    public Operator getOperator() {
        return this.myOperator;
    }

    public String getName() {
        return this.getOperator().getName();
    }

    public Step getStep() {
        return this.myStep;
    }

    public boolean isLoopable() {
        return this.getOperator().isLoopable();
    }

    public boolean isManual() {
        return this.getOperator().isManual();
    }

    public boolean isStepable() {
        return this.getOperator().isStepable();
    }

    protected final int getHighestLoopNr() {
        if (this.numberOfLoops == -1) {
            this.numberOfLoops = this.getStep().getLoopCount();
        }
        return this.numberOfLoops;
    }

    public int getNumberOfLoops() {
        int loops = this.getHighestLoopNr();
        return loops > 0 ? loops : 1;
    }

    public Iterator getOpParamsIterator() throws M4CompilerError {
        try {
            Iterator it = this.getOperator().getOpParamsIterator();
            if (it == null) {
                throw new M4CompilerError("Could not get iterator for OpParams of operator with ID " + this.getOperator().getId());
            }
            return it;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void removeDeselectedParameters() throws ParameterDeselectedError, M4CompilerError {
        Iterator it = this.getOpParamsIterator();
        ParameterDeselectedError e = null;
        try {
            while (it.hasNext()) {
                OpParam op = (OpParam)it.next();
                if (!op.isInput()) continue;
                String paramName = op.getName();
                int highestLoop = this.getParameterDictionary().isLooped(paramName) ? this.getHighestLoopNr() : 1;
                int i = 0;
                while (i < highestLoop) {
                    ParameterArray oldParam = this.getParameterFromDict(paramName, i);
                    ParameterArray newParam = this.removeDeselectedParameters(oldParam);
                    if (oldParam.size() != newParam.size()) {
                        e = this.replaceParameterInCache(op, i, newParam, e);
                    }
                    ++i;
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        if (e != null) {
            throw e;
        }
    }

    private ParameterDeselectedError replaceParameterInCache(OpParam op, int loop, ParameterArray par, ParameterDeselectedError e) throws M4CompilerError {
        int length;
        try {
            this.getParameterDictionary().replace(op.getName(), loop, par);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        int n = length = par == null ? 0 : par.size();
        if (length < op.getMinArg()) {
            if (e == null) {
                String msg = "Loading parameters for operator " + this.getName() + ", step id: " + this.getStep().getId() + "\n" + "Due to deselection of features by FeatureSelection the " + "following parameters violate operator constraints:\n" + op.getName();
                e = new ParameterDeselectedError(msg, op);
            } else {
                e = new ParameterDeselectedError(op.getName(), op, e);
            }
        }
        return e;
    }

    private ParameterArray removeDeselectedParameters(ParameterArray m4o) throws M4CompilerError {
        if (m4o == null || m4o.size() == 0) {
            return m4o;
        }
        try {
            ParameterArray newPA = new ParameterArray(m4o.getParameterType());
            Collection theParameters = m4o.getParameters();
            Iterator it = ((AbstractList)new Vector(theParameters)).iterator();
            while (it.hasNext()) {
                Parameter current = (Parameter)it.next();
                this.isDeselectedParameter(current);
                newPA.addParameter(current);
            }
            return newPA;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected final boolean isDeselectedParameter(M4Object m4o) throws M4CompilerError {
        if (m4o != null && m4o instanceof Feature) {
            return ((Feature)m4o).isDeselected();
        }
        return false;
    }

    public void doPrint(int verbosity, String printString) {
        this.getStep().doPrint(verbosity, printString);
    }

    public void doPrint(Exception ex) {
        this.getStep().doPrint(ex);
    }

    public final void print() {
        this.autoPrint();
    }

    public final void autoPrint() {
        try {
            Iterator it = this.getOpParamsIterator();
            while (it.hasNext()) {
                String name = ((OpParam)it.next()).getName();
                M4Object[] par = this.getParameter(name);
                this.doPrint(4, "Parameter '" + name + "' :");
                if (par != null) {
                    this.printM4Object(par);
                    continue;
                }
                int i = 0;
                while (i < this.getHighestLoopNr()) {
                    par = this.getParameter(name, i + 1);
                    this.doPrint(4, "  loopnr." + i + 1 + ":");
                    this.printM4Object(par);
                    ++i;
                }
            }
        }
        catch (M4CompilerError e) {
            this.doPrint(11, "autoPrint() for operator " + this.getName() + ", id: " + this.getOperator().getId() + " failed!\n" + e.getMessage());
        }
    }

    private void printM4Object(M4Object[] obj) {
        if (obj != null) {
            int i = 0;
            while (i < obj.length) {
                obj[i].print();
                ++i;
            }
        }
    }

    public void execute(boolean lazy) throws SQLException, M4CompilerError {
        this.print();
        this.createStatement(lazy);
        this.showCreateStatement();
        this.compileStatement();
    }

    public abstract void createStatement(boolean var1) throws SQLException, M4CompilerError;

    public void showCreateStatement() throws SQLException, M4CompilerError {
        if (this.generatedSQLDefinitions != null) {
            int i = 0;
            while (i < this.generatedSQLDefinitions.length) {
                this.doPrint(7, String.valueOf(this.getName()) + " generated: " + this.generatedSQLDefinitions[i]);
                ++i;
            }
        }
    }

    public abstract void compileStatement() throws SQLException, M4CompilerError;

    public abstract void writeResults() throws SQLException, M4CompilerError;

    protected short getM4Dbms() throws M4CompilerError, DbConnectionClosed {
        return this.getM4Db().getM4Dbms();
    }

    protected short getBusinessDbms() throws M4CompilerError, DbConnectionClosed {
        return this.getM4Db().getBusinessDbms();
    }

    protected boolean storedProceduresAvailable() throws DbConnectionClosed, M4CompilerError {
        return this.getBusinessDbms() == 1;
    }

    public M4Object getM4ObjectFromCache(long Id) throws M4CompilerError {
        return this.getM4Db().getM4ObjectFromCache(Id);
    }

    public void putM4ObjectToCache(M4Object m4o) throws M4CompilerError {
        try {
            this.getM4Db().putM4ObjectToCache(m4o);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public void executeM4SqlWrite(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        this.getM4Db().executeM4SqlWrite(query);
    }

    public void executeBusinessSqlWrite(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        this.getM4Db().executeBusinessSqlWrite(query);
    }

    public ResultSet executeM4SqlRead(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeM4SqlRead(query);
    }

    public ResultSet executeBusinessSqlRead(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeBusinessSqlRead(query);
    }

    public Long executeM4SingleValueSqlReadL(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeM4SingleValueSqlReadL(query);
    }

    public Long executeBusinessSingleValueSqlReadL(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeBusinessSingleValueSqlReadL(query);
    }

    public String executeM4SingleValueSqlRead(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeM4SingleValueSqlRead(query);
    }

    public String executeBusinessSingleValueSqlRead(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeBusinessSingleValueSqlRead(query);
    }

    public long getNextM4SequenceValue() throws M4CompilerError {
        try {
            return this.getM4Db().getNextM4SequenceValue();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    protected String getArtificalColumnName(String otherColumns) {
        String artCol = "Z";
        while (otherColumns.indexOf(String.valueOf(artCol) + ",") > -1) {
            artCol = String.valueOf(artCol) + "1";
        }
        return artCol;
    }
}

