/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import miningmart.compiler.operator.ExecutableOperator;

public abstract class EvaluateResults
extends ExecutableOperator {
    private Columnset theColumnSet;
    private String inputColumnSetName;
    private String actualColumnName;
    private String predictedColumnName;
    private double[] actualvalue;
    private double[] predictedvalue;

    public abstract double computeResult(double[] var1, double[] var2) throws M4CompilerError;

    private String generateSQL() throws M4CompilerError {
        try {
            this.theColumnSet = this.getInputConcept().getCurrentColumnSet();
            this.inputColumnSetName = String.valueOf(this.theColumnSet.getSchema()) + "." + this.theColumnSet.getName();
            this.actualColumnName = this.getActualValueAttribute().getCurrentColumn().getSQLDefinition();
            this.predictedColumnName = this.getPredictedValueAttribute().getCurrentColumn().getSQLDefinition();
            String callSQL = "SELECT " + this.actualColumnName + "," + this.predictedColumnName + " FROM " + this.inputColumnSetName;
            return callSQL;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public void createStatement(boolean lazy) throws SQLException, M4CompilerError {
        String query = this.generateSQL();
        this.doPrint(2, "DB Query: " + query);
        ResultSet rs = null;
        try {
            rs = this.getM4Db().executeBusinessSqlRead(query);
            Vector<Double> actval = new Vector<Double>();
            Vector<Double> predval = new Vector<Double>();
            while (rs.next()) {
                actval.add(new Double(rs.getDouble(1)));
                predval.add(new Double(rs.getDouble(2)));
            }
            this.actualvalue = new double[actval.size()];
            this.predictedvalue = new double[actval.size()];
            int i = 0;
            while (i < this.actualvalue.length) {
                this.actualvalue[i] = (Double)actval.get(i);
                this.predictedvalue[i] = (Double)predval.get(i);
                ++i;
            }
            double error = 0.0;
            error = this.computeResult(this.actualvalue, this.predictedvalue);
            this.doPrint(11, "Compared " + this.getActualValueAttribute().getName() + " and " + this.getPredictedValueAttribute().getName() + "; computed this error: " + error);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var8_10 = null;
        DB.closeResultSet(rs);
    }

    public void writeResults() throws SQLException, M4CompilerError {
    }

    public void compileStatement() throws SQLException, M4CompilerError {
    }

    public BaseAttribute getActualValueAttribute() {
        return (BaseAttribute)this.getSingleParameter("TheTargetValueAttribute");
    }

    public Concept getInputConcept() {
        return (Concept)this.getSingleParameter("TheInputConcept");
    }

    public BaseAttribute getPredictedValueAttribute() {
        return (BaseAttribute)this.getSingleParameter("ThePredictedValueAttribute");
    }
}

