/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Feature;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import miningmart.compiler.operator.ExecutableOperator;

public class EvaluateAdvantageOfTFIDFTransformation
extends ExecutableOperator {
    public void createStatement(boolean lazy) throws SQLException, M4CompilerError {
        Feature[] features;
        String colNames;
        String timeStamp;
        String key;
        String inputConcept;
        try {
            inputConcept = this.getInputConcept().getCurrentColumnSet().getSQLDefinition();
            key = this.getTheKey().getCurrentColumn().getName();
            timeStamp = this.getTheTimeStamp().getCurrentColumn().getName();
            colNames = String.valueOf(this.getTheKey().getCurrentColumn().getSQLDefinition()) + ", ";
            features = this.getTheSelectedAttributes();
            int i = 0;
            while (i < features.length) {
                BaseAttribute ba = (BaseAttribute)features[i];
                Column col = ba.getCurrentColumn();
                colNames = String.valueOf(colNames) + col.getName() + ", ";
                ++i;
            }
        }
        catch (M4Exception e) {
            throw new M4CompilerError("M4Exception during EvaluateAdvantageOfTFIDFTransformation.createStatement:\n" + e.getMessage());
        }
        colNames = colNames.substring(0, colNames.length() - 2);
        Hashtable indexes = new Hashtable();
        ResultSet ergebnis = null;
        try {
            try {
                String query = "SELECT " + colNames + " FROM " + inputConcept + " ORDER BY " + key + ", " + timeStamp;
                ergebnis = this.getM4Db().executeBusinessSqlRead(query);
                double maximum_euklidian_length = 0.0;
                double maximum_frequency = 0.0;
                double euklidian_length = 0.0;
                while (ergebnis.next()) {
                    String colName;
                    int i;
                    String[] werte;
                    int id = ergebnis.getInt(key);
                    if (!indexes.containsKey(new Integer(id))) {
                        Vector<String[]> liste = new Vector<String[]>();
                        werte = new String[features.length];
                        i = 0;
                        while (i < features.length) {
                            try {
                                colName = ((BaseAttribute)features[i]).getCurrentColumn().getName();
                                werte[i] = ergebnis.getString(colName);
                            }
                            catch (M4Exception e) {
                                throw new M4CompilerError("M4Exception during EvaluateAdvantageOfTFIDFTransformation.createStatement:\n" + e.getMessage());
                            }
                            ++i;
                        }
                        liste.add(werte);
                        indexes.put(new Integer(id), liste);
                        continue;
                    }
                    Vector werteListe = (Vector)indexes.get(new Integer(id));
                    werte = new String[features.length];
                    i = 0;
                    while (i < features.length) {
                        try {
                            colName = ((BaseAttribute)features[i]).getCurrentColumn().getName();
                            werte[i] = ergebnis.getString(colName);
                        }
                        catch (M4Exception e) {
                            throw new M4CompilerError("M4Exception during EvaluateAdvantageOfTFIDFTransformation.createStatement:\n" + e.getMessage());
                        }
                        ++i;
                    }
                    werteListe.add(werte);
                }
                ergebnis.close();
                Enumeration e = indexes.keys();
                while (e.hasMoreElements()) {
                    Integer index = (Integer)e.nextElement();
                    Vector aktuell = (Vector)indexes.get(index);
                    int[] frequencies = new int[features.length];
                    if (aktuell.size() <= 1) continue;
                    int i = 1;
                    while (i < aktuell.size()) {
                        String[] currentValues = (String[])aktuell.get(i);
                        String[] previousValues = (String[])aktuell.get(i - 1);
                        int j = 0;
                        while (j < features.length) {
                            if (!currentValues[j].equals(previousValues[j])) {
                                int n = j;
                                frequencies[n] = frequencies[n] + 1;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    double sum = 0.0;
                    int i2 = 0;
                    while (i2 < features.length) {
                        sum += Math.pow(frequencies[i2], 2.0);
                        if ((double)frequencies[i2] > maximum_frequency) {
                            maximum_frequency = frequencies[i2];
                        }
                        ++i2;
                    }
                    euklidian_length = Math.sqrt(sum);
                    if (!(euklidian_length > maximum_euklidian_length)) continue;
                    maximum_euklidian_length = euklidian_length;
                }
                int n = features.length;
                double nm = Math.sqrt(new Integer(n).doubleValue()) * maximum_frequency;
                if (maximum_euklidian_length < nm) {
                    this.doPrint(11, "The maximum Euklidian length is: " + maximum_euklidian_length + "\n" + "The maximum frequency is: " + maximum_frequency + "\n" + "As " + maximum_euklidian_length + " is < sqrt(" + n + ") * " + maximum_frequency + " the transformation into TF/IDF features is worth a try!");
                    System.out.println("The maximum Euklidian length is: " + maximum_euklidian_length + "\n" + "The maximum frequency is: " + maximum_frequency + "\n" + "As " + maximum_euklidian_length + " is < sqrt(" + n + ") * " + maximum_frequency + " the transformation into TF/IDF features is worth a try!");
                } else {
                    this.doPrint(11, "The maximum Euklidian length is: " + maximum_euklidian_length + "\n" + "The maximum frequency is: " + maximum_frequency + "\n" + "As " + maximum_euklidian_length + " is > sqrt(" + n + ") * " + maximum_frequency + " the transformation into TF/IDF features has little chances of success!");
                    System.out.println("The maximum Euklidian length is: " + maximum_euklidian_length + "\n" + "The maximum frequency is: " + maximum_frequency + "\n" + "As " + maximum_euklidian_length + " is > sqrt(" + n + ") * " + maximum_frequency + " the transformation into TF/IDF features has little chances of success!");
                }
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("EvaluateAdvantageOFTFIDFTransformation: an error occurred: " + sqle.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var24_36 = null;
            DB.closeResultSet(ergebnis);
            throw throwable;
        }
        Object var24_37 = null;
        DB.closeResultSet(ergebnis);
    }

    public void compileStatement() throws SQLException, M4CompilerError {
    }

    public void writeResults() throws SQLException, M4CompilerError {
    }

    public Concept getInputConcept() {
        return (Concept)this.getSingleParameter("TheInputConcept");
    }

    public BaseAttribute getTheTimeStamp() {
        return (BaseAttribute)this.getSingleParameter("TheTimeStamp");
    }

    public BaseAttribute getTheKey() {
        return (BaseAttribute)this.getSingleParameter("TheKey");
    }

    protected Feature[] getTheSelectedAttributes() throws M4CompilerError {
        return (Feature[])this.getParameter("TheSelectedAttributes");
    }
}

