/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Value;
import miningmart.compiler.operator.FeatureConstruction;

public class DateToNumeric
extends FeatureConstruction {
    private static String[][] dateFormatsMapping = new String[][]{{"Year_YYYY", "YYYY"}, {"Year_YY", "YY"}, {"Month_of_Year", "MM"}, {"Day_of_Month", "DD"}, {"Hour_of_Day", "HH24"}, {"Minute_of_Hour", "MI"}, {"Second_of_Minute", "SS"}};

    public String generateSQL(Column targetColumn) throws M4CompilerError {
        String format = this.getOutputFormat();
        String sql = targetColumn.getSQLDefinition();
        return "TO_NUMBER(TO_CHAR(" + sql + ", '" + this.getFormatMapping(format) + "'))";
    }

    private String getFormatMapping(String format) throws M4CompilerError {
        if (format != null) {
            int i = 0;
            while (i < dateFormatsMapping.length) {
                if (format.equalsIgnoreCase(dateFormatsMapping[i][0])) {
                    return dateFormatsMapping[i][1];
                }
                ++i;
            }
        }
        throw new M4CompilerError("Operator 'DateToNumeric': Unsupported entry found in mandatory parameter 'OutputFormat': " + (format == null ? "<null>" : "'" + format + "'"));
    }

    private String getOutputFormat() {
        Value value = (Value)this.getSingleParameter("OutputFormat", this.getCurrentLoopNumber());
        if (value == null) {
            return null;
        }
        return value.getValue();
    }
}

