/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

public class Print
implements Serializable {
    private static final String MLHOME = "ML_HOME";
    private static final String LOGFILES = "LOG_FILES";
    public static final int MAX = 11;
    public static final int COMPILER_CASE_CONTROL = 10;
    public static final int COMPILER_STEP_CONTROL = 9;
    public static final int COMPILER_OP_CONTROL = 8;
    public static final int OPERATOR = 7;
    public static final int PARAM = 5;
    public static final int M4_OBJECT = 4;
    public static final int CACHE = 6;
    public static final int DB_WRITE = 3;
    public static final int DB_READ = 2;
    public static final int HELP = 1;
    public static final int MIN = 0;
    private static final String[] levelNameMapping = new String[]{"Min", "Help", "DB Read", "DB Write", "M4 Objects", "Parameters", "M4 Cache", "Operator", "Compiler Operator Control", "Compiler Step Control", "Compiler Case Control", "Max"};
    private static final int DEFAULT_VERBOSITY = 11;
    private static final int LINESIZE = 500;
    private FileWriter file;
    private String fileName;
    private int currVerbosity;
    private final boolean onlyOneLevel = false;
    private static Print theDefaultPrintObject = null;

    private Print() {
        this.getFileWriter();
        String defVerbProperty = System.getProperty("PRINT_VERBOSITY");
        if (defVerbProperty != null && defVerbProperty.length() > 0) {
            int vb;
            try {
                vb = Integer.parseInt(defVerbProperty);
            }
            catch (NumberFormatException e) {
                System.err.println("Warning: System property 'PRINT_VERBOSITY' set to '" + defVerbProperty + "'.\nCould not parse this value to integer!\n" + "Using default verbosity " + 11 + " instead.");
                vb = 11;
            }
            this.currVerbosity = vb;
        } else {
            this.currVerbosity = 11;
        }
    }

    private Print(int verbosity) {
        this.getFileWriter();
        this.currVerbosity = verbosity;
    }

    private Print(long caseId) throws IOException {
        this(caseId, 11);
    }

    private Print(long caseId, int verbosity) throws IOException {
        this.fileName = this.getFileNameForCase(caseId);
        this.file = new FileWriter(this.fileName);
        this.printToFile("*** Case specific log for case with Id " + caseId + " ***\n");
        this.currVerbosity = verbosity;
    }

    public static Print getGlobalPrintObject() {
        if (theDefaultPrintObject == null) {
            theDefaultPrintObject = new Print();
        }
        return theDefaultPrintObject;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameForCase(long caseId) {
        return this.getFileName();
    }

    private void getFileWriter() {
        String logFileProperty = System.getProperty(LOGFILES);
        if (logFileProperty != null) {
            this.fileName = logFileProperty;
            try {
                File f = new File(this.fileName);
                if (f.isDirectory()) {
                    if (!this.fileName.endsWith(File.separator)) {
                        this.fileName = String.valueOf(this.fileName) + File.separator;
                    }
                    this.fileName = String.valueOf(this.fileName) + "logMM.log";
                    f = new File(this.fileName);
                }
                if (f.exists()) {
                    f.delete();
                }
                f.createNewFile();
                this.file = new FileWriter(f);
            }
            catch (IOException ioe) {
                System.out.println("Warning: System property 'LOG_FILES' set to '" + logFileProperty + "'.\nCould not open or create File with this name (I/O-Exception: " + ioe.getMessage() + ").\nUsing standard output for log messages instead.");
                this.file = null;
                this.fileName = "<stdout>";
            }
        } else {
            System.out.println("Warning: System property 'LOG_FILES' not set. Using standard output for log messages.");
            this.file = null;
            this.fileName = "<stdout>";
        }
    }

    private void printToStdout(String line) {
        System.out.println(line);
    }

    private void printToFile(String line) {
        try {
            this.file.write(String.valueOf(line) + "\n");
            this.file.flush();
        }
        catch (IOException e) {
            System.err.println("\nCould not write to logfile " + this.fileName + " !");
            System.err.println("\nException is:\n" + e.getMessage());
            this.printToStdout(line);
        }
    }

    private void doPrint(String printString) {
        if (printString == null) {
            printString = "<null>";
        }
        int length = printString.length();
        int i = 0;
        while (i < length) {
            int end = i + 500;
            if (end > length) {
                end = length;
            }
            String oneLine = printString.substring(i, end);
            if (this.file == null) {
                this.printToStdout(oneLine);
            } else {
                this.printToFile(oneLine);
            }
            i += 500;
        }
    }

    public void doPrint(int verbosity, String printString) {
        if (verbosity >= this.currVerbosity) {
            this.doPrint(printString);
        }
    }

    public void doPrint(Exception ex) {
        this.doPrint(11, ex.getMessage());
    }

    public void setMinimumVerbosityLevel(int newLevel) {
        if (newLevel <= 0) {
            newLevel = 0;
        }
        this.currVerbosity = newLevel;
    }

    public static String getNameOfVerbosityLevel(int verbosity) {
        return levelNameMapping[verbosity];
    }

    public static Collection getAllVerbosityLevelNames(int minVerbosity) {
        Vector<String> names = new Vector<String>();
        int i = 11;
        while (i >= minVerbosity) {
            if (!levelNameMapping[i].equals("")) {
                names.add(levelNameMapping[i]);
            }
            --i;
        }
        names.trimToSize();
        return names;
    }

    public static int getVerbosityLevelForName(String nameOfLevel) {
        int i = 0;
        while (i <= 11) {
            if (levelNameMapping[i].equals(nameOfLevel)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

