/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.utils;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Chain;
import edu.udo.miningmart.m4.core.GraphicalM4Object;
import edu.udo.miningmart.m4.core.M4Object;
import edu.udo.miningmart.m4.core.Relation;
import edu.udo.miningmart.m4.utils.CoordinatesContext;
import edu.udo.miningmart.m4.utils.Print;
import java.awt.Point;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Coordinates
implements Serializable {
    public static final String NAME_SEPARATOR = "_";
    public static final String M4_TABLE_NAME = "hci_coord_t";
    public static final String ATTRIB_OBJECT_ID = "obj_id";
    public static final String ATTRIB_OBJECT_NAME = "obj_name";
    public static final String ATTRIB_OBJECT_TYPE = "obj_type";
    public static final String ATTRIB_CONTEXT_ID = "context_id";
    public static final String ATTRIB_CONTEXT_NAME = "context_name";
    public static final String ATTRIB_CONTEXT_TYPE = "context_type";
    public static final String ATTRIB_X_COORD = "x";
    public static final String ATTRIB_Y_COORD = "y";
    private final GraphicalM4Object myObject;
    private Collection theContextObjects;
    private final DB myM4db;
    private boolean isDirty = false;
    private static final Class[] objectTypes;
    private static final String[] objectDB_Names;
    private static final Class[] contextTypes;
    private static final String[] contextDB_Names;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class[] classArray = new Class[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Chain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("edu.udo.miningmart.m4.core.Relation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Concept");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("edu.udo.miningmart.m4.core.Step");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        objectTypes = classArray;
        objectDB_Names = new String[]{"CH", "REL", "CON", "ST"};
        Class[] classArray2 = new Class[2];
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("edu.udo.miningmart.m4.core.Chain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz5;
        Class<?> clazz6 = class$2;
        if (clazz6 == null) {
            try {
                clazz6 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Concept");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz6;
        contextTypes = classArray2;
        contextDB_Names = new String[]{"CH", "CON"};
    }

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public Coordinates(DB db, GraphicalM4Object theGraphObject) throws M4Exception {
        this(db, theGraphObject, true);
    }

    public Coordinates(DB db, GraphicalM4Object theGraphObject, boolean load) throws M4Exception {
        this.myM4db = db;
        this.myObject = theGraphObject;
        this.theContextObjects = new Vector();
        if (load) {
            try {
                this.readFromDb();
            }
            catch (M4Exception e) {
                Print print = db.getCasePrintObject();
                print.doPrint(11, "Warning: Could not load coordinates for graphical object:\n" + e.getMessage());
            }
        } else {
            this.setDirty();
        }
    }

    public void setDirty() {
        this.isDirty = true;
        GraphicalM4Object gmo = this.getM4Object();
        if (gmo != null) {
            gmo.setCoordinatesDirty();
        }
    }

    private void setClean() {
        this.isDirty = false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void addContextObject(CoordinatesContext context) {
        if (context != null) {
            this.theContextObjects.add(context);
        }
    }

    private void addContextObjectEnsureUniqueness(CoordinatesContext context) {
        if (context != null) {
            Iterator it = this.theContextObjects.iterator();
            while (it.hasNext()) {
                CoordinatesContext cc = (CoordinatesContext)it.next();
                if ((cc.getContextObject() != null || context.getContextObject() != null) && (cc.getContextObject() == null || context.getContextObject() == null || !cc.getContextObject().equals(context.getContextObject()))) continue;
                return;
            }
            this.theContextObjects.add(context);
        }
    }

    private void setContextObjects(Collection contextObjects) {
        this.theContextObjects.clear();
        if (contextObjects != null) {
            Iterator it = contextObjects.iterator();
            while (it.hasNext()) {
                this.addContextObjectEnsureUniqueness((CoordinatesContext)it.next());
            }
        }
    }

    private GraphicalM4Object getM4Object() {
        return this.myObject;
    }

    public Collection getContextObjects() {
        return this.theContextObjects;
    }

    public void changeM4ObjectName(String name) {
        Iterator it = this.theContextObjects.iterator();
        while (it.hasNext()) {
            String oldName;
            int index;
            CoordinatesContext cc = (CoordinatesContext)it.next();
            String newName = name;
            if (this.getM4Object() instanceof Relation && (index = (oldName = cc.getName()).indexOf(NAME_SEPARATOR)) > -1) {
                String suffix = oldName.substring(index + 1);
                newName = String.valueOf(name) + NAME_SEPARATOR + suffix;
            }
            cc.setName(newName);
        }
    }

    public Point getLocationForContext(GraphicalM4Object contextObject) throws M4Exception {
        return this.getLocationUsingName(this.bugWorkaroundGetName(this.getM4Object()), contextObject);
    }

    public Collection getAllLocations() throws M4Exception {
        Collection matchingContexts = this.findContexts(null, this.bugWorkaroundGetName(this.getM4Object()));
        Vector<Point> theLocations = new Vector<Point>();
        Iterator it = matchingContexts.iterator();
        while (it.hasNext()) {
            CoordinatesContext c = (CoordinatesContext)it.next();
            theLocations.add(c.getLocation());
        }
        return theLocations;
    }

    public Point getLocationWithoutContext() throws M4Exception {
        return this.getLocationUsingName(this.bugWorkaroundGetName(this.getM4Object()), null);
    }

    public Point getLocationUsingName(String theName, GraphicalM4Object theContextObject) throws M4Exception {
        if (theName == null) {
            theName = "";
        }
        this.checkContextType(theContextObject);
        Collection matchingContexts = this.findContexts(theContextObject, theName);
        if (matchingContexts.isEmpty()) {
            return null;
        }
        if (matchingContexts.size() > 1) {
            this.getM4Object().doPrint(4, "Found more than one context for the coordinates of M4 object '" + this.bugWorkaroundGetName(this.getM4Object()) + "' (Id: " + this.getM4Object().getId() + "), in the context of '" + this.bugWorkaroundGetName(theContextObject) + "' and the name '" + theName + "'!");
        }
        CoordinatesContext contxt = (CoordinatesContext)matchingContexts.iterator().next();
        return contxt.getLocation();
    }

    public Map getLocationsForContext(GraphicalM4Object theContextObject) throws M4Exception {
        Collection matchingContexts = this.findContexts(theContextObject, this.bugWorkaroundGetName(this.getM4Object()));
        HashMap allPoints = new HashMap();
        Iterator it = matchingContexts.iterator();
        while (it.hasNext()) {
            CoordinatesContext c = (CoordinatesContext)it.next();
            GraphicalM4Object conObj = c.getContextObject();
            this.addToMap(ATTRIB_OBJECT_ID, new BigDecimal((double)this.getM4Object().getId()), allPoints);
            this.addToMap(ATTRIB_OBJECT_NAME, this.bugWorkaroundGetName(this.getM4Object()), allPoints);
            this.addToMap(ATTRIB_OBJECT_TYPE, this.checkObjectType(this.myObject), allPoints);
            if (conObj != null) {
                this.addToMap(ATTRIB_CONTEXT_ID, new BigDecimal((double)conObj.getId()), allPoints);
                this.addToMap(ATTRIB_CONTEXT_NAME, this.bugWorkaroundGetName(conObj), allPoints);
                this.addToMap(ATTRIB_CONTEXT_TYPE, this.checkContextType(conObj), allPoints);
            } else {
                this.addToMap(ATTRIB_CONTEXT_ID, null, allPoints);
                this.addToMap(ATTRIB_CONTEXT_NAME, null, allPoints);
                this.addToMap(ATTRIB_CONTEXT_TYPE, null, allPoints);
            }
            this.addToMap(ATTRIB_X_COORD, new BigDecimal((double)c.getLocation().x), allPoints);
            this.addToMap(ATTRIB_Y_COORD, new BigDecimal((double)c.getLocation().y), allPoints);
        }
        return allPoints;
    }

    public Point getLocationFromMap(GraphicalM4Object theContextObject, Map theMap) throws M4Exception {
        return this.getLocationFromMapUsingName(this.bugWorkaroundGetName(this.getM4Object()), theContextObject, theMap);
    }

    public Point getLocationFromMapUsingName(String theName, GraphicalM4Object theContextObject, Map theMap) throws M4Exception {
        if (theMap == null) {
            throw new M4Exception("Coordinates.getLocationFromMapUsingName: got a <null> Map!");
        }
        if (theMap.isEmpty()) {
            return null;
        }
        List theObjIds = (List)theMap.get(ATTRIB_OBJECT_ID);
        List theObjNames = (List)theMap.get(ATTRIB_OBJECT_NAME);
        List theContextIds = (List)theMap.get(ATTRIB_CONTEXT_ID);
        List theContextNames = (List)theMap.get(ATTRIB_CONTEXT_NAME);
        List theX_Coords = (List)theMap.get(ATTRIB_X_COORD);
        List theY_Coords = (List)theMap.get(ATTRIB_Y_COORD);
        Point theLocation = null;
        Iterator it = theObjIds.iterator();
        int index = 0;
        while (it.hasNext()) {
            long anObjId = ((BigDecimal)it.next()).longValue();
            String anObjName = (String)theObjNames.get(index);
            long aContId = ((BigDecimal)theContextIds.get(index)).longValue();
            String aContName = (String)theContextNames.get(index);
            if (anObjId == this.getM4Object().getId() && anObjName.equals(theName) && aContId == theContextObject.getId() && aContName.equals(this.bugWorkaroundGetName(theContextObject))) {
                int theX = ((BigDecimal)theX_Coords.get(index)).intValue();
                int theY = ((BigDecimal)theY_Coords.get(index)).intValue();
                theLocation = new Point(theX, theY);
            }
            ++index;
        }
        return theLocation;
    }

    public void setLocation(GraphicalM4Object theContextObject, Point theLocation) throws M4Exception {
        this.setLocationUsingName(this.bugWorkaroundGetName(this.getM4Object()), theContextObject, theLocation);
    }

    public void setLocationUsingName(String theName, GraphicalM4Object theContextObject, Point theLocation) throws M4Exception {
        if (theName == null) {
            theName = "";
        }
        this.checkContextType(theContextObject);
        Collection matchingContexts = this.findContexts(theContextObject, theName);
        if (matchingContexts.isEmpty()) {
            CoordinatesContext contxt = new CoordinatesContext(this.getM4Object());
            contxt.setContextObject(theContextObject);
            contxt.setLocation(theLocation);
            contxt.setName(theName);
            this.addContextObjectEnsureUniqueness(contxt);
        } else {
            if (matchingContexts.size() > 1) {
                this.getM4Object().doPrint(4, "Found more than one context for the coordinates of M4 object '" + this.bugWorkaroundGetName(this.getM4Object()) + "' (Id: " + this.getM4Object().getId() + "), in the context of '" + this.bugWorkaroundGetName(theContextObject) + "' and the name '" + theName + "'!");
            }
            CoordinatesContext contxt = (CoordinatesContext)matchingContexts.iterator().next();
            contxt.setLocation(theLocation);
            contxt.setContextObject(theContextObject);
            contxt.setName(theName);
        }
        this.setDirty();
    }

    public void removePointsInContext(M4Object theContextObject) throws M4Exception {
        this.removePointsInContextUsingName(this.bugWorkaroundGetName(this.getM4Object()), theContextObject);
    }

    public void removePointsInContextUsingName(String theName, M4Object theContextObject) throws M4Exception {
        if (theName == null) {
            theName = "";
        }
        this.checkContextType(theContextObject);
        Vector<CoordinatesContext> newContextList = new Vector<CoordinatesContext>();
        Iterator it = this.getContextObjects().iterator();
        while (it.hasNext()) {
            CoordinatesContext c = (CoordinatesContext)it.next();
            if (c.getName().equals(theName) && (c.getContextObject() == null && theContextObject == null || c.getContextObject() != null && c.getContextObject().equals(theContextObject))) continue;
            newContextList.add(c);
        }
        this.setContextObjects(newContextList);
        this.setDirty();
    }

    public void removeAllPoints() {
        this.setContextObjects(null);
        this.setDirty();
    }

    public void delete() throws M4Exception {
        this.deleteDbTuples();
        this.removeAllPoints();
        this.setClean();
    }

    public void store() throws M4Exception {
        this.deleteDbTuples();
        Iterator it = this.getContextObjects().iterator();
        Vector<GraphicalM4Object> writtenContexts = new Vector<GraphicalM4Object>();
        while (it.hasNext()) {
            CoordinatesContext c = (CoordinatesContext)it.next();
            GraphicalM4Object contextObj = c.getContextObject();
            if (contextObj != null) {
                if (writtenContexts.contains(contextObj)) continue;
                writtenContexts.add(contextObj);
            }
            String query = "INSERT INTO hci_coord_t VALUES (" + this.getM4Object().getId() + ", '" + this.bugWorkaroundGetName(this.getM4Object()) + "', '" + this.checkObjectType(this.myObject) + "', ";
            query = contextObj != null ? String.valueOf(query) + contextObj.getId() + ", '" + this.bugWorkaroundGetName(contextObj) + "', '" + this.checkContextType(contextObj) + "', " : String.valueOf(query) + " NULL, NULL, NULL, ";
            query = String.valueOf(query) + c.getLocation().x + ", " + c.getLocation().y + ")";
            try {
                this.myM4db.executeM4SqlWrite(query);
            }
            catch (SQLException sqle) {
                throw new M4Exception(String.valueOf(this.createErrorMsgPrefix()) + sqle.getMessage());
            }
            catch (DbConnectionClosed d) {
                throw new M4Exception(String.valueOf(this.createErrorMsgPrefix()) + d.getMessage());
            }
        }
        this.setClean();
    }

    private void deleteDbTuples() throws M4Exception {
        String query = "DELETE FROM hci_coord_t WHERE obj_id = " + this.getM4Object().getId();
        try {
            this.myM4db.executeM4SqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception(String.valueOf(this.createErrorMsgPrefix()) + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception(String.valueOf(this.createErrorMsgPrefix()) + d.getMessage());
        }
    }

    private String createErrorMsgPrefix() {
        return "SQL Error when deleting coordinates of M4 object (Id: " + this.getM4Object().getId() + ", Name: " + this.bugWorkaroundGetName(this.getM4Object()) + "): ";
    }

    private void addToMap(String key, Object oneValueForTheKey, Map theMap) {
        ArrayList<Object> theListOfValuesForThisKey = (ArrayList<Object>)theMap.get(key);
        if (theListOfValuesForThisKey == null) {
            theListOfValuesForThisKey = new ArrayList<Object>();
            theMap.put(key, theListOfValuesForThisKey);
        }
        theListOfValuesForThisKey.add(oneValueForTheKey);
    }

    private Collection findContexts(GraphicalM4Object contextObj, String name) {
        Vector<CoordinatesContext> theMatchingContexts = new Vector<CoordinatesContext>();
        Iterator it = this.getContextObjects().iterator();
        while (it.hasNext()) {
            CoordinatesContext c = (CoordinatesContext)it.next();
            if (!c.getName().equals(name)) continue;
            if (contextObj == null && c.getContextObject() == null) {
                theMatchingContexts.add(c);
            }
            if (contextObj == null || c.getContextObject() == null || !c.getContextObject().equals(contextObj)) continue;
            theMatchingContexts.add(c);
        }
        return theMatchingContexts;
    }

    private Class getClassForContextType(String dbStringConstant) {
        if (dbStringConstant == null) {
            return null;
        }
        int i = 0;
        while (i < contextDB_Names.length) {
            if (contextDB_Names[i].equals(dbStringConstant)) {
                return contextTypes[i];
            }
            ++i;
        }
        return null;
    }

    private void readFromDb() throws M4Exception {
        String attributes = "obj_name, context_id, y, x, context_type";
        String query = "SELECT " + attributes + " FROM " + this.getM4TableName() + " WHERE " + ATTRIB_OBJECT_ID + " = " + this.myObject.getId();
        String error = "SQL Error when retrieving coordinates of M4 object (Id: " + this.getM4Object().getId() + ", Name: " + this.bugWorkaroundGetName(this.getM4Object()) + "): ";
        ResultSet rs = null;
        DB db = this.myM4db;
        try {
            try {
                rs = db.executeM4SqlRead(query);
                while (rs.next()) {
                    CoordinatesContext c = new CoordinatesContext(this.getM4Object());
                    String objectName = rs.getString(ATTRIB_OBJECT_NAME);
                    int xCoord = rs.getInt(ATTRIB_X_COORD);
                    int yCoord = rs.getInt(ATTRIB_Y_COORD);
                    c.setName(objectName);
                    Point p = new Point(xCoord, yCoord);
                    c.setLocation(p);
                    long contextId = rs.getLong(ATTRIB_CONTEXT_ID);
                    if (rs.wasNull()) continue;
                    String contextType = rs.getString(ATTRIB_CONTEXT_TYPE);
                    Class contextClass = this.getClassForContextType(contextType);
                    if (contextClass == null) {
                        throw new M4Exception("Error in Coordinates.readFromDb(): unknown context type found for M4 object " + this.getM4Object().getId() + " in table " + M4_TABLE_NAME);
                    }
                    M4Object aContxtObj = db.getM4Object(contextId, contextClass);
                    c.setContextObject((GraphicalM4Object)aContxtObj);
                    this.addContextObjectEnsureUniqueness(c);
                }
            }
            catch (SQLException sqle) {
                throw new M4Exception(String.valueOf(error) + sqle.getMessage());
            }
            catch (DbConnectionClosed d) {
                throw new M4Exception(String.valueOf(error) + d.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var16_19 = null;
        DB.closeResultSet(rs);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String checkObjectType(M4Object theObject) throws M4Exception {
        Class<?> clazz;
        if (theObject == null) {
            throw new M4Exception("Error when storing/retrieving coordinates of an M4 object: got NULL object for primary key!");
        }
        Class<?> type = theObject.getClass();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                type = type.getSuperclass();
            }
            if ((clazz = class$4) != null) continue;
            try {
                clazz = Class.forName("miningmart.m4.M4Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz.isAssignableFrom(type));
        int i = 0;
        while (i < objectTypes.length) {
            if (objectTypes[i].isAssignableFrom(type)) {
                return objectDB_Names[i];
            }
            ++i;
        }
        throw new M4Exception("Error when storing/retrieving coordinates of M4 object (Id: " + this.getM4Object().getId() + ", Name: " + this.bugWorkaroundGetName(this.getM4Object()) + "): wrong object type!: " + type);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String checkContextType(M4Object theContext) throws M4Exception {
        Class<?> clazz;
        if (theContext == null) {
            return null;
        }
        Class<?> type = theContext.getClass();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                type = type.getSuperclass();
            }
            if ((clazz = class$4) != null) continue;
            try {
                clazz = Class.forName("miningmart.m4.M4Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz.isAssignableFrom(type));
        int i = 0;
        while (i < contextTypes.length) {
            if (contextTypes[i].isAssignableFrom(type)) {
                return contextDB_Names[i];
            }
            ++i;
        }
        throw new M4Exception("Error when storing/retrieving coordinates of M4 object (Id: " + this.getM4Object().getId() + ", Name: " + this.bugWorkaroundGetName(this.getM4Object()) + "): wrong context type!: " + type);
    }

    private String bugWorkaroundGetName(GraphicalM4Object obj) {
        if (obj instanceof Chain) {
            return ((Chain)obj).hciBugWorkAroundGetName();
        }
        return obj.getName();
    }
}

