/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.hciImpl;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Parameter;
import edu.udo.miningmart.m4.hciImpl.ColumnImpl;
import edu.udo.miningmart.m4.hciImpl.ConceptImpl;
import edu.udo.miningmart.m4.hciImpl.MultiColumnFeatureImpl;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Column;
import miningmart.m4.Concept;
import miningmart.m4.CreateException;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.MultipleResultException;
import miningmart.m4.NameExistsException;
import miningmart.m4.Step;
import miningmart.m4.StorageException;

public class BaseAttributeImpl
extends edu.udo.miningmart.m4.core.BaseAttribute
implements BaseAttribute {
    public static final String C_YES = "YES";
    public static final String C_NO = "NO";

    public BaseAttributeImpl(DB db) {
        super(db);
    }

    public String getDatatype() {
        try {
            return super.getConceptualDataTypeName();
        }
        catch (DbConnectionClosed e) {
            super.doPrint(e);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
        return null;
    }

    public void setDatatype(String type) {
        try {
            super.setConceptualDataTypeName(type);
        }
        catch (DbConnectionClosed e) {
            super.doPrint(e);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public String getRelevance() {
        return super.isRelevant() ? C_YES : C_NO;
    }

    public Column getColumn() throws MultipleResultException {
        Collection col = this.getAllColumns();
        if (col == null || col.size() == 0) {
            return null;
        }
        if (col.size() > 1) {
            throw new MultipleResultException();
        }
        return (Column)col.iterator().next();
    }

    public void setRelevance(String relevance) {
        if (relevance != null) {
            relevance = relevance.trim().toUpperCase();
            super.setRelevant(relevance.equals(C_YES));
        } else {
            super.setRelevant(false);
        }
    }

    public String getAttributeType() {
        if (super.isDBAttrib()) {
            return "DB";
        }
        return "MINING";
    }

    public void setAttributeType(String attributeType) {
        if (attributeType.equals("DB")) {
            super.setDBAttrib(true);
        } else {
            super.setDBAttrib(false);
        }
    }

    public MultiColumnFeature getMultiColumnFeature() {
        return (MultiColumnFeature)((Object)super.getMCFeature());
    }

    public void setMultiColumnFeature(MultiColumnFeature multiColumnFeature) throws StorageException {
        try {
            super.setMCFeature((MultiColumnFeatureImpl)multiColumnFeature);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public void addConcept(Concept concept) {
        try {
            super.setConcept((ConceptImpl)concept);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public Concept getConcept() {
        try {
            return (ConceptImpl)super.getTheConcept();
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public Collection getAllConcepts() {
        try {
            Concept c = (Concept)((Object)super.getTheConcept());
            Vector<Concept> v = new Vector<Concept>();
            if (c != null) {
                v.add(c);
            }
            return v;
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public void removeConcept() throws MultipleResultException {
        try {
            super.setConcept(null);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public void removeAllConcepts() {
        try {
            super.setConcept(null);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public Column getColumn(String name) {
        try {
            Iterator it = super.getColumns().iterator();
            while (it.hasNext()) {
                Column col = (Column)it.next();
                if (!col.getName().equals(name)) continue;
                return col;
            }
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
        return null;
    }

    public Collection getAllColumns() {
        try {
            return super.getColumns();
        }
        catch (M4Exception e) {
            super.doPrint(e);
            return null;
        }
    }

    public void addColumn(Column column) {
        try {
            super.addColumn((ColumnImpl)column);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public void removeColumn(String name) {
        Column col = this.getColumn(name);
        try {
            super.removeColumn((ColumnImpl)col);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public void removeAllColumns() {
        try {
            super.setColumns(new Vector());
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public BaseAttribute copy(Concept newConcept) throws CreateException, NameExistsException, StorageException {
        BaseAttributeImpl theCopy = new BaseAttributeImpl(this.getM4Db());
        try {
            theCopy.setConcept((ConceptImpl)newConcept);
            theCopy.setAttributeType(this.getAttributeType());
            theCopy.setColumns(this.getColumns());
            theCopy.setConceptualDataType(this.getConceptualDataType());
            theCopy.setDatatype(this.getDatatype());
            theCopy.setDBAttrib(this.isDBAttrib());
            theCopy.setFunctionallyValid(this.isFunctionallyValid());
            theCopy.setMCFeature(this.getMCFeature());
            theCopy.setName(this.getName());
            theCopy.setRelevant(this.isRelevant());
        }
        catch (M4Exception m4e) {
            throw new CreateException("Could not create a copy of BA " + this.getId() + ": " + m4e.getMessage());
        }
        return theCopy;
    }

    public boolean isRelationallyValid() {
        try {
            if (this.getTheConcept() == null) {
                return false;
            }
        }
        catch (M4Exception m4e) {
            super.doPrint(11, "Could not check validity of BA " + this.getId() + ": " + m4e.getMessage());
        }
        if (this.isDBAttrib()) {
            Collection columns = this.getAllColumns();
            if (columns == null || columns.isEmpty()) {
                return false;
            }
        } else {
            boolean valid = false;
            Iterator it = null;
            try {
                it = this.getTheConcept().getParameterReferences().iterator();
                while (it.hasNext()) {
                    if (((miningmart.m4.Parameter)it.next()).getParameterType() != "OUT") continue;
                    valid = true;
                }
                if (!valid && this.getMCFeature() != null) {
                    it = this.getMCFeature().getParameterReferences().iterator();
                    while (it.hasNext()) {
                        if (((miningmart.m4.Parameter)it.next()).getParameterType() != "OUT") continue;
                        valid = true;
                    }
                }
                if (!valid) {
                    it = this.getParameterReferences().iterator();
                    while (it.hasNext()) {
                        if (((miningmart.m4.Parameter)it.next()).getParameterType() != "OUT") continue;
                        valid = true;
                    }
                }
                return valid;
            }
            catch (M4Exception m4e) {
                super.doPrint(11, "Could not check validity of BA " + this.getId() + ": " + m4e.getMessage());
            }
        }
        return true;
    }

    public void addParameter(miningmart.m4.Parameter parameter) throws StorageException {
        try {
            super.addParameterReference((Parameter)((Object)parameter));
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public String getName() {
        return super.getName();
    }

    public void setName(String name) {
        super.setName(name);
    }

    public boolean isFunctionallyValid() {
        return false;
    }

    public void setFunctionallyValid(boolean functionallyValid) {
    }

    public miningmart.m4.Parameter getParameter(String stepName, String parameterName) {
        Collection collection = null;
        try {
            collection = super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
        if (collection != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                String parStepName;
                miningmart.m4.Parameter par = (miningmart.m4.Parameter)it.next();
                if (par == null) continue;
                String parName = par.getParameterName();
                Step parStep = par.getStep();
                String string = parStepName = par == null ? null : parStep.getName();
                if (parStepName == null || !parName.equals(parameterName) || !parStepName.equals(stepName)) continue;
                return par;
            }
        }
        return null;
    }

    public Collection getAllParameters() {
        try {
            return super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public Collection getAllInputParameters() {
        Collection c = null;
        try {
            c = super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
        Iterator it = c.iterator();
        Vector<miningmart.m4.Parameter> ret = new Vector<miningmart.m4.Parameter>();
        while (it.hasNext()) {
            miningmart.m4.Parameter par = (miningmart.m4.Parameter)it.next();
            if (!par.getParameterType().equals("IN")) continue;
            ret.add(par);
        }
        return ret;
    }

    public miningmart.m4.Parameter getOutputParameter() throws MultipleResultException {
        Collection c = null;
        try {
            c = super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
        Iterator it = c.iterator();
        Vector<miningmart.m4.Parameter> ret = new Vector<miningmart.m4.Parameter>();
        while (it.hasNext()) {
            miningmart.m4.Parameter par = (miningmart.m4.Parameter)it.next();
            if (!par.getParameterType().equals("OUT")) continue;
            ret.add(par);
        }
        if (ret.size() == 0) {
            return null;
        }
        if (ret.size() > 1) {
            throw new MultipleResultException();
        }
        return (miningmart.m4.Parameter)ret.firstElement();
    }

    public void removeParameter(String stepName, String parameterName) throws StorageException {
        miningmart.m4.Parameter removeMe = this.getParameter(stepName, parameterName);
        if (removeMe != null) {
            try {
                super.removeParameterReference((Parameter)((Object)removeMe));
            }
            catch (M4Exception e) {
                throw new StorageException(e.getMessage());
            }
        }
    }

    public void removeAllParameters() throws StorageException {
        Collection c = null;
        try {
            c = super.getParameterReferences();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
        }
        Iterator it = ((AbstractList)new Vector(c)).iterator();
        while (it.hasNext()) {
            miningmart.m4.Parameter par = (miningmart.m4.Parameter)it.next();
            try {
                super.removeParameterReference((Parameter)((Object)par));
            }
            catch (M4Exception e) {
                throw new StorageException(e.getMessage());
            }
        }
    }

    public void setDocumentation(String text) {
        try {
            super.setDocumentation(text);
        }
        catch (M4Exception e) {
            super.doPrint(e);
        }
    }

    public String getDocumentation() {
        try {
            return super.getDocumentation();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return null;
        }
    }

    public void delete() throws StorageException {
        try {
            super.deleteSoon();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public void store() throws StorageException {
        try {
            super.getM4Db().updateDatabase();
        }
        catch (M4Exception e) {
            throw new StorageException(e.getMessage());
        }
    }

    public boolean isChanged() {
        return super.isDirty();
    }
}

