/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.ParameterError;
import edu.udo.miningmart.exception.ParameterNotFoundException;
import edu.udo.miningmart.m4.core.Case;
import edu.udo.miningmart.m4.core.Chain;
import edu.udo.miningmart.m4.core.GraphicalM4Object;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.core.OpParam;
import edu.udo.miningmart.m4.core.Operator;
import edu.udo.miningmart.m4.core.ParamDict;
import edu.udo.miningmart.m4.core.Parameter;
import edu.udo.miningmart.m4.core.ParameterArray;
import edu.udo.miningmart.m4.utils.HasCrossReferences;
import edu.udo.miningmart.m4.utils.InterM4Communicator;
import edu.udo.miningmart.m4.utils.InterM4StepParameter;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class Step
extends GraphicalM4Object
implements XmlInfo,
HasCrossReferences {
    public static final String M4_TABLE_NAME = "step_t";
    public static final String ATTRIB_STEP_ID = "st_id";
    public static final String ATTRIB_STEP_NAME = "st_name";
    public static final String ATTRIB_CHAIN_ID = "st_chid";
    public static final String ATTRIB_CASE_ID = "st_caid";
    public static final String ATTRIB_OPERATOR_ID = "st_opid";
    public static final String ATTRIB_NUM_OF_LOOPS = "st_loopnr";
    public static final String ATTRIB_STEP_NR = "st_nr";
    public static final String ATTRIB_MULTISTEP_COND = "st_multistepcond";
    public static InterM4Communicator step2par = new InterM4StepParameter();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    public static final String M4_TABLE_NAME_STEPSEQ = "stepsequence_t";
    public static final String ATTRIB_STEPSEQ_DEPENDECY_ID = "sts_id";
    public static final String ATTRIB_STEPSEQ_FROM_STEP = "sts_stid";
    public static final String ATTRIB_STEPSEQ_TO_STEP = "sts_successorstid";
    public static final String DB_TRASH_TABLENAME = "dbtrash_t";
    public static final String ATTRIB_DBT_OBJTYPE = "ObjType";
    public static final String ATTRIB_DBT_OBJNAME = "ObjName";
    public static final String ATTRIB_DBT_SCHEMA = "SchemaName";
    public static final String ATTRIB_DBT_STEPID = "StepId";
    public static final String DBT_TYPE_FUNCTION = "F";
    public static final String DBT_TYPE_VIEW = "V";
    public static final String DBT_TYPE_TABLE = "T";
    public static final String DBT_TYPE_INDEX = "I";
    private Case myCase;
    private Chain myChain;
    private long myNr;
    private int loopCount;
    private String multiStepCondition;
    private Operator myOperator;
    private final HashSet myM4Trash = new HashSet();
    private boolean allM4TrashLoaded = false;
    private final Collection myParameterTuples = new Vector();
    private boolean allParameterTuplesLoaded = false;
    private final Vector dependentSteps = new Vector();
    private boolean allDependentStepsLoaded = false;
    private boolean dependentStepsDirty = false;
    private final Vector myDbTrash = new Vector();
    private boolean dbTrashDirty = false;
    private boolean allDbTrashLoaded = false;
    public static final String M4_TRASH_TABLE = "m4trash_t";
    public static final String M4_TRASH_ID = "m4id";
    public static final String M4_TRASH_OBJ_TABLE = "m4table";
    public static final String M4_TRASH_STEP_ID = "stepid";
    private boolean isCompiled = false;
    private boolean m4trashDirty = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_STEP_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[8];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_STEP_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_STEP_NAME, "getName", "setName", clazz, "NN");
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_STEP_NR, "getNumber", "setNumber", Long.TYPE);
            m4InfoEntryArray[3] = new M4InfoEntry(ATTRIB_NUM_OF_LOOPS, "getLoopCount", "setLoopCount", Integer.TYPE);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry(ATTRIB_MULTISTEP_COND, "getMultiStepCondition", "setMultiStepCondition", clazz2);
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("edu.udo.miningmart.m4.core.Case");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry(ATTRIB_CASE_ID, "getTheCase", "primitiveSetCase", clazz3, "NN");
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("edu.udo.miningmart.m4.core.Chain");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[6] = new M4InfoEntry(ATTRIB_CHAIN_ID, "getTheChain", "primitiveSetChain", clazz4);
            Class<?> clazz5 = class$5;
            if (clazz5 == null) {
                try {
                    clazz5 = class$5 = Class.forName("edu.udo.miningmart.m4.core.Operator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[7] = new M4InfoEntry(ATTRIB_OPERATOR_ID, "getTheOperator", "setTheOperator", clazz5, "NN");
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[9];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("Name", "getName", "setName", clazz);
            m4InfoEntryArray[1] = new M4InfoEntry("Number", "getNumber", "setNumber", Long.TYPE);
            m4InfoEntryArray[2] = new M4InfoEntry("LoopCount", "getLoopCount", "setLoopCount", Integer.TYPE);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry("MultiStepCondition", "getMultiStepCondition", "setMultiStepCondition", clazz2);
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("edu.udo.miningmart.m4.core.Case");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry("Case", "getTheCase", "setTheCase", clazz3);
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("edu.udo.miningmart.m4.core.Chain");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry("Chain", "getTheChain", "setTheChain", clazz4);
            Class<?> clazz5 = class$5;
            if (clazz5 == null) {
                try {
                    clazz5 = class$5 = Class.forName("edu.udo.miningmart.m4.core.Operator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[6] = new M4InfoEntry("Operator", "getTheOperator", "setTheOperator", clazz5);
            Class<?> clazz6 = class$6;
            if (clazz6 == null) {
                try {
                    clazz6 = class$6 = Class.forName("java.util.Collection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[7] = new M4InfoEntry("Successors", "getSuccessors", "setSuccessors", clazz6);
            Class<?> clazz7 = class$1;
            if (clazz7 == null) {
                try {
                    clazz7 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[8] = new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", clazz7);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Step(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        Operator op = null;
        op = this.getTheOperator();
        String opName = op == null ? "<null>" : op.getName();
        this.doPrint(4, "Step (Id = " + this.myId + ";" + "      Operator = " + opName + ";" + "      Loop Count = " + this.getLoopCount() + ";" + "      Multi Step = " + this.getMultiStepCondition() + ")");
        super.print();
    }

    public Operator getTheOperator() {
        return this.myOperator;
    }

    public void setTheOperator(Operator theOp) {
        this.setDirty();
        this.myOperator = theOp;
    }

    public Chain getTheChain() {
        return this.myChain;
    }

    public void setTheChain(Chain chain) throws M4Exception {
        Chain.chain2step.checkNameExists(this, chain);
        Chain.chain2step.updateReferenceTo(this, chain);
    }

    public void primitiveSetChain(Chain chain) {
        this.setDirty();
        this.myChain = chain;
    }

    public long getCaseId() {
        return this.myCase.getId();
    }

    public long getNumber() {
        return this.myNr;
    }

    public void setTheCase(Case myCase) throws M4Exception {
        Case.case2step.checkNameExists(this, myCase);
        Case.case2step.updateReferenceTo(this, myCase);
    }

    public void primitiveSetCase(Case myCase) {
        this.setDirty();
        this.myCase = myCase;
    }

    public void setNumber(long nr) {
        this.setDirty();
        this.myNr = nr;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public String getMultiStepCondition() {
        return this.multiStepCondition;
    }

    public void addParameterTuple(Parameter par) throws M4Exception {
        step2par.checkNameExists(par, this);
        step2par.add(this, par);
    }

    public boolean removeParameterTuple(Parameter par) throws M4Exception {
        return step2par.remove(this, par);
    }

    public void setLoopCount(int lc) {
        this.loopCount = lc;
    }

    public void setMultiStepCondition(String msc) {
        this.setDirty();
        this.multiStepCondition = msc;
    }

    public Case getTheCase() {
        return this.myCase;
    }

    public Collection getParameters() throws M4Exception {
        if (!this.allParameterTuplesLoaded && !this.isNew()) {
            this.allParameterTuplesLoaded = true;
            this.readParameterTuplesFromDB();
        }
        return this.myParameterTuples;
    }

    public Collection getSuccessors() throws M4Exception {
        if (!this.allDependentStepsLoaded && !this.isNew()) {
            this.allDependentStepsLoaded = true;
            this.readSuccessorsFromDb();
        }
        return this.dependentSteps;
    }

    void addSuccessor(Step step) throws M4Exception {
        if (step != null) {
            this.dependentStepsDirty = true;
            this.setDirty();
            this.primitiveAddSuccessor(step);
        }
    }

    void primitiveAddSuccessor(Step step) throws M4Exception {
        if (step != null) {
            this.getSuccessors().add(step);
        }
    }

    boolean removeSuccessor(Step step) throws M4Exception {
        if (step != null) {
            boolean success = this.getSuccessors().remove(step);
            if (success) {
                this.dependentStepsDirty = true;
                this.setDirty();
            }
            return success;
        }
        return false;
    }

    private void readParameterTuplesFromDB() throws M4Exception {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("edu.udo.miningmart.m4.core.Parameter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz).iterator();
        while (it.hasNext()) {
            this.addParameterTuple((Parameter)it.next());
        }
    }

    /*
     * Unable to fully structure code
     */
    public ParamDict readParametersForExecutableFromDB() throws M4Exception {
        pd = new ParamDict();
        it = this.getTheOperator().getOpParamsIterator();
        block4: while (it.hasNext()) {
            block9: {
                op = (OpParam)it.next();
                if (op.getMinArg() == 0) {
                    try {
                        withoutLoop = this.loadParam(op, 0);
                        if (withoutLoop.size() > 0 || this.getLoopCount() <= 0) {
                            pd.put(op.getName(), withoutLoop);
                            continue;
                        }
                        loops = this.getLoopCount() + 1;
                        i = 1;
                        while (i < loops) {
                            obj = this.loadParam(op, i);
                            pd.put(op.getName(), i, obj);
                            ++i;
                        }
                        continue;
                    }
                    catch (ParameterNotFoundException e) {
                        throw new M4Exception("Internal compiler error.'ParameterNotFound' exception was thrown for an optional parameter:\n" + e.getMessage());
                    }
                }
                try {
                    pd.put(op.getName(), this.loadParam(op, 0));
                    continue;
                }
                catch (ParameterNotFoundException e) {
                    if (this.getLoopCount() <= 0) break block9;
                    loops = this.getLoopCount() + 1;
                    i = 1;
                    ** while (i < loops)
                }
lbl-1000:
                // 1 sources

                {
                    obj = this.loadParam(op, i);
                    pd.put(op.getName(), i, obj);
                    ++i;
                    continue;
lbl33:
                    // 1 sources

                    continue block4;
                }
            }
            throw e;
        }
        return pd;
    }

    private ParameterArray loadParam(OpParam op, int loopNr) throws M4Exception {
        ParameterArray ret = null;
        try {
            if (op.getMaxArg() == 1) {
                Parameter obj = this.loadSingleParam(op, loopNr);
                if (obj != null) {
                    ret = new ParameterArray(obj.getParObjectType());
                    ret.addParameter(obj);
                }
            } else {
                ret = this.loadParamArray(op, loopNr);
            }
        }
        catch (ParameterError parameterError) {
            // empty catch block
        }
        if (ret == null) {
            if (op.getMinArg() > 0) {
                this.throwParameterLoadException(loopNr, String.valueOf(op.getName()) + " not found.");
            } else {
                ret = new ParameterArray(op.getType());
            }
        } else {
            if (ret.size() < op.getMinArg()) {
                this.throwParameterLoadException(loopNr, String.valueOf(op.getName()) + " should be an Array of at least " + op.getMinArg() + " entries, but has only " + ret.size() + " elements!");
            }
            if (op.getMaxArg() >= 0 && ret.size() > op.getMaxArg()) {
                this.throwParameterLoadException(loopNr, String.valueOf(op.getName()) + " should be an Array of at most " + op.getMinArg() + " entries, but has " + ret.size() + " elements!");
            }
        }
        return ret;
    }

    private void throwParameterLoadException(int loopNr, String restOfMessage) throws M4Exception {
        String message = "Could not load parameters for operator " + this.getTheOperator().getName() + " in step " + this.getId();
        if (loopNr > 0) {
            message = String.valueOf(message) + ", loop nr." + loopNr;
        }
        message = String.valueOf(message) + " !\nParameter " + restOfMessage;
        throw new ParameterNotFoundException(message);
    }

    private Parameter loadSingleParam(OpParam op, int loopNr) throws M4Exception {
        String query = this.createLoadParamQuery(op, loopNr);
        Long parId = this.executeM4SingleValueSqlReadL(query);
        if (parId == null) {
            return null;
        }
        DB db = this.getM4Db();
        long l = parId;
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("edu.udo.miningmart.m4.core.Parameter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Parameter)db.getM4Object(l, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParameterArray loadParamArray(OpParam op, int loopNr) throws M4Exception {
        ResultSet rs = null;
        try {
            try {
                String query = this.createLoadParamQuery(op, loopNr);
                rs = this.executeM4SqlRead(query);
                Vector<Long> parIds = new Vector<Long>();
                while (rs.next()) {
                    parIds.add(new Long(rs.getLong(1)));
                }
                parIds.trimToSize();
                DB db = this.getM4Db();
                ParameterArray ret = new ParameterArray(op.getType());
                Iterator it = ((AbstractList)parIds).iterator();
                while (it.hasNext()) {
                    long parId = (Long)it.next();
                    Class<?> clazz = class$7;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("edu.udo.miningmart.m4.core.Parameter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Parameter p = (Parameter)db.getM4Object(parId, clazz);
                    ret.addParameter(p);
                }
                ParameterArray parameterArray = ret;
                Object var12_13 = null;
                DB.closeResultSet(rs);
                return parameterArray;
            }
            catch (SQLException sqle) {
                throw new M4Exception("SQL error when loading ParameterArray for Step " + this.getId() + ": " + sqle.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
    }

    private String createLoadParamQuery(OpParam op, int loopNr) {
        String parName = op.getName();
        String LoopCondition = loopNr == 0 ? "(par_stloopnr IS NULL OR par_stloopnr = 0)" : "par_stloopnr = " + loopNr;
        String query = "SELECT par_id FROM parameter_t WHERE par_stid = " + this.getId() + " AND " + LoopCondition + " AND " + DB.attribPrefix("par_name", parName) + " = " + DB.quote(parName);
        return query;
    }

    private void readSuccessorsFromDb() throws M4Exception {
        String query = "SELECT sts_successorstid FROM stepsequence_t WHERE sts_stid = " + this.getId();
        ResultSet rs = null;
        try {
            try {
                rs = this.executeM4SqlRead(query);
                DB db = this.getM4Db();
                while (rs.next()) {
                    long successorId = rs.getLong(1);
                    if (rs.wasNull()) continue;
                    Class<?> clazz = class$8;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("edu.udo.miningmart.m4.core.Step");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Step step = (Step)db.getM4Object(successorId, clazz);
                    this.primitiveAddSuccessor(step);
                }
            }
            catch (SQLException sqle) {
                throw new M4Exception("SQL error when reading step sequence for case with Id " + this.getId() + ": " + sqle.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var7_9 = null;
        DB.closeResultSet(rs);
    }

    public Collection getCrossReferences() throws M4Exception {
        return this.getSuccessors();
    }

    protected boolean hasCoordinates() {
        return true;
    }

    protected void storeLocal() throws M4Exception {
        super.storeLocal();
        if (this.dependentStepsDirty) {
            String sql = "DELETE FROM stepsequence_t WHERE sts_stid = " + this.getId();
            this.executeM4SqlWrite(sql);
            Iterator it = this.getSuccessors().iterator();
            String prefix = "INSERT INTO stepsequence_t ( sts_id, sts_stid, sts_successorstid ) VALUES ( ";
            while (it.hasNext()) {
                Step successor = (Step)it.next();
                String sql2 = String.valueOf(prefix) + this.getNextM4SequenceValue() + ", " + this.getId() + ", " + successor.getId() + " )";
                this.executeM4SqlWrite(sql2);
            }
        }
        this.writeM4TrashToDb();
        this.writeDbTrashToDb();
    }

    protected void setSuccessors(Collection newSuccessors) throws M4Exception {
        Iterator it = ((AbstractList)new Vector(this.getSuccessors())).iterator();
        while (it.hasNext()) {
            this.removeSuccessor((Step)it.next());
        }
        if (newSuccessors == null || newSuccessors.isEmpty()) {
            return;
        }
        Case theCase = this.getTheCase();
        if (theCase != null) {
            it = newSuccessors.iterator();
            while (it.hasNext()) {
                theCase.addStepDependency(this, (Step)it.next());
            }
        } else {
            this.getSuccessors().addAll(newSuccessors);
        }
    }

    protected void removeAllM4References() throws M4Exception {
        this.deleteM4Trash();
        this.deleteDbTrash();
        this.removeAllSuccessorsDuringDelete();
        this.removeAllParametersDuringDelete();
        this.setTheCase(null);
        this.setTheChain(null);
        this.setTheOperator(null);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getParameters());
        return ret;
    }

    private void removeAllSuccessorsDuringDelete() throws M4Exception {
        Collection suc = this.getSuccessors();
        if (suc != null && suc.size() > 0) {
            suc.clear();
            this.dependentStepsDirty = true;
        }
    }

    private void removeAllParametersDuringDelete() throws M4Exception {
        Collection col = this.getParameters();
        if (col != null && !col.isEmpty()) {
            Iterator it = ((AbstractList)new Vector(col)).iterator();
            while (it.hasNext()) {
                this.removeParameterTuple((Parameter)it.next());
            }
        }
    }

    public Collection getM4Trash() throws M4Exception {
        if (!this.allM4TrashLoaded && !this.isNew()) {
            this.allM4TrashLoaded = true;
            try {
                this.readM4TrashFromDb();
            }
            catch (SQLException e) {
                throw new M4Exception("SQLException caught when trying to read M4Trash information from DB:\n" + e.getMessage());
            }
        }
        return this.myM4Trash;
    }

    public void addToTrash(M4Data m4data) throws M4Exception {
        if (m4data != null) {
            this.getM4Trash().add(m4data);
        }
        this.setM4TrashDirty();
    }

    public void deleteM4Trash() throws M4Exception {
        Iterator it = this.getM4Trash().iterator();
        while (it.hasNext()) {
            ((M4Data)it.next()).deleteSoon();
            it.remove();
        }
        this.isCompiled = false;
        this.setM4TrashDirty();
    }

    private void readM4TrashFromDb() throws M4Exception, SQLException {
        String sql = "SELECT m4id, m4table FROM m4trash_t WHERE stepid = " + this.getId();
        DB db = this.getM4Db();
        ResultSet rs = null;
        try {
            rs = this.executeM4SqlRead(sql);
            while (rs.next()) {
                Class<?> objClass;
                long objId = rs.getLong(M4_TRASH_ID);
                String table = rs.getString(M4_TRASH_OBJ_TABLE);
                if (table.equalsIgnoreCase("column_t")) {
                    Class<?> clazz = class$9;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("edu.udo.miningmart.m4.core.Column");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    objClass = clazz;
                } else if (table.equalsIgnoreCase("columnset_t")) {
                    Class<?> clazz = class$10;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    objClass = clazz;
                } else {
                    if (table.equals(" ")) {
                        this.isCompiled = true;
                        continue;
                    }
                    throw new M4Exception("Step.readM4TrashFromDb(): Found unsupported M4 table " + table + " in attribute " + M4_TRASH_OBJ_TABLE + " of table " + M4_TRASH_TABLE + "!");
                }
                try {
                    M4Data obj = (M4Data)db.getM4Object(objId, objClass);
                    if (obj == null) continue;
                    this.getM4Trash().add(obj);
                }
                catch (ParameterNotFoundException e) {
                    super.doPrint(9, "Garbage Collection for Step " + this.getId() + "did not find object with ID " + objId + " from table " + table + "!");
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var9_11 = null;
        DB.closeResultSet(rs);
    }

    private void setDbTrashDirty() {
        if (!this.dbTrashDirty) {
            this.dbTrashDirty = true;
            this.setDirty();
        }
    }

    public void addDatabaseObjectToTrash(String objectName, String schemaName, String objectType) throws M4Exception {
        String[] trashEntry = this.createDbTrashArray(objectName, schemaName, objectType);
        this.getDbTrash().add(trashEntry);
        this.setDbTrashDirty();
    }

    public void deleteDbTrash() throws M4Exception {
        Iterator it = this.getDbTrash().iterator();
        while (it.hasNext()) {
            String[] trashArray = (String[])it.next();
            String objectName = trashArray[0];
            String schemaName = trashArray[1];
            String objectType = trashArray[2];
            String query = null;
            if (objectType.equalsIgnoreCase(DBT_TYPE_TABLE)) {
                query = "DROP TABLE ";
            } else if (objectType.equalsIgnoreCase(DBT_TYPE_VIEW)) {
                query = "DROP VIEW ";
            } else if (objectType.equalsIgnoreCase(DBT_TYPE_FUNCTION)) {
                query = "DROP FUNCTION ";
            } else if (objectType.equalsIgnoreCase(DBT_TYPE_INDEX)) {
                query = "DROP INDEX ";
            } else {
                throw new M4Exception("Step.deleteDbTrash: Unknown object type '" + objectType + "'!");
            }
            if (schemaName != null) {
                query = String.valueOf(query) + schemaName + ".";
            }
            query = String.valueOf(query) + objectName;
            try {
                this.executeBusinessSqlWrite(query);
            }
            catch (M4Exception sqle) {
                this.doPrint(11, "WARNING: Error when attempting to remove a database object according to DBTrash_T: " + sqle.getMessage());
                try {
                    this.getM4Db().commitBusinessTransactions();
                }
                catch (DbConnectionClosed dbc) {
                    throw new M4Exception("Closed Db connection during trash deletion: " + dbc.getMessage());
                }
                catch (SQLException se) {
                    throw new M4Exception("Error trying to commit transactions during trash deletion: " + se.getMessage());
                }
            }
            it.remove();
            this.setDbTrashDirty();
        }
    }

    private Collection getDbTrash() throws M4Exception {
        if (!this.allDbTrashLoaded && !this.isNew()) {
            this.allDbTrashLoaded = true;
            this.readDbTrashFromDb();
        }
        return this.myDbTrash;
    }

    private void readDbTrashFromDb() throws M4Exception {
        String sql = "SELECT ObjName, SchemaName, ObjType FROM dbtrash_t WHERE StepId = " + this.getId();
        ResultSet rs = null;
        try {
            try {
                rs = this.executeM4SqlRead(sql);
                while (rs.next()) {
                    String[] trashEntry = this.createDbTrashArray(rs.getString(ATTRIB_DBT_OBJNAME), rs.getString(ATTRIB_DBT_SCHEMA), rs.getString(ATTRIB_DBT_OBJTYPE));
                    this.myDbTrash.add(trashEntry);
                }
            }
            catch (SQLException e) {
                this.doPrint(11, "WARNING: Error when attempting to read a database object from dbtrash_t for step " + this.getId() + ":\n" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var4_7 = null;
        DB.closeResultSet(rs);
    }

    private void writeDbTrashToDb() throws M4Exception {
        if (this.dbTrashDirty) {
            String query = "DELETE FROM dbtrash_t WHERE StepId = " + this.getId();
            this.executeM4SqlWrite(query);
            String attributes = "ObjType, ObjName, SchemaName, StepId";
            Iterator it = this.getDbTrash().iterator();
            while (it.hasNext()) {
                String[] trashArray = (String[])it.next();
                String objectName = trashArray[0];
                String schemaName = trashArray[1];
                String objectType = trashArray[2];
                schemaName = schemaName == null || schemaName.equals("") ? "NULL" : DB.quote(schemaName);
                query = "INSERT INTO dbtrash_t (ObjType, ObjName, SchemaName, StepId) VALUES (" + DB.quote(objectType) + ", " + DB.quote(objectName) + ", " + schemaName + ", " + this.getId() + ")";
                this.executeM4SqlWrite(query);
            }
        }
        this.dbTrashDirty = false;
    }

    private String[] createDbTrashArray(String objectName, String schemaName, String objectType) throws M4Exception {
        if (!(objectType.equals(DBT_TYPE_FUNCTION) || objectType.equals(DBT_TYPE_INDEX) || objectType.equals(DBT_TYPE_TABLE) || objectType.equals(DBT_TYPE_VIEW))) {
            throw new M4Exception("Error adding a database object to trash: Unknown type: " + objectType + "!");
        }
        if (schemaName != null && schemaName.length() == 0) {
            schemaName = null;
        }
        String[] trashEntry = new String[]{objectName, schemaName, objectType};
        return trashEntry;
    }

    public boolean isCompiled() throws M4Exception {
        this.getM4Trash();
        return this.isCompiled;
    }

    public void setCompiled() throws M4Exception {
        this.getM4Trash();
        this.isCompiled = true;
        this.setM4TrashDirty();
    }

    private void setM4TrashDirty() {
        this.m4trashDirty = true;
        this.setDirty();
    }

    private void writeM4TrashToDb() throws M4Exception {
        if (this.m4trashDirty) {
            this.m4trashDirty = false;
            String delSql = "DELETE FROM m4trash_t WHERE stepid = " + this.getId();
            this.executeM4SqlWrite(delSql);
            String sqlPre = "INSERT INTO m4trash_t ( m4id, m4table, stepid ) VALUES ( ";
            String sqlPost = ", " + this.getId() + " )";
            Iterator it = this.getM4Trash().iterator();
            while (it.hasNext()) {
                M4Data m4data = (M4Data)it.next();
                if (m4data.isWaitingForDelete()) continue;
                long objId = m4data.getId();
                String table = m4data.getM4TableName();
                String sql = "INSERT INTO m4trash_t ( m4id, m4table, stepid ) VALUES ( " + objId + ", " + DB.quote(table) + sqlPost;
                this.executeM4SqlWrite(sql);
            }
            if (this.isCompiled()) {
                String sql = "INSERT INTO m4trash_t ( m4id, m4table, stepid ) VALUES ( 0, ' '" + sqlPost;
                this.executeM4SqlWrite(sql);
            }
        }
    }
}

